/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.librarymanager;

import com.aptana.ide.librarymanager.LibraryInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class LibraryManager {
    private static LibraryManager instance;
    private LibraryInfo[] cachedList = null;

    public static LibraryManager getInstance() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    private LibraryManager() {
    }

    public LibraryInfo[] getLibraryInfoExtensions() {
        if (this.cachedList == null) {
            this.cachedList = this.findLibraryInfoExtensions();
        }
        return this.cachedList;
    }

    private LibraryInfo[] findLibraryInfoExtensions() {
        ArrayList<LibraryInfo> list = new ArrayList<LibraryInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.aptana.ide.projects.library");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurations = extension.getConfigurationElements();
                int j = 0;
                while (j < configurations.length) {
                    IConfigurationElement element = configurations[j];
                    try {
                        String iconFile;
                        URL unresolved;
                        IExtension declaring = element.getDeclaringExtension();
                        String declaringPluginID = declaring.getNamespaceIdentifier();
                        Bundle bunble = Platform.getBundle((String)declaringPluginID);
                        LibraryInfo libraryInfo = new LibraryInfo();
                        String name = element.getAttribute("name");
                        libraryInfo.setName(name);
                        String directory = element.getAttribute("directory");
                        if (directory != null && (unresolved = FileLocator.find((Bundle)bunble, (IPath)new Path(directory), null)) != null) {
                            libraryInfo.setUnresolvedURL(unresolved);
                        }
                        if ((iconFile = element.getAttribute("iconFile")) != null && iconFile.length() > 0) {
                            String resolvedPath = this.getResolvedFilename(bunble, iconFile);
                            libraryInfo.setIconFile(resolvedPath);
                        }
                        if (directory != null && name != null) {
                            list.add(libraryInfo);
                        }
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(list, new Comparator<LibraryInfo>(){

            @Override
            public int compare(LibraryInfo o1, LibraryInfo o2) {
                if (o1 != null && o1.getName() != null && o2 != null && o2.getName() != null) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return 0;
            }
        });
        return list.toArray(new LibraryInfo[0]);
    }

    private String getResolvedFilename(Bundle b, String fullPath) {
        URL url = this.getResolvedURL(b, fullPath);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    private URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

