/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class FileSystemPasteAction
extends BaseSelectionListenerAction {
    public static final String ID = "com.aptana.ide.ui.io.PasteAction";
    private Shell fShell;
    private Clipboard fClipboard;
    private IFileStore[] fClipboardData;
    private List<IFileStore> fDestFileStores;

    public FileSystemPasteAction(Shell shell, Clipboard clipboard) {
        super(Messages.FileSystemPasteAction_TXT);
        this.fShell = shell;
        this.fClipboard = clipboard;
        this.fDestFileStores = new ArrayList<IFileStore>();
        this.setToolTipText(Messages.FileSystemPasteAction_TTP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    public void run() {
        JobChangeAdapter jobAdapter = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IOUIPlugin.refreshNavigatorView(FileSystemPasteAction.this.getStructuredSelection().getFirstElement());
            }
        };
        if (this.fClipboardData != null && this.fClipboardData.length > 0 && this.fDestFileStores.size() > 0) {
            CopyFilesOperation operation = new CopyFilesOperation(this.fShell);
            operation.copyFiles((IAdaptable[])this.fClipboardData, this.fDestFileStores.get(0), (IJobChangeListener)jobAdapter);
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.fClipboard.getContents((Transfer)fileTransfer);
        if (fileData != null && fileData.length > 0 && this.fDestFileStores.size() > 0) {
            CopyFilesOperation operation = new CopyFilesOperation(this.fShell);
            operation.copyFiles(fileData, this.fDestFileStores.get(0), (IJobChangeListener)jobAdapter);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object[] elements;
        this.fDestFileStores.clear();
        this.fClipboardData = new IFileStore[0];
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = elements = selection.toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IFileStore fileStore = FileSystemUtils.getFileStore(element);
            if (fileStore != null) {
                this.fDestFileStores.add(fileStore);
            }
            ++n2;
        }
        if (this.fDestFileStores.size() == 0) {
            return false;
        }
        this.fShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                Object contents = FileSystemPasteAction.this.fClipboard.getContents((Transfer)transfer);
                if (contents instanceof StructuredSelection) {
                    Object[] elements = ((StructuredSelection)contents).toArray();
                    ArrayList<IFileStore> fileStores = new ArrayList<IFileStore>();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IFileStore) {
                            fileStores.add((IFileStore)element);
                        }
                        ++n2;
                    }
                    FileSystemPasteAction.this.fClipboardData = fileStores.toArray(new IFileStore[fileStores.size()]);
                }
            }
        });
        if (this.fClipboardData.length > 0) {
            return true;
        }
        TransferData[] transfers = this.fClipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i = 0;
        while (i < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

