/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.ide.ui.io.navigator.DeferredTreeContentManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.progress.UIJob;

public class DeferredTreeSelectionExpander
extends JobChangeAdapter {
    private DeferredTreeContentManager deferredTreeContentManager;
    private AbstractTreeViewer viewer;
    private TreePath treePath;
    private int currentSegment;
    private Job job;

    public DeferredTreeSelectionExpander(DeferredTreeContentManager dtContentManager, AbstractTreeViewer treeViewer) {
        this.deferredTreeContentManager = dtContentManager;
        this.viewer = treeViewer;
        this.job = new UIJob("Expand tree job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DeferredTreeSelectionExpander.this.treePath == null) {
                    return Status.CANCEL_STATUS;
                }
                if (DeferredTreeSelectionExpander.this.viewer.getExpandedState((Object)DeferredTreeSelectionExpander.subTreePath(DeferredTreeSelectionExpander.this.treePath, DeferredTreeSelectionExpander.this.currentSegment))) {
                    DeferredTreeSelectionExpander.this.deferredTreeContentManager.addUpdateCompleteListener((IJobChangeListener)DeferredTreeSelectionExpander.this);
                    TreePath treePath = DeferredTreeSelectionExpander.this.treePath;
                    DeferredTreeSelectionExpander deferredTreeSelectionExpander = DeferredTreeSelectionExpander.this;
                    int n = deferredTreeSelectionExpander.currentSegment + 1;
                    deferredTreeSelectionExpander.currentSegment = n;
                    TreePath subTreePath = DeferredTreeSelectionExpander.subTreePath(treePath, n);
                    while (DeferredTreeSelectionExpander.this.viewer.getExpandedState((Object)subTreePath)) {
                        TreePath treePath2 = DeferredTreeSelectionExpander.this.treePath;
                        DeferredTreeSelectionExpander deferredTreeSelectionExpander2 = DeferredTreeSelectionExpander.this;
                        int n2 = deferredTreeSelectionExpander2.currentSegment + 1;
                        deferredTreeSelectionExpander2.currentSegment = n2;
                        subTreePath = DeferredTreeSelectionExpander.subTreePath(treePath2, n2);
                    }
                    DeferredTreeSelectionExpander.this.viewer.expandToLevel((Object)subTreePath, 1);
                    if (!DeferredTreeSelectionExpander.this.deferredTreeContentManager.isDeferredAdapter(DeferredTreeSelectionExpander.this.treePath.getSegment(DeferredTreeSelectionExpander.this.currentSegment - 1))) {
                        DeferredTreeSelectionExpander.this.done(null);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(true);
        this.job.setPriority(10);
    }

    public void setSelection(TreePath treePath) {
        this.treePath = treePath;
        if (treePath.getSegmentCount() > 1) {
            this.deferredTreeContentManager.addUpdateCompleteListener((IJobChangeListener)this);
            this.currentSegment = 1;
            this.viewer.expandToLevel((Object)DeferredTreeSelectionExpander.subTreePath(treePath, 1), 1);
            if (!this.deferredTreeContentManager.isDeferredAdapter(treePath.getSegment(this.currentSegment - 1))) {
                this.done(null);
            }
        } else {
            this.viewer.setSelection((ISelection)new TreeSelection(treePath));
            treePath = null;
        }
    }

    public boolean isDone() {
        return this.treePath == null;
    }

    public void done(IJobChangeEvent event) {
        this.deferredTreeContentManager.addUpdateCompleteListener(null);
        if (this.treePath == null) {
            return;
        }
        this.viewer.reveal((Object)DeferredTreeSelectionExpander.subTreePath(this.treePath, this.currentSegment));
        if (this.currentSegment + 1 < this.treePath.getSegmentCount()) {
            if (this.job.getState() == 4 || this.job.cancel()) {
                this.job.schedule(500L);
            }
            return;
        }
        this.viewer.setSelection((ISelection)new TreeSelection(this.treePath));
        this.treePath = null;
    }

    private static TreePath subTreePath(TreePath treePath, int segments) {
        Object[] list = new Object[segments];
        int i = 0;
        while (i < list.length) {
            list[i] = treePath.getSegment(i);
            ++i;
        }
        return new TreePath(list);
    }
}

