/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.dialogs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.GenericConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.PixelConverter;
import com.aptana.ide.ui.IPropertyDialog;
import com.aptana.ide.ui.io.IOUIPlugin;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenericConnectionPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final String DEFAULT_NAME = "New Connection";
    private GenericConnectionPoint genericConnectionPoint;
    private boolean isNew = false;
    private Text nameText;
    private Text uriText;
    private ModifyListener modifyListener;

    public GenericConnectionPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setPropertySource(Object element) {
        this.genericConnectionPoint = null;
        if (element instanceof GenericConnectionPoint) {
            this.genericConnectionPoint = (GenericConnectionPoint)element;
        }
    }

    public Object getPropertySource() {
        return this.genericConnectionPoint;
    }

    private String getConnectionPointType() {
        return "generic";
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        if (this.genericConnectionPoint != null) {
            this.setTitle("Edit the Connection");
            this.getShell().setText("Edit Connection");
        } else {
            this.setTitle("Create a Connection");
            this.getShell().setText(DEFAULT_NAME);
        }
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).numColumns(2).create());
        Label label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)"Name"));
        this.nameText = new Text(container, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)"URI"));
        this.uriText = new Text(container, 2052);
        this.uriText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.addListeners();
        if (this.genericConnectionPoint == null) {
            try {
                this.genericConnectionPoint = (GenericConnectionPoint)CoreIOPlugin.getConnectionPointManager().createConnectionPoint(this.getConnectionPointType());
                this.genericConnectionPoint.setName(DEFAULT_NAME);
                this.isNew = true;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)"Create new connection failed", (Throwable)e);
                this.close();
            }
        }
        this.loadPropertiesFrom(this.genericConnectionPoint);
        return dialogArea;
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GenericConnectionPropertyDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.uriText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.uriText.removeModifyListener(this.modifyListener);
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        this.savePropertiesTo(this.genericConnectionPoint);
        if (this.isNew) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint((IConnectionPoint)this.genericConnectionPoint);
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.validate();
        }
    }

    protected void loadPropertiesFrom(GenericConnectionPoint connectionPoint) {
        this.removeListeners();
        try {
            this.nameText.setText(GenericConnectionPropertyDialog.valueOrEmpty(connectionPoint.getName()));
            URI uri = connectionPoint.getURI();
            this.uriText.setText(uri != null ? uri.toString() : "");
        }
        finally {
            this.addListeners();
        }
    }

    protected boolean savePropertiesTo(GenericConnectionPoint connectionPoint) {
        URI uri;
        boolean updated = false;
        String name = this.nameText.getText();
        if (!name.equals(connectionPoint.getName())) {
            connectionPoint.setName(name);
            updated = true;
        }
        if (!(uri = URI.create(this.uriText.getText())).equals(connectionPoint.getURI())) {
            connectionPoint.setURI(uri);
            updated = true;
        }
        return updated;
    }

    public void validate() {
        boolean valid = this.isValid();
        this.getButton(0).setEnabled(valid);
    }

    public boolean isValid() {
        String message = null;
        if (this.nameText.getText().length() == 0) {
            message = "Please specify shortcut name";
        } else {
            try {
                if (!URI.create(this.uriText.getText()).isAbsolute()) {
                    message = "Please specify a valid absolute URI";
                }
            }
            catch (Exception exception) {
                message = "Please specify a valid URI";
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    protected static String valueOrEmpty(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }
}

