/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.auth;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordPromptDialog
extends TitleAreaDialog {
    private String title;
    private String message;
    private String login;
    private char[] password;
    private boolean savePassword;
    private Image titleImage;
    private Text loginText;
    private Text passwordText;
    private Button savePasswordButton;

    public PasswordPromptDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = IOUIPlugin.getImageDescriptor("/icons/full/wizban/security.png").createImage();
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PasswordPromptDialog.this.titleImage != null) {
                    PasswordPromptDialog.this.setTitleImage(null);
                    PasswordPromptDialog.this.titleImage.dispose();
                    PasswordPromptDialog.this.titleImage = null;
                }
            }
        });
        this.setTitleImage(this.titleImage);
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).numColumns(2).create());
        Label label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(StringUtils.makeFormLabel((String)"User Name"));
        this.loginText = new Text(container, 2052);
        this.loginText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.login != null) {
            this.loginText.setText(this.login);
        }
        this.loginText.setEnabled(false);
        label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(StringUtils.makeFormLabel((String)"Password"));
        this.passwordText = new Text(container, 0x400804);
        this.passwordText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.password != null) {
            this.passwordText.setText(String.copyValueOf(this.password));
        }
        new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.savePasswordButton = new Button(container, 32);
        this.savePasswordButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.savePasswordButton.setText("&Save Password (secure)");
        this.savePasswordButton.setSelection(this.savePassword);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText("Login");
    }

    protected void okPressed() {
        this.password = this.passwordText.getText().toCharArray();
        this.savePassword = this.savePasswordButton.getSelection();
        super.okPressed();
    }
}

