/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.ConnectionActionDelegate;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;

public class DeleteConnectionAction
extends ConnectionActionDelegate {
    public void run(IAction action) {
        final IConnectionPoint[] connections = this.getSelectedConnectionPoints();
        if (connections.length == 0) {
            return;
        }
        Job job = new Job("Deleting connection(s)"){

            protected IStatus run(IProgressMonitor monitor) {
                IConnectionPoint[] iConnectionPointArray = connections;
                int n = connections.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionPoint connection = iConnectionPointArray[n2];
                    monitor.subTask(MessageFormat.format("Deleting {0}", connection));
                    CoreIOPlugin.getConnectionPointManager().removeConnectionPoint(connection);
                    if (connection.canDisconnect()) {
                        try {
                            connection.disconnect(monitor);
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)"Disconnect failed", (Throwable)e);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.setRule((ISchedulingRule)this.connectionPoint.getAdapter(ISchedulingRule.class));
        job.schedule();
    }
}

