/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.index.core;

import com.aptana.ide.index.core.IndexManager;
import com.aptana.ide.index.core.QueryResult;
import com.aptana.ide.internal.index.core.DiskIndex;
import com.aptana.ide.internal.index.core.MemoryIndex;
import com.aptana.ide.internal.index.core.ReadWriteMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private static final int MATCH_RULE_INDEX_MASK = 11;
    public static final char DEFAULT_SEPARATOR = '/';
    public char separator = (char)47;
    private MemoryIndex memoryIndex;
    private DiskIndex diskIndex;
    ReadWriteMonitor monitor;

    public Index(String path) throws IOException {
        IPath containerPath = IndexManager.getInstance().computeIndexLocation(path);
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        this.memoryIndex = new MemoryIndex();
        this.monitor = new ReadWriteMonitor();
        this.diskIndex = new DiskIndex(containerPathString);
        this.diskIndex.initialize();
    }

    public void addEntry(String category, String key, String documentPath) {
        this.memoryIndex.addEntry(category, key, documentPath);
    }

    public List<QueryResult> query(String[] categories, String key, int matchRule) throws IOException {
        Map<String, QueryResult> results;
        if (this.memoryIndex.shouldMerge() && this.monitor.exitReadEnterWrite()) {
            try {
                this.save();
            }
            finally {
                this.monitor.exitWriteEnterRead();
            }
        }
        int rule = matchRule & 0xB;
        if (this.memoryIndex.hasChanged()) {
            results = this.diskIndex.addQueryResults(categories, key, rule, this.memoryIndex);
            results = this.memoryIndex.addQueryResults(categories, key, rule, results);
        } else {
            results = this.diskIndex.addQueryResults(categories, key, rule, null);
        }
        if (results == null) {
            return null;
        }
        return new ArrayList<QueryResult>(results.values());
    }

    public static boolean isMatch(String pattern, String word, int matchRule) {
        if (pattern == null) {
            return true;
        }
        int patternLength = pattern.length();
        int wordLength = word.length();
        if (patternLength == 0) {
            return matchRule != 0;
        }
        switch (matchRule) {
            case 0: {
                return patternLength == wordLength && pattern.equalsIgnoreCase(word);
            }
            case 1: {
                return patternLength <= wordLength && word.toLowerCase().startsWith(pattern.toLowerCase());
            }
            case 2: {
                return Index.patternMatch(pattern.toLowerCase(), word.toLowerCase());
            }
            case 8: {
                return patternLength == wordLength && pattern.equals(word);
            }
            case 9: {
                return patternLength <= wordLength && word.startsWith(pattern);
            }
            case 10: {
                return Index.patternMatch(pattern, word);
            }
        }
        return false;
    }

    private static boolean patternMatch(String pattern, String word) {
        return pattern.equals("*");
    }

    public void save() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        int numberOfChanges = this.memoryIndex.numberOfChanges();
        this.diskIndex = this.diskIndex.mergeWith(this.memoryIndex);
        this.memoryIndex = new MemoryIndex();
        if (numberOfChanges > 1000) {
            System.gc();
        }
    }

    private boolean hasChanged() {
        return this.memoryIndex.hasChanged();
    }

    public void remove(String containerRelativePath) {
        this.memoryIndex.remove(containerRelativePath);
    }

    public void removeCategories(String ... categoryNames) {
        try {
            this.memoryIndex.removeCategories(categoryNames);
            this.diskIndex = this.diskIndex.removeCategories(categoryNames, this.memoryIndex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

