/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.ftp;

import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class Policy {
    private Policy() {
    }

    public static String generateAuthId(String proto, IBaseRemoteConnectionPoint connectionPoint) {
        return Policy.generateAuthId(proto, connectionPoint.getLogin(), connectionPoint.getHost(), connectionPoint.getPort());
    }

    public static String generateAuthId(String proto, String login, String host, int port) {
        if (host != null && host.length() > 0 && port > 0 && login != null && login.length() > 0) {
            return MessageFormat.format("{0}/{1}@{2}:{3}", proto, login, host, Integer.toString(port));
        }
        return null;
    }

    public static long permissionsFromString(String string) {
        long permissions = 0L;
        if (string != null && string.length() >= 10) {
            int index = 1;
            permissions |= string.charAt(index++) == 'r' ? 256L : 0L;
            permissions |= string.charAt(index++) == 'w' ? 128L : 0L;
            permissions |= string.charAt(index++) == 'x' ? 64L : 0L;
            permissions |= string.charAt(index++) == 'r' ? 32L : 0L;
            permissions |= string.charAt(index++) == 'w' ? 16L : 0L;
            permissions |= string.charAt(index++) == 'x' ? 8L : 0L;
            permissions |= string.charAt(index++) == 'r' ? 4L : 0L;
            permissions |= string.charAt(index++) == 'w' ? 2L : 0L;
            permissions |= string.charAt(index++) == 'x' ? 1L : 0L;
        }
        return permissions;
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

