/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.ftp;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.ExtendedFileInfo;
import com.aptana.ide.filesystem.ftp.BaseFTPConnectionFileManager;
import com.aptana.ide.filesystem.ftp.ExpiringMap;
import com.aptana.ide.filesystem.ftp.FTPFileDownloadInputStream;
import com.aptana.ide.filesystem.ftp.FTPFileUploadOutputStream;
import com.aptana.ide.filesystem.ftp.FTPPlugin;
import com.aptana.ide.filesystem.ftp.IFTPConnectionFileManager;
import com.aptana.ide.filesystem.ftp.Messages;
import com.aptana.ide.filesystem.ftp.Policy;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPConnectionClosedException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

class FTPConnectionFileManager
extends BaseFTPConnectionFileManager
implements IFTPConnectionFileManager {
    private static final String TMP_TIMEZONE_CHECK = "_tmp_tz_check";
    private static final String WINDOWS_STR = "WINDOWS";
    protected FTPClient ftpClient;
    private List<String> serverFeatures;
    protected String transferType;
    protected String timezone;
    protected IPath cwd;
    private FTPFileFactory fileFactory;
    private Boolean statSupported = null;
    private Boolean chmodSupported = null;
    private Boolean chgrpSupported = null;
    private Map<IPath, FTPFile> ftpFileCache = new ExpiringMap<IPath, FTPFile>(60000L);
    private long serverTimeZoneShift = Integer.MIN_VALUE;
    protected boolean hasServerInfo;
    protected PrintWriter messageLogWriter;
    private int connectionRetryCount;

    FTPConnectionFileManager() {
    }

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean passive, String transferType, String encoding, String timezone) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)Messages.FTPConnectionFileManager_already_initialized);
        try {
            this.ftpClient = new FTPClient();
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password == null ? new char[]{} : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = Policy.generateAuthId("FTP", login, host, port);
            this.transferType = transferType;
            this.timezone = timezone != null && timezone.length() == 0 ? null : timezone;
            FTPConnectionFileManager.initFTPClient(this.ftpClient, passive, encoding);
        }
        catch (Exception e) {
            IdeLog.logImportant((Plugin)FTPPlugin.getDefault(), (String)Messages.FTPConnectionFileManager_initialization_failed, (Throwable)e);
            this.ftpClient = null;
        }
    }

    protected static void initFTPClient(FTPClient ftpClient, boolean passive, String encoding) throws IOException, FTPException {
        ftpClient.setTimeout(20000);
        ftpClient.setControlEncoding(encoding);
        ftpClient.setMonitorInterval(1024L);
        ftpClient.setConnectMode(passive ? FTPConnectMode.PASV : FTPConnectMode.ACTIVE);
        ftpClient.setRetryCount(3);
        ftpClient.setRetryDelay(5000);
        ftpClient.setServerWakeupInterval(15000);
        ftpClient.setDeleteOnFailure(true);
        ftpClient.setTransferBufferSize(32768);
    }

    protected static void setMessageLogger(FTPClient ftpClient, final PrintWriter writer) {
        FTPMessageListener listener = null;
        if (writer != null && ftpClient.getMessageListener() == null) {
            listener = new FTPMessageListener(){

                public void logCommand(String command) {
                    Matcher matcher;
                    if (command.startsWith("---> ")) {
                        command = command.substring(5);
                    }
                    if ((matcher = PASS_COMMAND_PATTERN.matcher(command)).matches()) {
                        command = matcher.replaceFirst("$1********");
                    }
                    writer.print("ftp> ");
                    writer.println(command);
                    writer.flush();
                }

                public void logReply(String reply) {
                    writer.println(reply);
                    writer.flush();
                }
            };
        }
        ftpClient.setMessageListener(listener);
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)Messages.FTPConnectionFileManager_not_initialized);
        monitor = Policy.monitorFor(monitor);
        try {
            this.cwd = null;
            this.cleanup();
            ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
            if (this.messageLogWriter == null) {
                if (context != null) {
                    Object object = context.get((Object)"command_log");
                    if (object instanceof PrintWriter) {
                        this.messageLogWriter = (PrintWriter)object;
                    } else if (object instanceof OutputStream) {
                        this.messageLogWriter = new PrintWriter((OutputStream)object);
                    }
                }
                if (this.messageLogWriter == null) {
                    this.messageLogWriter = FTPPlugin.getDefault().getFTPLogWriter();
                }
                if (this.messageLogWriter != null) {
                    this.messageLogWriter.println(StringUtils.format((String)"---------- FTP {0} ----------", (String)this.host));
                    FTPConnectionFileManager.setMessageLogger(this.ftpClient, this.messageLogWriter);
                }
            } else {
                this.messageLogWriter.println(StringUtils.format((String)"---------- RECONNECTING - FTP {0} ----------", (String)this.host));
            }
            monitor.beginTask(Messages.FTPConnectionFileManager_establishing_connection, -1);
            this.ftpClient.setRemoteHost(this.host);
            this.ftpClient.setRemotePort(this.port);
            while (true) {
                monitor.subTask(Messages.FTPConnectionFileManager_connecting);
                this.ftpClient.connect();
                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                    this.getOrPromptPassword(StringUtils.format((String)Messages.FTPConnectionFileManager_ftp_auth, (String)this.host), Messages.FTPConnectionFileManager_specify_password);
                }
                Policy.checkCanceled(monitor);
                monitor.subTask(Messages.FTPConnectionFileManager_authenticating);
                try {
                    this.ftpClient.login(this.login, String.copyValueOf(this.password));
                }
                catch (FTPException e) {
                    Policy.checkCanceled(monitor);
                    if ("331".equals(this.ftpClient.getLastValidReply().getReplyCode())) {
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", StringUtils.format((String)"Authentication failed: {0}", (String)e.getLocalizedMessage()), (Throwable)e));
                        }
                        this.promptPassword(StringUtils.format((String)Messages.FTPConnectionFileManager_ftp_auth, (String)this.host), Messages.FTPConnectionFileManager_invalid_password);
                        this.safeQuit();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            Policy.checkCanceled(monitor);
            this.changeCurrentDir(this.basePath);
            this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            if ((this.hasServerInfo || context != null && context.getBoolean("quick_connect")) && (context == null || !context.getBoolean("detect_timezone"))) {
                return;
            }
            try {
                this.getherServerInfo(context, monitor);
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", "Host name not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", "Remote folder not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", String.valueOf(Messages.FTPConnectionFileManager_connection_failed) + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void getherServerInfo(ConnectionContext context, IProgressMonitor monitor) {
        TimeZone tz;
        Policy.checkCanceled(monitor);
        monitor.subTask(Messages.FTPConnectionFileManager_gethering_server_info);
        try {
            this.serverFeatures = null;
            String[] features = this.ftpClient.features();
            if (features != null && features.length > 0) {
                this.serverFeatures = new ArrayList<String>();
                int i = 0;
                while (i < features.length) {
                    String feature = features[i].trim();
                    if (feature.indexOf(32) > 0) {
                        feature = feature.substring(0, feature.indexOf(32));
                    }
                    this.serverFeatures.add(feature);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        Policy.checkCanceled(monitor);
        FTPFile[] rootFiles = null;
        try {
            rootFiles = this.listFiles((IPath)Path.ROOT, monitor);
        }
        catch (Exception exception) {}
        if (context != null && context.getBoolean("detect_timezone")) {
            this.serverTimeZoneShift = Integer.MIN_VALUE;
        } else if (this.timezone != null && (tz = TimeZone.getTimeZone(this.timezone)) != null) {
            long time = new Date().getTime();
            this.serverTimeZoneShift = TimeZone.getDefault().getOffset(time) - tz.getOffset(time);
        }
        if (this.serverTimeZoneShift == Integer.MIN_VALUE) {
            Policy.checkCanceled(monitor);
            try {
                FTPFile[] fTPFileArray;
                int n;
                this.changeCurrentDir((IPath)Path.ROOT);
                FTPFile file = null;
                if (rootFiles != null) {
                    FTPFile[] fTPFileArray2 = rootFiles;
                    n = rootFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FTPFile ftpFile = fTPFileArray2[n2];
                        if (ftpFile.isFile() && !ftpFile.getName().startsWith(".ht") && (ftpFile.lastModified().getHours() != 0 || ftpFile.lastModified().getMinutes() != 0 || ftpFile.lastModified().getSeconds() != 0)) {
                            file = ftpFile;
                            break;
                        }
                        ++n2;
                    }
                }
                if (file == null && !Path.ROOT.equals((Object)this.basePath)) {
                    FTPFile[] ftpFiles;
                    fTPFileArray = ftpFiles = this.listFiles(this.basePath, monitor);
                    int n3 = ftpFiles.length;
                    n = 0;
                    while (n < n3) {
                        FTPFile ftpFile = fTPFileArray[n];
                        if (ftpFile.isFile() && !ftpFile.getName().startsWith(".ht") && (ftpFile.lastModified().getHours() != 0 || ftpFile.lastModified().getMinutes() != 0 || ftpFile.lastModified().getSeconds() != 0)) {
                            file = ftpFile;
                            break;
                        }
                        ++n;
                    }
                }
                Date lastModifiedLocal = null;
                if (file == null) {
                    this.changeCurrentDir(this.basePath);
                    lastModifiedLocal = new Date();
                    this.ftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), TMP_TIMEZONE_CHECK);
                    fTPFileArray = this.listFiles(this.basePath, monitor);
                    int n4 = fTPFileArray.length;
                    n = 0;
                    while (n < n4) {
                        FTPFile ftpFile = fTPFileArray[n];
                        if (TMP_TIMEZONE_CHECK.equals(ftpFile.getName())) {
                            file = ftpFile;
                            break;
                        }
                        ++n;
                    }
                }
                Date lastModifiedServerInLocalTZ = file.lastModified();
                if (file != null) {
                    Date lastModifiedLocalTZ;
                    if (this.serverSupportsFeature("MDTM") && (lastModifiedLocalTZ = this.ftpClient.modtime(file.getName())) != null) {
                        this.serverTimeZoneShift = lastModifiedLocalTZ.getTime() - lastModifiedLocalTZ.getTime() % 60000L - (lastModifiedServerInLocalTZ.getTime() - lastModifiedServerInLocalTZ.getTime() % 60000L);
                    }
                    if (this.serverTimeZoneShift == Integer.MIN_VALUE) {
                        this.serverTimeZoneShift = lastModifiedLocal.getTime() - lastModifiedLocal.getTime() % 60000L - (lastModifiedServerInLocalTZ.getTime() - lastModifiedServerInLocalTZ.getTime() % 60000L);
                        long rem = this.serverTimeZoneShift % 900000L;
                        this.serverTimeZoneShift = rem < 450000L ? (this.serverTimeZoneShift -= rem) : (this.serverTimeZoneShift += 900000L - rem);
                    }
                    if (TMP_TIMEZONE_CHECK.equals(file.getName())) {
                        this.ftpClient.delete(file.getName());
                    }
                    if (context != null) {
                        Calendar cal = Calendar.getInstance();
                        int rawOffset = (int)((long)(cal.get(15) + cal.get(16)) - this.serverTimeZoneShift);
                        context.put((Object)"server_timezone", (Object)TimeZone.getAvailableIDs(rawOffset));
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                IdeLog.logImportant((Plugin)FTPPlugin.getDefault(), (String)Messages.FTPConnectionFileManager_server_tz_check, (Throwable)e);
            }
            if (this.serverTimeZoneShift == Integer.MIN_VALUE) {
                Calendar cal = Calendar.getInstance();
                this.serverTimeZoneShift = cal.get(15) + cal.get(16);
            }
        }
        this.hasServerInfo = true;
    }

    protected void safeQuit() {
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception exception) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception exception2) {}
        }
    }

    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.connected();
    }

    public synchronized void disconnect(IProgressMonitor monitor) throws CoreException {
        try {
            this.checkConnected();
        }
        catch (Exception exception) {}
        if (!this.isConnected()) {
            return;
        }
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(Messages.FTPConnectionFileManager_closing_connection, -1);
        try {
            try {
                this.ftpClient.quit();
            }
            catch (Exception e) {
                try {
                    this.ftpClient.quitImmediately();
                }
                catch (Exception exception) {}
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_disconnect_failed, (Throwable)e));
            }
        }
        finally {
            this.cwd = null;
            this.cleanup();
            monitor.done();
        }
    }

    private boolean serverSupportsFeature(String feature) {
        if (this.serverFeatures != null) {
            return this.serverFeatures.contains(feature);
        }
        return false;
    }

    protected void changeCurrentDir(IPath path) throws FTPException, IOException {
        try {
            if (this.cwd == null) {
                this.cwd = new Path(this.ftpClient.pwd());
            }
            if (!this.cwd.equals((Object)path)) {
                this.ftpClient.chdir(path.toPortableString());
                this.cwd = path;
            }
        }
        catch (FTPException e) {
            FTPConnectionFileManager.throwFileNotFound(e, path);
        }
        catch (IOException e) {
            this.cwd = null;
            throw e;
        }
    }

    private static void throwFileNotFound(FTPException e, IPath path) throws FileNotFoundException, FTPException {
        int code = e.getReplyCode();
        if (code == 550 || code == 450) {
            throw new FileNotFoundException(path.toPortableString());
        }
        throw e;
    }

    private static void fillFileInfo(ExtendedFileInfo fileInfo, FTPFile ftpFile) {
        fileInfo.setExists(true);
        fileInfo.setName(ftpFile.getName());
        fileInfo.setDirectory(ftpFile.isDir());
        fileInfo.setLength(ftpFile.size());
        fileInfo.setLastModified(ftpFile.lastModified() != null ? ftpFile.lastModified().getTime() : 0L);
        fileInfo.setOwner(ftpFile.getOwner());
        fileInfo.setGroup(ftpFile.getGroup());
        fileInfo.setPermissions(Policy.permissionsFromString(ftpFile.getPermissions()));
        if (ftpFile.isLink()) {
            fileInfo.setAttribute(32, true);
            fileInfo.setStringAttribute(64, ftpFile.getLinkedName().trim());
        }
    }

    private static ExtendedFileInfo createFileInfo(FTPFile ftpFile) {
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(ftpFile.getName());
        FTPConnectionFileManager.fillFileInfo(fileInfo, ftpFile);
        return fileInfo;
    }

    protected void clearCache(IPath path) {
        super.clearCache(path);
        path = this.basePath.append(path);
        int segments = path.segmentCount();
        for (IPath p : new ArrayList<IPath>(this.ftpFileCache.keySet())) {
            if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
            this.ftpFileCache.remove(p);
        }
    }

    protected void checkConnected() throws Exception {
        if (this.ftpClient.connected()) {
            try {
                this.ftpClient.noOperation();
                return;
            }
            catch (FTPConnectionClosedException fTPConnectionClosedException) {
            }
            catch (FTPException fTPException) {
                return;
            }
            catch (IOException iOException) {}
            this.ftpClient.quitImmediately();
        }
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("ftp", this.login, this.host, this.port != 21 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected ExtendedFileInfo fetchFile(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            IPath dirPath = path.removeLastSegments(1);
            String name = path.lastSegment();
            FTPFile result = this.ftpFileCache.get(path);
            if (result == null) {
                FTPFile[] ftpFiles;
                FTPFile[] fTPFileArray = ftpFiles = this.listFiles(dirPath, monitor);
                int n = ftpFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    FTPFile ftpFile = fTPFileArray[n2];
                    Date lastModifiedServerInLocalTZ = ftpFile.lastModified();
                    if (this.serverTimeZoneShift != 0L) {
                        ftpFile.setLastModified(new Date(lastModifiedServerInLocalTZ.getTime() + this.serverTimeZoneShift));
                    }
                    if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) {
                        if (Path.ROOT.equals((Object)path) && ".".equals(ftpFile.getName())) {
                            ftpFile.setName(path.toPortableString());
                            this.ftpFileCache.put(path, ftpFile);
                            result = ftpFile;
                        }
                    } else {
                        this.ftpFileCache.put(dirPath.append(ftpFile.getName()), ftpFile);
                        if (name != null && name.equalsIgnoreCase(ftpFile.getName())) {
                            result = ftpFile;
                        }
                    }
                    ++n2;
                }
            }
            if ((options & 0x400) != 0 && result != null && !result.isDir() && name != null && result.lastModified().getSeconds() == 0 && this.serverSupportsFeature("MDTM")) {
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    Date lastModifiedLocalTZ = this.ftpClient.modtime(name);
                    if (lastModifiedLocalTZ != null) {
                        result.setLastModified(lastModifiedLocalTZ);
                    }
                }
                catch (FTPException fTPException) {}
            }
            if (result == null && Path.ROOT.equals((Object)path)) {
                result = new FTPFile("", path.toPortableString(), 0L, true, new Date(0L));
            }
            if (result != null) {
                return FTPConnectionFileManager.createFileInfo(result);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.connectionRetryCount < 1) {
                ++this.connectionRetryCount;
                this.testOrConnect(monitor);
                return this.fetchFile(path, options, monitor);
            }
            this.connectionRetryCount = 0;
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_fetch_failed, (Throwable)e));
        }
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
        fileInfo.setExists(false);
        return fileInfo;
    }

    protected ExtendedFileInfo[] fetchFiles(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor = Policy.subMonitorFor(monitor, 1);
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            monitor.beginTask(Messages.FTPConnectionFileManager_gethering_file_details, ftpFiles.length);
            ArrayList<ExtendedFileInfo> list = new ArrayList<ExtendedFileInfo>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) {
                    monitor.worked(1);
                } else {
                    Date lastModifiedServerInLocalTZ = ftpFile.lastModified();
                    if (this.serverTimeZoneShift != 0L) {
                        ftpFile.setLastModified(new Date(lastModifiedServerInLocalTZ.getTime() + this.serverTimeZoneShift));
                    }
                    if ((options & 0x400) != 0 && !ftpFile.isDir() && ftpFile.lastModified().getSeconds() == 0 && this.serverSupportsFeature("MDTM")) {
                        this.changeCurrentDir(path);
                        Policy.checkCanceled(monitor);
                        try {
                            Date lastModifiedLocalTZ = this.ftpClient.modtime(ftpFile.getName());
                            if (lastModifiedLocalTZ != null) {
                                ftpFile.setLastModified(lastModifiedLocalTZ);
                            }
                        }
                        catch (FTPException fTPException) {}
                    }
                    IPath filePath = path.append(ftpFile.getName());
                    this.ftpFileCache.put(filePath, ftpFile);
                    ExtendedFileInfo fileInfo = FTPConnectionFileManager.createFileInfo(ftpFile);
                    list.add(fileInfo);
                    monitor.worked(1);
                }
                ++n2;
            }
            ExtendedFileInfo[] extendedFileInfoArray = list.toArray(new ExtendedFileInfo[list.size()]);
            return extendedFileInfoArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.connectionRetryCount < 1) {
                ++this.connectionRetryCount;
                this.testOrConnect(monitor);
                ExtendedFileInfo[] extendedFileInfoArray = this.fetchFiles(path, options, monitor);
                return extendedFileInfoArray;
            }
            this.connectionRetryCount = 0;
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_fetching_directory_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected String[] listDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> list = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (!".".equals(name) && !"..".equals(name)) {
                    this.ftpFileCache.put(path.append(ftpFile.getName()), ftpFile);
                    list.add(name);
                }
                ++n2;
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_listing_directory_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream readFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.FTPConnectionFileManager_initiating_download, 4);
        FTPClient downloadFtpClient = new FTPClient();
        try {
            FTPConnectionFileManager.initFTPClient(downloadFtpClient, this.ftpClient.getConnectMode() == FTPConnectMode.PASV, this.ftpClient.getControlEncoding());
            downloadFtpClient.setRemoteHost(this.host);
            downloadFtpClient.setRemotePort(this.port);
            Policy.checkCanceled(monitor);
            downloadFtpClient.connect();
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            downloadFtpClient.login(this.login, String.copyValueOf(this.password));
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            FTPConnectionFileManager.setMessageLogger(downloadFtpClient, this.messageLogWriter);
            downloadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            try {
                downloadFtpClient.chdir(path.removeLastSegments(1).toPortableString());
            }
            catch (FTPException e) {
                FTPConnectionFileManager.throwFileNotFound(e, path.removeLastSegments(1));
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            try {
                FTPFileDownloadInputStream fTPFileDownloadInputStream = new FTPFileDownloadInputStream(downloadFtpClient, (FileTransferInputStream)new FTPInputStream(downloadFtpClient, path.lastSegment()));
                return fTPFileDownloadInputStream;
            }
            catch (FTPException e) {
                try {
                    FTPConnectionFileManager.throwFileNotFound(e, path);
                }
                catch (Exception e2) {
                    FTPConnectionFileManager.setMessageLogger(downloadFtpClient, null);
                    if (downloadFtpClient.connected()) {
                        try {
                            if (e2 instanceof OperationCanceledException || e2 instanceof FTPException || e2 instanceof FileNotFoundException) {
                                downloadFtpClient.quit();
                            } else {
                                downloadFtpClient.quitImmediately();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (FTPException fTPException) {}
                    }
                    if (e2 instanceof OperationCanceledException) {
                        throw (OperationCanceledException)((Object)e2);
                    }
                    if (e2 instanceof FileNotFoundException) {
                        throw (FileNotFoundException)e2;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_opening_file_failed, (Throwable)e2));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream writeFile(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.FTPConnectionFileManager_initiating_file_upload, 4);
        FTPClient uploadFtpClient = new FTPClient();
        try {
            FTPConnectionFileManager.initFTPClient(uploadFtpClient, this.ftpClient.getConnectMode() == FTPConnectMode.PASV, this.ftpClient.getControlEncoding());
            uploadFtpClient.setRemoteHost(this.host);
            uploadFtpClient.setRemotePort(this.port);
            Policy.checkCanceled(monitor);
            uploadFtpClient.connect();
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            uploadFtpClient.login(this.login, String.copyValueOf(this.password));
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            FTPConnectionFileManager.setMessageLogger(uploadFtpClient, this.messageLogWriter);
            uploadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            IPath dirPath = path.removeLastSegments(1);
            try {
                uploadFtpClient.chdir(dirPath.toPortableString());
            }
            catch (FTPException e) {
                FTPConnectionFileManager.throwFileNotFound(e, dirPath);
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            FTPFileUploadOutputStream fTPFileUploadOutputStream = new FTPFileUploadOutputStream(uploadFtpClient, (FileTransferOutputStream)new FTPOutputStream(uploadFtpClient, FTPConnectionFileManager.generateTempFileName(path.lastSegment())), path.lastSegment(), null, permissions);
            return fTPFileUploadOutputStream;
        }
        catch (Exception e) {
            FTPConnectionFileManager.setMessageLogger(uploadFtpClient, null);
            if (uploadFtpClient.connected()) {
                try {
                    if (e instanceof OperationCanceledException || e instanceof FTPException || e instanceof FileNotFoundException) {
                        uploadFtpClient.quit();
                    } else {
                        uploadFtpClient.quitImmediately();
                    }
                }
                catch (IOException iOException) {
                }
                catch (FTPException fTPException) {}
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_opening_file_failed, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        MultiStatus status = new MultiStatus("com.aptana.ide.filesystem.ftp", 0, null, null);
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.recursiveDeleteTree(path, monitor, status);
                this.changeCurrentDir(dirPath);
                this.ftpClient.rmdir(path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                if (status.isOK()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_deleting_directory_failed, (Throwable)e));
                }
                MultiStatus multiStatus = new MultiStatus("com.aptana.ide.filesystem.ftp", 0, Messages.FTPConnectionFileManager_deleting_directory_failed, (Throwable)e);
                multiStatus.addAll((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.delete(path.lastSegment());
                }
                catch (FTPException e) {
                    System.out.println((Object)e);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", StringUtils.format((String)Messages.FTPConnectionFileManager_deleting_failed, (Object)path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(path);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    this.ftpClient.mkdir(path.toPortableString());
                    this.changeFilePermissions(path, PreferenceUtils.getDirectoryPermissions(), monitor);
                }
                catch (FTPException e) {
                    FTPConnectionFileManager.throwFileNotFound(e, path);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_creating_directory_failed, (Throwable)e));
        }
    }

    protected void renameFile(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir((IPath)Path.ROOT);
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.rename(sourcePath.toPortableString(), destinationPath.toPortableString());
                }
                catch (FTPException e) {
                    FTPConnectionFileManager.throwFileNotFound(e, sourcePath);
                    System.out.println((Object)e);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_renaming_failed, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void setModificationTime(IPath path, long modificationTime, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (!this.serverSupportsFeature("MFMT")) {
            return;
        }
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.ftpClient.setModTime(path.lastSegment(), new Date(modificationTime));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.FTPConnectionFileManager_set_modification_time_failed, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFilePermissions(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (this.chmodSupported == Boolean.FALSE) {
            return;
        }
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.chmodSupported = this.ftpClient.site("CHMOD " + Long.toOctalString(permissions) + " " + path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", "Set permissions failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFileGroup(IPath path, String group, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (this.chgrpSupported == Boolean.FALSE) {
            return;
        }
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.chgrpSupported = this.ftpClient.site("CHGRP " + group + " " + path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", "Set group failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private FTPFile[] ftpSTAT(String dirname) throws IOException, FTPException, ParseException {
        if (this.fileFactory == null) {
            try {
                this.fileFactory = new FTPFileFactory(this.ftpClient.system());
            }
            catch (FTPException fTPException) {
                this.fileFactory = new FTPFileFactory("");
            }
            this.fileFactory.setLocales(FTPClient.DEFAULT_LISTING_LOCALES);
        }
        String[] validCodes = new String[]{"211", "212", "213"};
        FTPReply reply = this.ftpClient.sendCommand("STAT " + dirname);
        this.ftpClient.validateReply(reply, validCodes);
        String[] data = reply.getReplyData();
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            ++i;
        }
        return this.fileFactory.parse(data);
    }

    private FTPFile[] ftpLIST(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException {
        this.changeCurrentDir(dirPath);
        Policy.checkCanceled(monitor);
        return this.ftpClient.dirDetails("-a");
    }

    private FTPFile[] listFiles(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException {
        FTPFile[] ftpFiles = null;
        if (this.statSupported != Boolean.FALSE) {
            block11: {
                try {
                    ftpFiles = this.ftpSTAT(dirPath.addTrailingSeparator().toPortableString());
                }
                catch (FTPException e) {
                    if (e.getReplyCode() == 501 || e.getReplyCode() == 502) {
                        this.statSupported = null;
                    }
                    if (e.getReplyCode() == 500) break block11;
                    FTPConnectionFileManager.throwFileNotFound(e, dirPath);
                }
            }
            if (ftpFiles == null || ftpFiles.length == 0) {
                if (this.statSupported == null) {
                    this.statSupported = Boolean.FALSE;
                }
                return this.ftpLIST(dirPath, monitor);
            }
            if (this.statSupported == null) {
                this.statSupported = Boolean.TRUE;
            }
        } else {
            ftpFiles = this.ftpLIST(dirPath, monitor);
        }
        if (this.fileFactory.getSystem().toUpperCase().startsWith(WINDOWS_STR) && ftpFiles != null) {
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                if (ftpFile.getPermissions() == null) {
                    ftpFile.setPermissions("-rw-r-----");
                }
                ++n2;
            }
        }
        return ftpFiles;
    }

    private void recursiveDeleteTree(IPath path, IProgressMonitor monitor, MultiStatus status) throws IOException, ParseException {
        try {
            this.changeCurrentDir(path);
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> dirs = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (!".".equals(name) && !"..".equals(name)) {
                    if (ftpFile.isDir()) {
                        dirs.add(name);
                    } else {
                        Policy.checkCanceled(monitor);
                        monitor.subTask(path.append(name).toPortableString());
                        try {
                            this.ftpClient.delete(name);
                        }
                        catch (FTPException e) {
                            status.add((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", StringUtils.format((String)Messages.FTPConnectionFileManager_deleting_failed, (String)path.append(name).toPortableString()), (Throwable)e));
                        }
                        monitor.worked(1);
                    }
                }
                ++n2;
            }
            for (String name : dirs) {
                monitor.subTask(path.append(name).toPortableString());
                this.recursiveDeleteTree(path.append(name), monitor, status);
                Policy.checkCanceled(monitor);
                this.changeCurrentDir(path);
                Policy.checkCanceled(monitor);
                this.ftpClient.rmdir(name);
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", StringUtils.format((String)Messages.FTPConnectionFileManager_deleting_failed, (String)path.toPortableString()), (Throwable)e));
        }
    }

    private static String generateTempFileName(String base) {
        StringBuffer sb = new StringBuffer();
        sb.append("_tmp_upload.").append(base);
        return sb.toString();
    }
}

