/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceSynchronizationUtils {
    public static final String LAST_SYNC_CONNECTION_KEY = "lastSyncConnection";
    public static final String REMEMBER_DECISION_KEY = "rememberDecision";

    public static boolean isRememberDecision(IContainer container) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            String remeberMyDecisionStringValue = container.getPersistentProperty(new QualifiedName("", REMEMBER_DECISION_KEY));
            if (remeberMyDecisionStringValue != null) {
                return Boolean.TRUE.toString().equals(remeberMyDecisionStringValue);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void setRememberDecision(IContainer container, boolean rememberMyDecision) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            container.setPersistentProperty(new QualifiedName("", REMEMBER_DECISION_KEY), String.valueOf(rememberMyDecision));
        }
        catch (CoreException coreException) {}
    }

    public static String getLastSyncConnection(IContainer container) {
        if (container == null) {
            throw new NullPointerException("Null resource container.");
        }
        try {
            return container.getPersistentProperty(new QualifiedName("", LAST_SYNC_CONNECTION_KEY));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setLastSyncConnection(IContainer container, String connection) {
        try {
            if (connection == null || connection.equals("")) {
                container.setPersistentProperty(new QualifiedName("", LAST_SYNC_CONNECTION_KEY), null);
            } else {
                container.setPersistentProperty(new QualifiedName("", LAST_SYNC_CONNECTION_KEY), connection);
            }
        }
        catch (CoreException coreException) {}
    }
}

