/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.secureftp.internal;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.PixelConverter;
import com.aptana.ide.filesystem.secureftp.ISFTPConnectionPoint;
import com.aptana.ide.ui.ftp.internal.IConnectionDialog;
import com.aptana.ide.ui.ftp.internal.IOptionsComposite;
import com.aptana.ide.ui.ftp.internal.NumberVerifyListener;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SFTPAdvancedOptionsComposite
extends Composite
implements IOptionsComposite {
    private IConnectionDialog connectionDialog;
    private Combo compressionCombo;
    private Text portText;
    private Combo encodingCombo;
    private ModifyListener modifyListener;

    public SFTPAdvancedOptionsComposite(Composite parent, int style, IConnectionDialog connectionDialog) {
        super(parent, style);
        this.connectionDialog = connectionDialog;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).spacing(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(4), new PixelConverter((Control)this).convertVerticalDLUsToPixels(4)).create());
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)"Compression"));
        this.compressionCombo = new Combo((Composite)this, 2060);
        this.compressionCombo.add("AUTO");
        this.compressionCombo.add("NONE");
        this.compressionCombo.add("ZLIB");
        this.compressionCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.compressionCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(StringUtils.makeFormLabel((String)"Port"));
        this.portText = new Text((Composite)this, 133124);
        this.portText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(new PixelConverter((Control)this.portText).convertWidthInCharsToPixels(5), this.portText.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)"Encoding"));
        this.encodingCombo = new Combo((Composite)this, 2060);
        this.encodingCombo.setItems(Charset.availableCharsets().keySet().toArray(new String[0]));
        this.encodingCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.encodingCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).span(4, 1).create());
        this.addListeners();
        this.portText.addVerifyListener((VerifyListener)new NumberVerifyListener());
    }

    public void loadPropertiesFrom(Object element) {
        Assert.isLegal((boolean)(element instanceof ISFTPConnectionPoint));
        ISFTPConnectionPoint sftpConnectionPoint = (ISFTPConnectionPoint)element;
        this.removeListeners();
        try {
            int index = this.compressionCombo.indexOf(String.valueOf(sftpConnectionPoint.getCompression()));
            if (index >= 0) {
                this.compressionCombo.select(index);
            }
            this.portText.setText(Integer.toString(sftpConnectionPoint.getPort()));
            index = this.encodingCombo.indexOf(String.valueOf(sftpConnectionPoint.getEncoding()));
            if (index >= 0) {
                this.encodingCombo.select(index);
            }
        }
        finally {
            this.addListeners();
        }
    }

    public boolean savePropertiesTo(Object element) {
        Assert.isLegal((boolean)(element instanceof ISFTPConnectionPoint));
        boolean updated = false;
        ISFTPConnectionPoint sftpConnectionPoint = (ISFTPConnectionPoint)element;
        String compression = this.compressionCombo.getItem(this.compressionCombo.getSelectionIndex());
        if (!sftpConnectionPoint.getCompression().equals(compression)) {
            sftpConnectionPoint.setCompression(compression);
            updated = true;
        }
        int port = Integer.parseInt(this.portText.getText());
        if (sftpConnectionPoint.getPort() != port) {
            sftpConnectionPoint.setPort(port);
            updated = true;
        }
        String encoding = this.encodingCombo.getItem(this.encodingCombo.getSelectionIndex());
        if (!sftpConnectionPoint.getEncoding().equals(encoding)) {
            sftpConnectionPoint.setEncoding(encoding);
            updated = true;
        }
        return updated;
    }

    public String isValid() {
        int port = 0;
        try {
            port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (port <= 0) {
            return "Please specify correct port number";
        }
        return null;
    }

    public void setValid(boolean valid) {
    }

    public void lockUI(boolean lock) {
        this.compressionCombo.setEnabled(!lock);
        this.portText.setEnabled(!lock);
        this.encodingCombo.setEnabled(!lock);
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SFTPAdvancedOptionsComposite.this.connectionDialog.validate();
                }
            };
        }
        this.portText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.portText.removeModifyListener(this.modifyListener);
        }
    }
}

