/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.internal.ui.preferences;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.internal.ui.preferences.TableViewerEditor;
import com.aptana.ide.editors.internal.ui.preferences.TodoTaskDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TodoPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TodoPreferencePage() {
        this.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
        this.setDescription("Description");
        this.setTitle("title");
    }

    private List<String> extract(String raw) {
        StringTokenizer tokenizer = new StringTokenizer(raw, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    protected void createFieldEditors() {
        TableViewerEditor taskEditor = new TableViewerEditor("Todo Tasks", this.getFieldEditorParent()){

            @Override
            protected Object createObject() {
                TodoTaskDialog dialog = new TodoTaskDialog(this.getShell(), null, this.fElements);
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return null;
            }

            @Override
            protected Object editObject(Object toEdit) {
                TodoTaskDialog dialog = new TodoTaskDialog(this.getShell(), (TodoTask)toEdit, this.fElements);
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return toEdit;
            }

            @Override
            protected TableViewerEditor.ColumnsDescription createTableColumns() {
                return new TableViewerEditor.ColumnsDescription(new String[]{"Tag", "Priority"}, true);
            }

            @Override
            protected void doLoadDefault() {
                if (this.fTableControl != null) {
                    List tags = TodoPreferencePage.this.extract(this.getPreferenceStore().getDefaultString("com.aptana.ide.editors.tasks.tags"));
                    List priorities = TodoPreferencePage.this.extract(this.getPreferenceStore().getDefaultString("com.aptana.ide.editors.tasks.priorities"));
                    int i = 0;
                    while (i < tags.size()) {
                        this.addElement(new TodoTask((String)tags.get(i), (String)priorities.get(i)));
                        ++i;
                    }
                }
            }

            @Override
            protected void doLoad() {
                if (this.fTableControl != null) {
                    List tags = TodoPreferencePage.this.extract(this.getPreferenceStore().getString("com.aptana.ide.editors.tasks.tags"));
                    List priorities = TodoPreferencePage.this.extract(this.getPreferenceStore().getString("com.aptana.ide.editors.tasks.priorities"));
                    int i = 0;
                    while (i < tags.size()) {
                        this.addElement(new TodoTask((String)tags.get(i), (String)priorities.get(i)));
                        ++i;
                    }
                }
            }

            @Override
            protected Map<String, String> createPrefMap(List<Object> elements) {
                HashMap<String, String> prefMap = new HashMap<String, String>();
                StringBuilder tagBuilder = new StringBuilder();
                StringBuilder priorityBuilder = new StringBuilder();
                for (Object element : elements) {
                    TodoTask task = (TodoTask)element;
                    tagBuilder.append(task.name).append(",");
                    priorityBuilder.append(task.priority).append(",");
                }
                if (!elements.isEmpty()) {
                    tagBuilder.deleteCharAt(tagBuilder.length() - 1);
                    priorityBuilder.deleteCharAt(priorityBuilder.length() - 1);
                }
                prefMap.put("com.aptana.ide.editors.tasks.tags", tagBuilder.toString());
                prefMap.put("com.aptana.ide.editors.tasks.priorities", priorityBuilder.toString());
                return prefMap;
            }

            @Override
            protected ITableLabelProvider createLabelProvider() {
                return new TodoTaskLabelProvider();
            }
        };
        taskEditor.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
        this.addField(taskEditor);
        BooleanFieldEditor caseSensitiveEditor = new BooleanFieldEditor("com.aptana.ide.editors.tasks.caseSensitive", "Case-sensitive", this.getFieldEditorParent());
        caseSensitiveEditor.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)caseSensitiveEditor);
    }

    public void init(IWorkbench workbench) {
    }

    static class TodoTask {
        String name;
        String priority;

        public TodoTask(String name, String priority) {
            this.name = name;
            this.priority = priority;
        }
    }

    private class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TodoTask task = (TodoTask)element;
            if (columnIndex == 0) {
                return task.name;
            }
            return task.priority;
        }
    }
}

