/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.editor.css.CSSErrorManager;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.js.JSErrorManager;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.tidy.Tidy;

public class TidyHtmlValidator
extends ValidatorBase {
    static Pattern pattern = Pattern.compile("\\s*line\\s+(\\d+)\\s*column\\s+(\\d+)\\s*-\\s*(Warning|Error):\\s*(.+)$");
    JSErrorManager jsErrorManager;
    CSSErrorManager cssErrorManager;

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        UnifiedErrorReporter reporter;
        block16: {
            String input = this.runThroughTidy(source);
            if (input == null || input.trim().length() == 0) {
                return new IFileError[0];
            }
            reporter = new UnifiedErrorReporter(sourceProvider);
            BufferedReader br = null;
            try {
                try {
                    String line;
                    br = new BufferedReader(new StringReader(input));
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("line")) continue;
                        this.parseTidyOutput(reporter, path, line, collectErrors, collectWarnings);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLErrorManager_ErrorParsingForErrors, (Throwable)e);
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return reporter.getErrors();
    }

    private String runThroughTidy(String source) {
        try {
            Tidy tidy = new Tidy();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bout);
            tidy.setErrout(out);
            try {
                String patchedSource = this.patchSource(source);
                tidy.parse((InputStream)new ByteArrayInputStream(patchedSource.getBytes()), null);
            }
            catch (NullPointerException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.TidyHtmlValidator_Null_Pointer, (Throwable)e);
            }
            out.flush();
            return bout.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private void parseTidyOutput(UnifiedErrorReporter err, String filename, String source, boolean showErrors, boolean showWarnings) {
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            String type = matcher.group(3);
            String message = matcher.group(4);
            if ((message = this.filterMessage(message)) == null) continue;
            if (type.startsWith("Error") && showErrors) {
                err.error(message, filename, line, "", column);
                continue;
            }
            if (!type.startsWith("Warning") || !showWarnings) continue;
            err.warning(message, filename, line, "", column);
        }
    }

    public String filterMessage(String message) {
        message = message.replaceFirst("discarding", "should discard");
        message = message.replaceFirst("inserting", "should insert");
        message = message.replaceFirst("trimming", "should trim");
        return message;
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)HTMLPlugin.getDefault())) {
            return HTMLPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    private String patchSource(String source) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            char ch = source.charAt(i);
            boolean patchNeeded = false;
            if (ch == '<' && i + 1 < source.length() && Character.isLetter(source.charAt(i + 1))) {
                int j = i + 1;
                while (j < source.length()) {
                    char ch2 = source.charAt(j);
                    if (!Character.isLetterOrDigit(ch2) && ch2 != '_' && ch != ':' && ch != '-' && ch != '.') {
                        if (Character.isWhitespace(ch2) || ch2 == '>' || ch2 == '/') break;
                        patchNeeded = true;
                    }
                    ++j;
                }
            }
            if (patchNeeded) {
                builder.append('L');
            } else {
                builder.append(ch);
            }
            ++i;
        }
        return builder.toString();
    }
}

