/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preview.HTMLPreviewHelper;
import com.aptana.ide.editor.html.preview.Messages;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import com.aptana.ide.server.ui.generic.dialogs.ServerTypeSelectionDialog;
import com.aptana.ide.server.ui.views.actions.NewServerAction;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class PreviewTypeSelectionBlock {
    private String type;
    private String value;
    private String sampleProjectName = null;
    private Label currentURL;
    private Text currentURLText;
    private Button useServerButton;
    private Composite serverImage;
    private Label serverText;
    private ToolBar serversBar;
    private ToolItem selectedServer;
    private Button serverAppendProjectName;
    private Menu serverMenu;
    private Image serverImg;
    private Button useConfigButton;
    private Composite configImage;
    private Label configText;
    private ToolBar configBar;
    private ToolItem selectedConfig;
    private Menu configMenu;
    private Image configImg;
    private Button startUrlButton;
    private Text startURLText;
    private Button startURLAppendProjectName;
    private ToolBar startURLBar;
    private ToolItem selectedStartURL;
    private Menu startURLMenu;
    private IEditorPart editor;
    private boolean useSample = false;
    private Button useFileURLButton;

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public void setCurrentURLLabel(String label) {
        this.currentURL.setText(label);
    }

    public void useSampleURL() {
        this.useSample = true;
    }

    public Text getStartURLText() {
        return this.startURLText;
    }

    public Text getCurrentURLText() {
        return this.currentURLText;
    }

    public Label getServerText() {
        return this.serverText;
    }

    public Label getConfigurationText() {
        return this.configText;
    }

    public Button getStartURLButton() {
        return this.startUrlButton;
    }

    public Button getConfigurationButton() {
        return this.useConfigButton;
    }

    public Button getServerButton() {
        return this.useServerButton;
    }

    public Button getFileButton() {
        return this.useFileURLButton;
    }

    public Menu getStartURLMenu() {
        return this.startURLMenu;
    }

    public Button getServerAppendButton() {
        return this.serverAppendProjectName;
    }

    public Button getStartURLAppendButton() {
        return this.startURLAppendProjectName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setEnabled(boolean enabled) {
        this.useConfigButton.setEnabled(enabled);
        this.useServerButton.setEnabled(enabled);
        this.startUrlButton.setEnabled(enabled);
        this.useFileURLButton.setEnabled(enabled);
    }

    private void createServerSection(Composite parent) {
        final Composite serverComposite = new Composite(parent, 0);
        GridLayout scLayout = new GridLayout(2, false);
        scLayout.marginHeight = 0;
        scLayout.marginWidth = 0;
        scLayout.horizontalSpacing = 0;
        scLayout.verticalSpacing = 0;
        serverComposite.setLayout((Layout)scLayout);
        GridData scData = new GridData(4, 4, true, false);
        serverComposite.setLayoutData((Object)scData);
        final Composite inner = new Composite(serverComposite, 2048);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (PreviewTypeSelectionBlock.this.serversBar.isEnabled() && PreviewTypeSelectionBlock.this.serverText.isEnabled()) {
                    Rectangle rect = inner.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = serverComposite.toDisplay(pt);
                    PreviewTypeSelectionBlock.this.serverMenu.setLocation(pt.x, pt.y);
                    PreviewTypeSelectionBlock.this.serverMenu.setVisible(true);
                }
            }
        };
        inner.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout iLayout = new GridLayout(3, false);
        iLayout.marginHeight = 0;
        iLayout.marginWidth = 0;
        GridData iData = new GridData(4, 4, false, false);
        iData.widthHint = 200;
        inner.setLayout((Layout)iLayout);
        inner.setLayoutData((Object)iData);
        inner.addMouseListener((MouseListener)listener);
        this.serverImage = new Composite(inner, 0);
        this.serverImage.setBackground(inner.getDisplay().getSystemColor(1));
        this.serverImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PreviewTypeSelectionBlock.this.serverImg != null) {
                    e.gc.drawImage(PreviewTypeSelectionBlock.this.serverImg, 2, 2);
                }
            }
        });
        this.serverImage.addMouseListener((MouseListener)listener);
        GridData siData = new GridData(4, 4, false, false);
        siData.heightHint = 16;
        siData.widthHint = 20;
        this.serverImage.setLayoutData((Object)siData);
        this.serverText = new Label(inner, 16384);
        this.serverText.setBackground(inner.getDisplay().getSystemColor(1));
        this.serverText.addMouseListener((MouseListener)listener);
        GridData stData = new GridData(4, 0x1000000, true, false);
        this.serverText.setLayoutData((Object)stData);
        this.serversBar = new ToolBar(inner, 0x800000);
        this.serversBar.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout sbLayout = new GridLayout(1, false);
        sbLayout.marginHeight = 0;
        sbLayout.marginWidth = 0;
        sbLayout.horizontalSpacing = 0;
        scLayout.verticalSpacing = 0;
        this.serversBar.setLayout((Layout)sbLayout);
        this.serversBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.selectedServer = new ToolItem(this.serversBar, 8);
        Image arrow = EclipseUtils.getArrowImage();
        this.selectedServer.setImage(arrow);
        this.serverMenu = new Menu((Control)serverComposite);
        this.selectedServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = inner.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = serverComposite.toDisplay(pt);
                PreviewTypeSelectionBlock.this.serverMenu.setLocation(pt.x, pt.y);
                PreviewTypeSelectionBlock.this.serverMenu.setVisible(true);
            }
        });
        this.addServers();
        this.addAddServer();
        this.serverAppendProjectName = new Button(serverComposite, 32);
        this.serverAppendProjectName.setText(Messages.PreviewTypeSelectionBlock_LBL_Append);
        this.serverAppendProjectName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        GridData apnData = new GridData(4, 4, false, false);
        apnData.horizontalIndent = 5;
        this.serverAppendProjectName.setLayoutData((Object)apnData);
    }

    private void addAddServer() {
        MenuItem addItem = new MenuItem(this.serverMenu, 8);
        addItem.setText(Messages.PreviewTypeSelectionBlock_LBL_AddServer);
        addItem.setImage(HTMLPlugin.getImage("icons/add_tab.gif"));
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerTypeSelectionDialog dialog = new ServerTypeSelectionDialog(PreviewTypeSelectionBlock.this.serverMenu.getShell());
                dialog.open();
                IServerType result = dialog.getResult();
                String id = null;
                if (result != null) {
                    NewServerAction action = new NewServerAction(result);
                    action.run();
                    id = action.getCreatedServerID();
                }
                MenuItem[] currents = PreviewTypeSelectionBlock.this.serverMenu.getItems();
                int i = 0;
                while (i < currents.length) {
                    currents[i].dispose();
                    ++i;
                }
                PreviewTypeSelectionBlock.this.addServers();
                PreviewTypeSelectionBlock.this.addAddServer();
                if (id != null) {
                    IServer[] servers = ServerCore.getServerManager().getServers();
                    int i2 = 0;
                    while (i2 < servers.length) {
                        IServer curr = servers[i2];
                        if (curr.isWebServer() && id.equals(curr.getId())) {
                            PreviewTypeSelectionBlock.this.serverText.setText(curr.getName());
                            PreviewTypeSelectionBlock.this.serverText.setData((Object)curr);
                            Image img = ServerImagesRegistry.getInstance().getImage((Object)curr);
                            PreviewTypeSelectionBlock.this.serverImg = img;
                            PreviewTypeSelectionBlock.this.serverImage.redraw();
                            PreviewTypeSelectionBlock.this.serverImage.update();
                            PreviewTypeSelectionBlock.this.updateCurrentURL();
                            PreviewTypeSelectionBlock.this.serverAppendProjectName.setEnabled(true);
                        }
                        ++i2;
                    }
                }
            }
        });
    }

    private void addServers() {
        IServer[] servers = ServerCore.getServerManager().getServers();
        int i = 0;
        while (i < servers.length) {
            final IServer curr = servers[i];
            if (curr.isWebServer()) {
                final MenuItem server = new MenuItem(this.serverMenu, 8);
                server.setData((Object)curr);
                server.setText(curr.getName());
                Image img = ServerImagesRegistry.getInstance().getImage((Object)curr);
                if (img != null) {
                    server.setImage(img);
                }
                server.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreviewTypeSelectionBlock.this.serverText.setText(server.getText());
                        PreviewTypeSelectionBlock.this.serverText.setData((Object)curr);
                        PreviewTypeSelectionBlock.this.serverImg = server.getImage();
                        PreviewTypeSelectionBlock.this.serverImage.redraw();
                        PreviewTypeSelectionBlock.this.serverImage.update();
                        PreviewTypeSelectionBlock.this.updateCurrentURL();
                        if ("com.aptana.ide.html.preview.htmlPreviewServer".equals(curr.getId())) {
                            PreviewTypeSelectionBlock.this.serverAppendProjectName.setSelection(true);
                            PreviewTypeSelectionBlock.this.serverAppendProjectName.setEnabled(false);
                        } else {
                            PreviewTypeSelectionBlock.this.serverAppendProjectName.setEnabled(true);
                        }
                    }
                });
            }
            ++i;
        }
    }

    public void createStartActionSection(Composite parent, String type, String value) {
        this.type = type;
        this.value = value;
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewTypeSelectionBlock_LBL_TypeGroup);
        group.setFont(parent.getFont());
        GridData gData = new GridData(4, 4, true, false);
        gData.horizontalSpan = 2;
        group.setLayoutData((Object)gData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        if (this.editor != null || this.useSample) {
            Composite internal = new Composite((Composite)group, 0);
            GridLayout iLayout = new GridLayout(2, false);
            iLayout.marginHeight = 0;
            iLayout.marginWidth = 0;
            GridData iData = new GridData(4, 4, true, false);
            iData.horizontalSpan = 2;
            internal.setLayoutData((Object)iData);
            internal.setLayout((Layout)iLayout);
            this.currentURL = new Label(internal, 16384);
            this.currentURL.setText(Messages.PreviewTypeSelectionBlock_LBL_URL);
            this.currentURLText = new Text(internal, 2060);
            GridData cuData = new GridData(4, 4, true, false);
            this.currentURLText.setLayoutData((Object)cuData);
        }
        this.useServerButton = new Button((Composite)group, 16);
        this.useServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTypeSelectionBlock.this.serversBar.setEnabled(PreviewTypeSelectionBlock.this.useServerButton.getSelection());
                PreviewTypeSelectionBlock.this.serverText.setEnabled(PreviewTypeSelectionBlock.this.useServerButton.getSelection());
                PreviewTypeSelectionBlock.this.serverAppendProjectName.setEnabled(PreviewTypeSelectionBlock.this.useServerButton.getSelection());
                if (PreviewTypeSelectionBlock.this.useServerButton.getSelection()) {
                    IServer server;
                    MenuItem menuItem;
                    Object obj;
                    if (PreviewTypeSelectionBlock.this.serverMenu.getItemCount() > 0 && PreviewTypeSelectionBlock.this.serverText.getData() == null && (obj = (menuItem = PreviewTypeSelectionBlock.this.serverMenu.getItem(0)).getData()) != null && obj instanceof IServer) {
                        PreviewTypeSelectionBlock.this.serverText.setText(menuItem.getText());
                        PreviewTypeSelectionBlock.this.serverText.setData(obj);
                        PreviewTypeSelectionBlock.this.serverImg = menuItem.getImage();
                        PreviewTypeSelectionBlock.this.serverImage.redraw();
                        PreviewTypeSelectionBlock.this.serverImage.update();
                    }
                    if (PreviewTypeSelectionBlock.this.serverText.getData() != null && PreviewTypeSelectionBlock.this.serverText.getData() instanceof IServer && "com.aptana.ide.html.preview.htmlPreviewServer".equals((server = (IServer)PreviewTypeSelectionBlock.this.serverText.getData()).getId())) {
                        PreviewTypeSelectionBlock.this.serverAppendProjectName.setSelection(true);
                        PreviewTypeSelectionBlock.this.serverAppendProjectName.setEnabled(false);
                    }
                }
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        this.useServerButton.setText(Messages.PreviewTypeSelectionBlock_LBL_UseServer);
        this.createServerSection((Composite)group);
        this.serversBar.setEnabled(false);
        this.useConfigButton = new Button((Composite)group, 16);
        this.useConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem;
                Object obj;
                PreviewTypeSelectionBlock.this.configBar.setEnabled(PreviewTypeSelectionBlock.this.useConfigButton.getSelection());
                PreviewTypeSelectionBlock.this.configText.setEnabled(PreviewTypeSelectionBlock.this.useConfigButton.getSelection());
                if (PreviewTypeSelectionBlock.this.useConfigButton.getSelection() && PreviewTypeSelectionBlock.this.configMenu.getItemCount() > 0 && PreviewTypeSelectionBlock.this.configText.getData() == null && (obj = (menuItem = PreviewTypeSelectionBlock.this.configMenu.getItem(0)).getData()) != null && obj instanceof ILaunchConfiguration) {
                    PreviewTypeSelectionBlock.this.configText.setText(menuItem.getText());
                    PreviewTypeSelectionBlock.this.configText.setData(obj);
                    PreviewTypeSelectionBlock.this.configImg = menuItem.getImage();
                    PreviewTypeSelectionBlock.this.configImage.redraw();
                    PreviewTypeSelectionBlock.this.configImage.update();
                }
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        this.useConfigButton.setText(Messages.PreviewTypeSelectionBlock_LBL_UseRunConfig);
        this.createConfigSection((Composite)group);
        this.configBar.setEnabled(false);
        this.startUrlButton = new Button((Composite)group, 16);
        this.startUrlButton.setText(Messages.PreviewTypeSelectionBlock_LBL_UseAbsURL);
        this.createStartURLSection((Composite)group);
        this.startUrlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTypeSelectionBlock.this.startURLBar.setEnabled(PreviewTypeSelectionBlock.this.startUrlButton.getSelection());
                PreviewTypeSelectionBlock.this.startURLText.setEnabled(PreviewTypeSelectionBlock.this.startUrlButton.getSelection());
                PreviewTypeSelectionBlock.this.startURLAppendProjectName.setEnabled(PreviewTypeSelectionBlock.this.startUrlButton.getSelection());
                if (PreviewTypeSelectionBlock.this.startUrlButton.getSelection() && PreviewTypeSelectionBlock.this.startURLMenu.getItemCount() > 0 && PreviewTypeSelectionBlock.this.startURLText.getText().length() == 0) {
                    MenuItem menuItem = PreviewTypeSelectionBlock.this.startURLMenu.getItem(0);
                    PreviewTypeSelectionBlock.this.startURLText.setText(menuItem.getText());
                }
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        this.startURLText.setEnabled(false);
        this.startURLBar.setEnabled(false);
        this.useFileURLButton = new Button((Composite)group, 16);
        this.useFileURLButton.setText(Messages.PreviewTypeSelectionBlock_LBL_UseFileURL);
        this.useFileURLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
    }

    private void createStartURLSection(Composite parent) {
        Composite startURLComposite = new Composite(parent, 0);
        GridLayout suLayout = new GridLayout(2, false);
        suLayout.marginHeight = 0;
        suLayout.marginWidth = 0;
        suLayout.horizontalSpacing = 0;
        suLayout.verticalSpacing = 0;
        startURLComposite.setLayout((Layout)suLayout);
        GridData suData = new GridData(4, 4, true, false);
        startURLComposite.setLayoutData((Object)suData);
        final Composite inner = new Composite(startURLComposite, 2048);
        inner.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout iLayout = new GridLayout(2, false);
        iLayout.marginHeight = 0;
        iLayout.marginWidth = 0;
        iLayout.horizontalSpacing = 0;
        iLayout.verticalSpacing = 0;
        inner.setLayout((Layout)iLayout);
        GridData iData = new GridData(4, 4, false, false);
        iData.widthHint = 250;
        inner.setLayoutData((Object)iData);
        this.startURLText = new Text(inner, 4);
        this.startURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        this.startURLText.setBackground(inner.getDisplay().getSystemColor(1));
        GridData data = new GridData(4, 0x1000000, true, false);
        this.startURLText.setLayoutData((Object)data);
        this.startURLBar = new ToolBar(inner, 0x800000);
        this.startURLBar.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout subLayout = new GridLayout(1, false);
        subLayout.marginHeight = 0;
        subLayout.marginWidth = 0;
        subLayout.horizontalSpacing = 0;
        subLayout.verticalSpacing = 0;
        this.startURLBar.setLayout((Layout)subLayout);
        this.startURLBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.selectedStartURL = new ToolItem(this.startURLBar, 8);
        Image arrow = EclipseUtils.getArrowImage();
        this.selectedStartURL.setImage(arrow);
        this.startURLMenu = new Menu((Control)inner);
        this.selectedStartURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = inner.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = inner.toDisplay(pt);
                PreviewTypeSelectionBlock.this.startURLMenu.setLocation(pt.x, pt.y);
                PreviewTypeSelectionBlock.this.startURLMenu.setVisible(true);
            }
        });
        this.startURLAppendProjectName = new Button(startURLComposite, 32);
        this.startURLAppendProjectName.setText(Messages.PreviewTypeSelectionBlock_LBL_AppendPath);
        this.startURLAppendProjectName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewTypeSelectionBlock.this.updateCurrentURL();
            }
        });
        GridData apnData = new GridData(4, 4, false, false);
        apnData.horizontalIndent = 5;
        this.startURLAppendProjectName.setLayoutData((Object)apnData);
        String currs = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_LAST_START_URLS");
        String[] urls = currs.split("___PREFERENCE___");
        int i = 0;
        while (i < urls.length) {
            if (urls[i].trim().length() > 0) {
                final MenuItem startURL = new MenuItem(this.startURLMenu, 8);
                startURL.setText(urls[i]);
                startURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreviewTypeSelectionBlock.this.startURLText.setText(startURL.getText());
                    }
                });
            }
            ++i;
        }
    }

    public void updateControls() {
        this.useConfigButton.setSelection(false);
        this.useServerButton.setSelection(false);
        this.startUrlButton.setSelection(false);
        this.useFileURLButton.setSelection(false);
        this.configBar.setEnabled(false);
        this.configText.setEnabled(false);
        this.serversBar.setEnabled(false);
        this.serverText.setEnabled(false);
        this.startURLText.setEnabled(false);
        this.serverAppendProjectName.setEnabled(false);
        this.startURLAppendProjectName.setEnabled(false);
        if (this.type != null) {
            if ("com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE".equals(this.type)) {
                this.useConfigButton.setSelection(true);
                this.configBar.setEnabled(this.useConfigButton.getEnabled());
                this.configText.setEnabled(this.useConfigButton.getEnabled());
                if (this.value != null) {
                    ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
                    try {
                        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(type);
                        int i = 0;
                        while (i < configs.length) {
                            if (this.value.equals(configs[i].getName())) {
                                this.configText.setText(this.value);
                                this.configText.setData((Object)configs[i]);
                                Image img = EclipseUIUtils.getDebugUIPluginImageLabel((Object)configs[i]);
                                if (img != null) {
                                    this.configImg = img;
                                    this.configImage.redraw();
                                    this.configImage.update();
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if ("com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE".equals(this.type) || "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(this.type)) {
                this.useServerButton.setSelection(true);
                this.serversBar.setEnabled(this.useServerButton.getEnabled());
                this.serverText.setEnabled(this.useServerButton.getEnabled());
                this.serverAppendProjectName.setEnabled(this.useServerButton.getEnabled());
                this.serverAppendProjectName.setSelection("com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(this.type));
                if (this.value != null) {
                    IServer[] servers = ServerCore.getServerManager().getServers();
                    int i = 0;
                    while (i < servers.length) {
                        if (this.value.equals(servers[i].getId())) {
                            if ("com.aptana.ide.html.preview.htmlPreviewServer".equals(this.value)) {
                                this.serverAppendProjectName.setSelection(true);
                                this.serverAppendProjectName.setEnabled(false);
                            }
                            this.serverText.setText(servers[i].getName());
                            this.serverText.setData((Object)servers[i]);
                            Image img = ServerImagesRegistry.getInstance().getImage((Object)servers[i]);
                            if (img != null) {
                                this.serverImg = img;
                                this.serverImage.redraw();
                                this.serverImage.update();
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else if ("com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE".equals(this.type) || "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE".equals(this.type)) {
                this.startUrlButton.setSelection(true);
                this.startURLText.setEnabled(this.startUrlButton.getEnabled());
                this.startURLBar.setEnabled(this.startUrlButton.getEnabled());
                this.startURLAppendProjectName.setEnabled(this.startUrlButton.getSelection());
                this.startURLAppendProjectName.setSelection("com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE".equals(this.type));
                if (this.value != null) {
                    this.startURLText.setText(this.value);
                }
            } else {
                this.useFileURLButton.setSelection(true);
                if (this.editor != null) {
                    IEditorInput input = this.editor.getEditorInput();
                    if (input instanceof FileEditorInput) {
                        IFile file = ((FileEditorInput)input).getFile();
                        this.currentURLText.setText(file.getLocation().makeAbsolute().toOSString());
                    }
                } else if (this.useSample) {
                    this.currentURLText.setText("file://workspace/" + this.getProjectName() + "/file.html");
                }
            }
        }
    }

    private void createConfigSection(Composite parent) {
        final Composite configComposite = new Composite(parent, 0);
        GridLayout ccLayout = new GridLayout(1, false);
        ccLayout.marginHeight = 0;
        ccLayout.marginWidth = 0;
        ccLayout.horizontalSpacing = 0;
        configComposite.setLayout((Layout)ccLayout);
        GridData ccData = new GridData(4, 4, true, false);
        configComposite.setLayoutData((Object)ccData);
        final Composite inner = new Composite(configComposite, 2048);
        inner.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout iLayout = new GridLayout(3, false);
        iLayout.marginHeight = 0;
        iLayout.marginWidth = 0;
        GridData iData = new GridData(4, 4, false, false);
        iData.widthHint = 200;
        inner.setLayout((Layout)iLayout);
        inner.setLayoutData((Object)iData);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (PreviewTypeSelectionBlock.this.configBar.isEnabled() && PreviewTypeSelectionBlock.this.configText.isEnabled()) {
                    Rectangle rect = inner.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = configComposite.toDisplay(pt);
                    PreviewTypeSelectionBlock.this.configMenu.setLocation(pt.x, pt.y);
                    PreviewTypeSelectionBlock.this.configMenu.setVisible(true);
                }
            }
        };
        inner.addMouseListener((MouseListener)listener);
        this.configImage = new Composite(inner, 0);
        this.configImage.setBackground(inner.getDisplay().getSystemColor(1));
        this.configImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PreviewTypeSelectionBlock.this.configImg != null) {
                    e.gc.drawImage(PreviewTypeSelectionBlock.this.configImg, 2, 2);
                }
            }
        });
        this.configImage.addMouseListener((MouseListener)listener);
        GridData ciData = new GridData(4, 4, false, false);
        ciData.heightHint = 16;
        ciData.widthHint = 20;
        this.configImage.setLayoutData((Object)ciData);
        this.configText = new Label(inner, 16384);
        this.configText.setBackground(inner.getDisplay().getSystemColor(1));
        GridData stData = new GridData(4, 0x1000000, true, false);
        this.configText.setLayoutData((Object)stData);
        this.configText.addMouseListener((MouseListener)listener);
        this.configBar = new ToolBar(inner, 0x800000);
        this.configBar.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout cbLayout = new GridLayout(1, false);
        cbLayout.marginHeight = 0;
        cbLayout.marginWidth = 0;
        cbLayout.horizontalSpacing = 0;
        this.configBar.setLayout((Layout)cbLayout);
        this.configBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.selectedConfig = new ToolItem(this.configBar, 8);
        Image arrow = EclipseUtils.getArrowImage();
        this.selectedConfig.setImage(arrow);
        this.configMenu = new Menu((Control)configComposite);
        this.selectedConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = inner.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = configComposite.toDisplay(pt);
                PreviewTypeSelectionBlock.this.configMenu.setLocation(pt.x, pt.y);
                PreviewTypeSelectionBlock.this.configMenu.setVisible(true);
            }
        });
        this.addRunConfigs();
        this.addAddRunConfiguration();
    }

    private void addAddRunConfiguration() {
        MenuItem addItem = new MenuItem(this.configMenu, 8);
        addItem.setText(Messages.PreviewTypeSelectionBlock_LBL_AddConfig);
        addItem.setImage(HTMLPlugin.getImage("icons/add_tab.gif"));
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchGroupExtension ext = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.run");
                LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(PreviewTypeSelectionBlock.this.configMenu.getShell(), ext);
                dialog.open();
                MenuItem[] currents = PreviewTypeSelectionBlock.this.configMenu.getItems();
                int i = 0;
                while (i < currents.length) {
                    currents[i].dispose();
                    ++i;
                }
                PreviewTypeSelectionBlock.this.addRunConfigs();
                PreviewTypeSelectionBlock.this.addAddRunConfiguration();
            }
        });
    }

    private void addRunConfigs() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
        try {
            ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                final MenuItem config = new MenuItem(this.configMenu, 8);
                final ILaunchConfiguration current = configs[i];
                config.setData((Object)current);
                config.setText(current.getName());
                Image img = EclipseUIUtils.getDebugUIPluginImageLabel((Object)current);
                if (img != null) {
                    config.setImage(img);
                }
                config.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreviewTypeSelectionBlock.this.configText.setText(config.getText());
                        PreviewTypeSelectionBlock.this.configText.setData((Object)current);
                        PreviewTypeSelectionBlock.this.configImg = config.getImage();
                        PreviewTypeSelectionBlock.this.configImage.redraw();
                        PreviewTypeSelectionBlock.this.configImage.update();
                        PreviewTypeSelectionBlock.this.updateCurrentURL();
                    }
                });
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public void refreshURLs() {
        String currs = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_LAST_START_URLS");
        String[] urls = currs.split("___PREFERENCE___");
        MenuItem[] currents = this.getStartURLMenu().getItems();
        int i = 0;
        while (i < currents.length) {
            currents[i].dispose();
            ++i;
        }
        i = 0;
        while (i < urls.length) {
            if (urls[i].trim().length() > 0) {
                final MenuItem startURL = new MenuItem(this.getStartURLMenu(), 8);
                startURL.setText(urls[i]);
                startURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreviewTypeSelectionBlock.this.getStartURLText().setText(startURL.getText());
                    }
                });
            }
            ++i;
        }
    }

    public void saveURLs() {
        String urlToAdd = this.getStartURLText().getText();
        String currs = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_LAST_START_URLS");
        String[] urls = currs.split("___PREFERENCE___");
        ArrayList<String> newSettings = new ArrayList<String>();
        newSettings.add(urlToAdd);
        int max = Math.min(urls.length, 10);
        int i = 0;
        while (i < max) {
            if (!urlToAdd.equals(urls[i]) && urlToAdd.trim().length() > 0) {
                newSettings.add(urls[i]);
            }
            ++i;
        }
        HTMLPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editor.html.preview.HTML_PREVIEW_LAST_START_URLS", StringUtils.join((String)"___PREFERENCE___", (String[])newSettings.toArray(new String[0])));
    }

    private String getProjectName() {
        return this.sampleProjectName != null ? this.sampleProjectName : "project";
    }

    public void updateCurrentURL() {
        if (this.editor == null && !this.useSample) {
            return;
        }
        if (this.useServerButton.getSelection()) {
            Object data = this.serverText.getData();
            if (data != null && data instanceof IServer) {
                String serverURL = null;
                if (this.useSample) {
                    serverURL = HTMLPreviewHelper.getServerHostURL((IServer)data);
                    if (this.serverAppendProjectName.getSelection()) {
                        serverURL = String.valueOf(serverURL) + this.getProjectName() + "/";
                    }
                    serverURL = String.valueOf(serverURL) + "file.html";
                } else {
                    serverURL = HTMLPreviewHelper.getServerURL((IServer)data, this.editor.getEditorInput(), this.serverAppendProjectName.getSelection());
                }
                if (serverURL != null) {
                    this.currentURLText.setText(serverURL);
                } else {
                    this.currentURLText.setText("");
                }
            } else {
                this.currentURLText.setText("");
            }
        } else if (this.useConfigButton.getSelection()) {
            Object data = this.configText.getData();
            if (data != null && data instanceof ILaunchConfiguration) {
                String configURL = null;
                configURL = this.useSample ? HTMLPreviewHelper.getConfigSampleURL((ILaunchConfiguration)data, this.getProjectName()) : HTMLPreviewHelper.getConfigURL((ILaunchConfiguration)data, this.editor.getEditorInput());
                if (configURL != null) {
                    this.currentURLText.setText(configURL);
                } else {
                    this.currentURLText.setText("");
                }
            } else {
                this.currentURLText.setText("");
            }
        } else if (this.startUrlButton.getSelection()) {
            String text = this.startURLText.getText();
            if (this.startURLAppendProjectName.getSelection()) {
                if (!text.endsWith("/")) {
                    text = String.valueOf(text) + "/";
                }
                text = String.valueOf(text) + "folder/file.html";
            }
            this.currentURLText.setText(text);
        } else if (this.useFileURLButton.getSelection()) {
            if (this.editor != null) {
                IEditorInput input = this.editor.getEditorInput();
                if (input instanceof FileEditorInput) {
                    IFile file = ((FileEditorInput)input).getFile();
                    this.currentURLText.setText(file.getLocation().makeAbsolute().toOSString());
                }
            } else if (this.useSample) {
                this.currentURLText.setText("file://workspace/" + this.getProjectName() + "/file.html");
            }
        }
    }

    public String getSampleProjectName() {
        return this.sampleProjectName;
    }

    public void setSampleProjectName(String sampleProjectName) {
        this.sampleProjectName = sampleProjectName;
    }
}

