/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.MultiPageHTMLEditor;
import com.aptana.ide.editor.html.preview.BasePreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.HTMLPreviewConfiguration;
import com.aptana.ide.editor.html.preview.HTMLPreviewHelper;
import com.aptana.ide.editor.html.preview.IPreviewConfiguration;
import com.aptana.ide.editor.html.preview.Messages;
import com.aptana.ide.editor.html.preview.PreviewConfigurations;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.ServerFileTypeHandlers;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class DefaultPreviewConfigurationPage
extends BasePreviewConfigurationPage {
    private static final String TEMP_EXTENSION = "tmp";
    private Composite displayArea;
    private Composite browserArea;
    private ProgressListener listener;
    private Listener locListener;
    private Event lastEvent = null;

    public DefaultPreviewConfigurationPage(MultiPageHTMLEditor editor) {
        super(editor);
        this.url = this.editor.getURL();
        this.locListener = new Listener(){

            public void handleEvent(Event event) {
                if (DefaultPreviewConfigurationPage.this.lastEvent == null || event.time > ((DefaultPreviewConfigurationPage)DefaultPreviewConfigurationPage.this).lastEvent.time) {
                    String addOn;
                    DefaultPreviewConfigurationPage.this.lastEvent = event;
                    if (event.data instanceof Image) {
                        DefaultPreviewConfigurationPage.this.editor.setTabIcon(DefaultPreviewConfigurationPage.this, (Image)event.data);
                    }
                    if ((addOn = event.text) != null) {
                        DefaultPreviewConfigurationPage.this.editor.setTabTooltip(DefaultPreviewConfigurationPage.this, String.valueOf(DefaultPreviewConfigurationPage.this.url) + " " + event.text);
                    }
                }
            }
        };
        this.listener = new ProgressListener(){

            public void completed(ProgressEvent event) {
                BrowserExtensionLoader.getDecorator(DefaultPreviewConfigurationPage.this.browser, DefaultPreviewConfigurationPage.this.locListener);
            }

            public void changed(ProgressEvent event) {
            }
        };
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserArea = new Composite(this.displayArea, 0);
        GridData baData = new GridData(4, 4, true, true);
        baData.exclude = true;
        GridLayout baLayout = new GridLayout(1, false);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        this.browserArea.setLayout((Layout)baLayout);
        this.browserArea.setLayoutData((Object)baData);
        this.browserArea.setVisible(false);
    }

    public void setBrowser(ContributedBrowser browser, String label) {
        if (this.browser != null) {
            this.browser.dispose();
        }
        this.browserLabel = label;
        if (this.browser != null) {
            this.browser.removeProgressListener(this.listener);
        }
        this.browser = browser;
        this.created = false;
        if (CoreUIUtils.onMacOSX) {
            this.create();
        }
    }

    public void showEditArea() {
        this.displayArea.layout(true, true);
    }

    public void showBrowserArea() {
        GridData baData = (GridData)this.browserArea.getLayoutData();
        baData.exclude = false;
        this.browserArea.setVisible(true);
        this.displayArea.layout(true, true);
    }

    private void create() {
        if (!this.created) {
            this.created = true;
            this.browser.createControl(this.browserArea);
            this.browser.addProgressListener(this.listener);
            this.browserArea.layout(true, true);
        }
    }

    public void setURL(String url) {
        if (this.browser != null) {
            this.create();
            String value = null;
            String type = null;
            IEditorInput input = this.editor.getEditorInput();
            boolean isProjectFile = false;
            String extension = this.getExtensionByURL(url);
            IPreviewConfiguration configuration = null;
            if (extension != null) {
                configuration = PreviewConfigurations.getConfiguration(extension);
            }
            if (configuration == null) {
                configuration = new HTMLPreviewConfiguration();
            }
            if (input instanceof IFileEditorInput) {
                isProjectFile = true;
                IFile file = ((IFileEditorInput)input).getFile();
                if (configuration.projectOverridesPreview(file.getProject())) {
                    type = configuration.getPreviewType(file.getProject());
                    value = configuration.getPreviewName(file.getProject());
                }
            } else {
                type = "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE";
                value = url;
            }
            if (type == null || value == null) {
                type = configuration.getPreviewType();
                value = configuration.getPreviewName();
            }
            ServerFileTypeHandlers.PreviewInfo previewInfo = ServerFileTypeHandlers.getPreviewInfoFromURL((String)url);
            String alternativeValue = null;
            String serverTypeRestriction = null;
            if (previewInfo != null) {
                alternativeValue = previewInfo.serverID;
                serverTypeRestriction = previewInfo.serverTypeID;
            }
            if (configuration.isFileBasedType(type)) {
                this.url = url;
            } else if (configuration.isServerBasedType(type) || configuration.isAppendedServerBasedType(type)) {
                if (isProjectFile) {
                    IServer curr;
                    int i;
                    IServer[] servers = ServerCore.getServerManager().getServers();
                    this.url = null;
                    if (alternativeValue != null && alternativeValue.length() != 0) {
                        i = 0;
                        while (i < servers.length) {
                            curr = servers[i];
                            if (curr.getId().equals(alternativeValue) && curr.getServerType().getId().equals(serverTypeRestriction)) {
                                this.url = HTMLPreviewHelper.getServerURL(curr, input, configuration.isAppendedServerBasedType(type), previewInfo.pathHeader);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (this.url == null) {
                        i = 0;
                        while (i < servers.length) {
                            curr = servers[i];
                            if (curr.getId().equals(value)) {
                                this.url = alternativeValue != null && alternativeValue.length() == 0 & curr.getServerType().getId().equals(serverTypeRestriction) ? HTMLPreviewHelper.getServerURL(curr, input, configuration.isAppendedServerBasedType(type), previewInfo.pathHeader) : HTMLPreviewHelper.getServerURL(curr, input, configuration.isAppendedServerBasedType(type));
                                break;
                            }
                            ++i;
                        }
                    }
                }
            } else if (configuration.isConfigurationBasedType(type)) {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
                try {
                    ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(launchType);
                    int i = 0;
                    while (i < configs.length) {
                        ILaunchConfiguration current = configs[i];
                        if (current.getName().equals(value)) {
                            this.url = HTMLPreviewHelper.getConfigURL(current, input);
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            } else if (configuration.isAbsoluteBasedType(type) || configuration.isAppendedAbsoluteBasedType(type)) {
                this.url = HTMLPreviewHelper.getAbsoluteURL(value, input, configuration.isAppendedAbsoluteBasedType(type));
            }
            if (this.url == null) {
                this.url = url;
            }
            this.editor.setTabTooltip(this, this.url);
            try {
                this.url = URLEncoder.encode((URL)new URL(this.url)).toExternalForm();
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.DefaultPreviewConfigurationPage_ERR_Encode, (Throwable)e);
            }
            this.browser.setURL(this.url);
        }
    }

    public Control getControl() {
        return this.displayArea;
    }

    public boolean isDefaultPage() {
        return true;
    }

    public boolean isDeletable() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean run(String actionID) {
        return false;
    }

    private String getExtensionByURL(String urlStr) {
        int lastPointPos;
        String file = urlStr;
        int questionPos = urlStr.indexOf(63);
        if (questionPos >= 0) {
            file = file.substring(0, questionPos);
        }
        if ((lastPointPos = file.lastIndexOf(46)) == -1 || lastPointPos == file.length() - 1) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = lastPointPos + 1;
        while (i < file.length()) {
            char ch = file.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) break;
            result.append(ch);
            ++i;
        }
        if (TEMP_EXTENSION.equals(result.toString())) {
            return this.getExtensionByURL(file.substring(0, lastPointPos));
        }
        return result.toString();
    }
}

