/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing;

import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.Messages;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTMLUtils {
    public static final int TAG_OPEN = 1;
    public static final int TAG_CLOSED = 2;
    public static final int TAG_SELF_CLOSED = 4;

    private HTMLUtils() {
    }

    public static String stripTagEndings(String tag) {
        String tempName = tag.replaceAll("</", "");
        tempName = tempName.replaceAll(">", "");
        return tempName.replaceAll("<", "");
    }

    public static String createOpenTag(String tagName, boolean close) {
        String temp = "<" + HTMLUtils.stripTagEndings(tagName);
        if (close) {
            return String.valueOf(temp) + ">";
        }
        return temp;
    }

    public static String createSelfClosedTag(String tagName) {
        String temp = "<" + HTMLUtils.stripTagEndings(tagName);
        return String.valueOf(temp) + " />";
    }

    public static String createCloseTag(Lexeme tag, boolean close) {
        if (tag != null && tag.typeIndex == 41) {
            return HTMLUtils.createCloseTag(tag.getText().substring(1), close);
        }
        return null;
    }

    public static String createCloseTag(String tagName, boolean close) {
        String temp = "</" + HTMLUtils.stripTagEndings(tagName);
        if (close) {
            return String.valueOf(temp) + ">";
        }
        return temp;
    }

    public static String createCloseTag(Lexeme tag, int offset, boolean close) {
        String tempName = HTMLUtils.getOpenTagName(tag, offset);
        return HTMLUtils.createCloseTag(tempName, close);
    }

    public static String getOpenTagName(Lexeme tag, int offset) {
        String lexemeText = tag.getText();
        if (tag.containsOffset(offset) && offset > tag.offset) {
            lexemeText = lexemeText.substring(0, offset - tag.offset);
        }
        String tempName = HTMLUtils.stripTagEndings(lexemeText);
        return tempName;
    }

    public static boolean isEqualSignAlreadyInserted(int offset, LexemeList ll) {
        Lexeme sibling = ll.getLexemeFromOffset(offset);
        return sibling != null && sibling.getText().equals("=");
    }

    public static boolean isTextQuoted(String text) {
        return HTMLUtils.isTextQuoted(text, "\"") || HTMLUtils.isTextQuoted(text, "'");
    }

    public static boolean isTextQuoted(String text, String quote) {
        if (text.length() < 2) {
            return false;
        }
        return text.startsWith(quote) && text.endsWith(quote);
    }

    /*
     * Unable to fully structure code
     */
    public static int isTagClosed(Lexeme tag, LexemeList lexemeList) {
        position = lexemeList.getLexemeIndex(tag) + 1;
        if (position >= 0) ** GOTO lbl12
        return 1;
lbl-1000:
        // 1 sources

        {
            curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 41 || curLexeme.typeIndex == 27) {
                return 1;
            }
            if (curLexeme.typeIndex == 39) {
                return 4;
            }
            if (curLexeme.typeIndex == 30) {
                return 2;
            }
            ++position;
lbl12:
            // 2 sources

            ** while (position < lexemeList.size())
        }
lbl13:
        // 1 sources

        return 1;
    }

    public static boolean isStartTagBalanced(Lexeme tag, LexemeList lexemeList, HTMLParseState parseState) {
        int index = lexemeList.getLexemeIndex(tag);
        if (index == lexemeList.size() - 1) {
            return false;
        }
        if (tag == null || lexemeList == null || parseState == null) {
            throw new IllegalArgumentException("null arguments are not accepted");
        }
        if (!HTMLUtils.isStartTag(tag)) {
            return false;
        }
        if (HTMLUtils.isTagSelfClosed(tag, lexemeList)) {
            return true;
        }
        String originalTagName = HTMLUtils.stripTagEndings(tag.getText());
        if (parseState.getCloseTagType(originalTagName) == 4) {
            return true;
        }
        int balance = 0;
        boolean trackingClose = false;
        int i = 0;
        while (i < lexemeList.size()) {
            String currenTagName;
            Lexeme currentLexeme = lexemeList.get(i);
            if (HTMLUtils.isStartTag(currentLexeme)) {
                currenTagName = HTMLUtils.stripTagEndings(currentLexeme.getText());
                if (originalTagName.equals(currenTagName)) {
                    trackingClose = true;
                }
            } else if (HTMLUtils.isEndTag(currentLexeme)) {
                if (trackingClose) {
                    ++balance;
                    trackingClose = false;
                }
                if (originalTagName.equals(currenTagName = HTMLUtils.stripTagEndings(currentLexeme.getText()))) {
                    --balance;
                }
            } else if (trackingClose) {
                if (currentLexeme.typeIndex == 41 || currentLexeme.typeIndex == 27) {
                    ++balance;
                    trackingClose = false;
                } else if (currentLexeme.typeIndex == 39) {
                    trackingClose = false;
                } else if (currentLexeme.typeIndex == 30) {
                    ++balance;
                    trackingClose = false;
                }
            }
            ++i;
        }
        return balance <= 0;
    }

    public static boolean isEndTagBalanced(Lexeme tag, LexemeList lexemeList, HTMLParseState parseState) {
        int index = lexemeList.getLexemeIndex(tag);
        if (index == 0) {
            return false;
        }
        if (tag == null || lexemeList == null || parseState == null) {
            throw new IllegalArgumentException("null arguments are not accepted");
        }
        if (!HTMLUtils.isEndTag(tag)) {
            return false;
        }
        if (HTMLUtils.isTagSelfClosed(tag, lexemeList)) {
            return true;
        }
        String originalTagName = HTMLUtils.stripTagEndings(tag.getText());
        if (parseState.getCloseTagType(originalTagName) == 4) {
            return true;
        }
        int balance = 1;
        int i = index - 1;
        while (i >= 0) {
            String currenTagName;
            Lexeme currentLexeme = lexemeList.get(i);
            if (HTMLUtils.isEndTag(currentLexeme)) {
                currenTagName = HTMLUtils.stripTagEndings(currentLexeme.getText());
                if (originalTagName.equals(currenTagName)) {
                    ++balance;
                }
            } else if (HTMLUtils.isStartTag(currentLexeme) && originalTagName.equals(currenTagName = HTMLUtils.stripTagEndings(currentLexeme.getText())) && --balance <= 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTagSelfClosed(Lexeme tag, LexemeList lexemeList) {
        if (!HTMLUtils.isStartTag(tag)) {
            return false;
        }
        position = lexemeList.getLexemeIndex(tag) + 1;
        if (position >= 0) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 39) {
                return true;
            }
            if (curLexeme.typeIndex == 27) {
                return false;
            }
            if (curLexeme.typeIndex == 30) {
                return false;
            }
            if (curLexeme.typeIndex == 41) {
                return false;
            }
            ++position;
lbl16:
            // 2 sources

            ** while (position < lexemeList.size())
        }
lbl17:
        // 1 sources

        return false;
    }

    public static Lexeme getPreviousUnclosedTag(Lexeme lexeme, LexemeList lexemeList, HTMLParseState parseState) {
        if (lexeme == null) {
            return null;
        }
        int position = lexemeList.getLexemeIndex(lexeme) - 1;
        Lexeme startTag = null;
        boolean selfClosed = false;
        Stack<Lexeme> tags = new Stack<Lexeme>();
        while (position >= 0) {
            Lexeme curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 27) {
                tags.push(curLexeme);
            }
            if (curLexeme.typeIndex == 39) {
                selfClosed = true;
            }
            if (curLexeme.typeIndex == 41) {
                if (selfClosed) {
                    selfClosed = false;
                    --position;
                    continue;
                }
                String tagName = HTMLUtils.stripTagEndings(curLexeme.getText());
                if (tags.size() == 0) {
                    if (parseState.getCloseTagType(tagName) == 4) {
                        --position;
                        continue;
                    }
                    return curLexeme;
                }
                Lexeme l = (Lexeme)tags.pop();
                if (l.typeIndex == 39) {
                    --position;
                    continue;
                }
                if (parseState.getCloseTagType(tagName) == 1) {
                    --position;
                    continue;
                }
                if (HTMLUtils.stripTagEndings(l.getText()).equals(tagName)) {
                    --position;
                    continue;
                }
                return curLexeme;
            }
            --position;
        }
        return startTag;
    }

    public static Lexeme getTagOpenLexeme(int offset, LexemeList lexemeList) {
        int index = ParentOffsetMapper.getLexemeIndexFromDocumentOffset((int)offset, (LexemeList)lexemeList);
        if (index > -1) {
            Lexeme l = lexemeList.get(index);
            return HTMLUtils.getTagOpenLexeme(l, lexemeList);
        }
        return null;
    }

    public static Lexeme getTagOpenLexeme(Lexeme lexeme, LexemeList lexemeList) {
        Lexeme startTag = null;
        int position = lexemeList.getLexemeIndex(lexeme);
        while (position >= 0) {
            Lexeme curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 27 || curLexeme.typeIndex == 39 || curLexeme.typeIndex == 30) break;
            if (curLexeme.typeIndex == 41) {
                startTag = curLexeme;
                break;
            }
            --position;
        }
        return startTag;
    }

    public static boolean insideQuotedString(Lexeme lexeme, int offset) {
        String text = lexeme.getText();
        return (text.startsWith("\"") || text.startsWith("'")) && lexeme.containsOffset(offset);
    }

    public static boolean insideOpenTag(int offset, LexemeList lexemeList) {
        Lexeme startLexeme = HTMLUtils.getTagOpenLexeme(offset, lexemeList);
        return startLexeme != null;
    }

    public static boolean isStartTag(Lexeme lexeme) {
        return lexeme.typeIndex == 41 || lexeme.typeIndex == 0 && lexeme.getText().equals("<") || lexeme.typeIndex == 51 && lexeme.getText().trim().equals("<");
    }

    public static boolean isEndTag(Lexeme lexeme) {
        return lexeme.typeIndex == 27 || lexeme.typeIndex == 51 && lexeme.getText().equals("</");
    }

    public static Lexeme getFirstLexemeWithText(String lexemeText, LexemeList lexemeList) {
        int i = 0;
        while (i < lexemeList.size()) {
            Lexeme l = lexemeList.get(i);
            if (l.getText().equals(lexemeText)) {
                return l;
            }
            ++i;
        }
        return null;
    }

    public static Lexeme[] getLexemesOfType(int lexemeTypes, LexemeList lexemeList, String language) {
        return HTMLUtils.getLexemesOfType(new int[]{lexemeTypes}, lexemeList, language);
    }

    public static Lexeme[] getLexemesOfType(int[] lexemeTypes, LexemeList lexemeList, String language) {
        Arrays.sort(lexemeTypes);
        ArrayList<Lexeme> lexemes = new ArrayList<Lexeme>();
        int i = 0;
        while (i < lexemeList.size()) {
            Lexeme l = lexemeList.get(i);
            if (l.getLanguage().equals(language) && Arrays.binarySearch(lexemeTypes, l.typeIndex) >= 0) {
                lexemes.add(l);
            }
            ++i;
        }
        return lexemes.toArray(new Lexeme[lexemes.size()]);
    }

    public static Lexeme getTagCloseLexeme(int offset, LexemeList lexemeList) {
        Lexeme l = lexemeList.getCeilingLexeme(offset);
        return HTMLUtils.getTagCloseLexeme(l, lexemeList);
    }

    public static Lexeme getTagCloseLexeme(Lexeme startLexeme, LexemeList lexemeList) {
        return HTMLUtils.getNextLexemeOfType(startLexeme, new int[]{30, 39}, lexemeList);
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, LexemeList lexemeList) {
        return HTMLUtils.getNextLexemeOfType(startLexeme, lexemeTypes, new int[0], lexemeList);
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, int[] lexemeTypesToBail, LexemeList lexemeList) {
        int index;
        Arrays.sort(lexemeTypes);
        Arrays.sort(lexemeTypesToBail);
        int i = index = lexemeList.getLexemeIndex(startLexeme);
        while (i < lexemeList.size()) {
            Lexeme l = lexemeList.get(i);
            if (Arrays.binarySearch(lexemeTypes, l.typeIndex) >= 0) {
                return l;
            }
            if (Arrays.binarySearch(lexemeTypesToBail, l.typeIndex) >= 0) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public static Map<String, String> gatherAttributes(Lexeme openTagLexeme, Lexeme closeTagLexeme, LexemeList lexemeList) {
        HashMap<String, String> h = new HashMap<String, String>();
        if (openTagLexeme == null || closeTagLexeme == null) {
            return h;
        }
        int startIndex = lexemeList.getLexemeIndex(openTagLexeme);
        int endIndex = lexemeList.size() - 1;
        if (closeTagLexeme != null) {
            endIndex = lexemeList.getLexemeIndex(closeTagLexeme);
        }
        if (startIndex > endIndex) {
            throw new IndexOutOfBoundsException(Messages.HTMLUtils_0);
        }
        String currentName = null;
        boolean foundEquals = false;
        boolean foundQuote = false;
        while (startIndex < endIndex) {
            Lexeme l = lexemeList.get(++startIndex);
            if (l.typeIndex == 43 && !foundEquals) {
                currentName = l.getText();
                continue;
            }
            if (l.typeIndex == 29) {
                foundEquals = true;
                continue;
            }
            if (l.typeIndex == 44 || foundEquals && l.typeIndex == 43) {
                foundEquals = false;
                if (currentName == null || h.containsKey(currentName)) continue;
                h.put(currentName, l.getText());
                continue;
            }
            if (l.typeIndex != 56) continue;
            if (foundQuote) {
                foundQuote = false;
                foundEquals = false;
                if (currentName == null || h.containsKey(currentName)) continue;
                h.put(currentName, "");
                continue;
            }
            foundQuote = true;
        }
        return h;
    }

    public static String quoteAttributeValue(IPreferenceStore store, String value) {
        String quoteChar = "";
        if (store != null) {
            quoteChar = store.getString("com.aptana.ide.editor.html.ATTRIBUTE_QUOTE_CHARACTER");
        }
        return String.valueOf(quoteChar) + value + quoteChar;
    }

    public static boolean insertEquals(IPreferenceStore store) {
        if (store != null) {
            return store.getBoolean("com.aptana.ide.editor.html.HTMLEDITOR_INSERT_EQUALS");
        }
        return false;
    }

    public static Lexeme getFirstLexemeBreaking(LexemeList lexemeList, int index, int[] acceptedTypes, int[] deniedTypes) {
        if (index >= lexemeList.size()) {
            return null;
        }
        int i = index;
        while (i < lexemeList.size()) {
            Lexeme currentLexeme = lexemeList.get(i);
            int j = 0;
            while (j < deniedTypes.length) {
                if (currentLexeme.typeIndex == deniedTypes[j]) {
                    return null;
                }
                ++j;
            }
            j = 0;
            while (j < acceptedTypes.length) {
                if (currentLexeme.typeIndex == acceptedTypes[j]) {
                    return currentLexeme;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

