/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.parsing.HTMLLanguageRegistry;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class HTMLParserBase
extends UnifiedParser {
    private static final String DEFAULT_GROUP = "default";
    private static final String ERROR_GROUP = "error";
    private static String NESTED_LANGUAGE_ID = "nested_languages";
    protected IParseNode _currentElement;
    protected HTMLLanguageRegistry languageRegistry;

    public HTMLParserBase() throws ParserInitializationException {
        this("text/html");
    }

    public HTMLParserBase(String language) throws ParserInitializationException {
        super(language);
    }

    protected void addChildParsers() throws ParserInitializationException {
        super.addChildParsers();
        if (this.languageRegistry == null) {
            this.languageRegistry = new HTMLLanguageRegistry();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null) {
                IExtensionPoint extensionPoint = registry.getExtensionPoint(HTMLPlugin.ID, NESTED_LANGUAGE_ID);
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IParser[] parsers = this.languageRegistry.loadFromExtension(extension);
                    int j = 0;
                    while (j < parsers.length) {
                        this.addChildParser(parsers[j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    protected void advance() throws LexerException {
        ILexer lexer = this.getLexer();
        Lexeme currentLexeme = EOS;
        if (this._currentElement != null && this.currentLexeme != null && this.currentLexeme != EOS) {
            this._currentElement.includeLexemeInRange(this.currentLexeme);
        }
        if (!lexer.isEOS()) {
            boolean inWhitespace = true;
            while (inWhitespace) {
                if (lexer.isEOS()) continue;
                currentLexeme = this.getNextLexemeInLanguage();
                if (currentLexeme == null && !lexer.isEOS()) {
                    lexer.setGroup(ERROR_GROUP);
                    currentLexeme = lexer.getNextLexeme();
                }
                if (currentLexeme != null && currentLexeme.typeIndex == 3) {
                    lexer.setCurrentOffset(currentLexeme.offset);
                    lexer.setGroup("unclosed-comment");
                    currentLexeme = lexer.getNextLexeme();
                }
                if (currentLexeme == null) {
                    currentLexeme = EOS;
                    inWhitespace = false;
                    continue;
                }
                this.addLexeme(currentLexeme);
                inWhitespace = false;
            }
        }
        this.currentLexeme = currentLexeme;
    }

    public IParseState createParseState(IParseState parent) {
        HTMLParseState result;
        IParseState root = parent;
        if (parent == null) {
            result = new HTMLParseState();
            root = result.getRoot();
        } else {
            result = new HTMLParseState(root);
        }
        IParser cssParser = this.getParserForMimeType("text/css");
        IParser jsParser = this.getParserForMimeType("text/javascript");
        if (cssParser != null) {
            result.addChildState(cssParser.createParseState(root));
        }
        if (jsParser != null) {
            result.addChildState(jsParser.createParseState(root));
        }
        return result;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setIgnoreSet(language, new int[]{1});
        lexer.setLanguageAndGroup(language, DEFAULT_GROUP);
    }
}

