/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing;

import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.HTMLParserBase;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editor.html.parsing.nodes.HTMLDeclarationNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLDocumentNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLSpecialNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.lexer.matcher.AndMatcher;
import com.aptana.ide.lexer.matcher.CharacterMatcher;
import com.aptana.ide.lexer.matcher.StringMatcher;
import com.aptana.ide.lexer.matcher.WhitespaceMatcher;
import com.aptana.ide.lexer.matcher.ZeroOrMoreMatcher;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import com.aptana.xml.INode;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Stack;

public class HTMLParser
extends HTMLParserBase {
    private static String ATTRIBUTE_LANGUAGE_GROUP = "attribute-language";
    private static String DOUBLE_QUOTED_ATTRIBUTE_DELIMITER_GROUP = "double-quoted-attribute-delimiter";
    private static String SINGLE_QUOTED_ATTRIBUTE_DELIMITER_GROUP = "single-quoted-attribute-delimiter";
    private static final String CDATA_SECTION_GROUP = "cdata-section";
    private static final String DEFAULT_GROUP = "default";
    private static final String PERCENT_INSTRUCTION_GROUP = "percent-instruction";
    private static final String PROCESSING_INSTRUCTION_GROUP = "processing-instruction";
    public static final String ATTRIBUTE_GROUP = "attribute";
    public static final String PERCENT_INSTRUCTION_DELIMITER_GROUP = "percent-instruction-delimiter";
    public static final String PROCESSING_INSTRUCTION_DELIMITER_GROUP = "processing-instruction-delimiter";
    public static final String SCRIPT_DELIMITER_GROUP = "script-delimiter";
    public static final String STYLE_DELIMITER_GROUP = "style-delimiter";
    public static final String TAG_DELIMITER_GROUP = "tag-delimiter";
    private Stack<IParseNode> _elementStack = new Stack();
    private static final int[] elementEndSet = new int[]{30, 39};
    private AndMatcher _closeTagMatcher;
    private StringMatcher _closeTagNameMatcher = new StringMatcher();

    static {
        Arrays.sort(elementEndSet);
    }

    public HTMLParser() throws ParserInitializationException {
        this("text/html");
    }

    public HTMLParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
        this._closeTagNameMatcher.setCaseInsensitive(true);
        ZeroOrMoreMatcher whitespaces = new ZeroOrMoreMatcher();
        whitespaces.appendChild((INode)new WhitespaceMatcher());
        this._closeTagMatcher = new AndMatcher();
        this._closeTagMatcher.appendChild((INode)new StringMatcher("</"));
        this._closeTagMatcher.appendChild((INode)this._closeTagNameMatcher);
        this._closeTagMatcher.appendChild((INode)whitespaces);
        this._closeTagMatcher.appendChild((INode)new CharacterMatcher('>'));
    }

    private void closeElement() {
        if (this._currentElement != null) {
            this._currentElement.includeLexemeInRange(this.currentLexeme);
        }
        this._currentElement = this._elementStack.size() > 0 ? this._elementStack.pop() : null;
    }

    private void openElement(HTMLParseNode element) {
        HTMLParseState parseState;
        if (this._currentElement != null) {
            this._currentElement.appendChild((IParseNode)element);
        }
        if ((parseState = (HTMLParseState)this.getParseState()).getCloseTagType(element.getName()) != 4) {
            this._elementStack.push(this._currentElement);
            this._currentElement = element;
        }
    }

    private HTMLParseNode createNode(int type, Lexeme startingLexeme) {
        return (HTMLParseNode)this.getParseNodeFactory().createParseNode(type, startingLexeme);
    }

    public synchronized void parseAll(IParseNode parentNode) throws LexerException {
        this._elementStack.clear();
        this._currentElement = parentNode;
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), DEFAULT_GROUP);
        this.parseText();
        while (this.currentLexeme != EOS) {
            try {
                switch (this.currentLexeme.typeIndex) {
                    case 24: {
                        this.parseCDATASection();
                        break;
                    }
                    case 2: {
                        this.parseText();
                        break;
                    }
                    case 27: {
                        this.parseEndTag();
                        break;
                    }
                    case 33: {
                        this.parsePercentInstruction();
                        this.parseText();
                        break;
                    }
                    case 34: {
                        this.parseProcessingInstruction();
                        this.parseText();
                        break;
                    }
                    case 41: {
                        this.parseStartTag();
                        break;
                    }
                    case 42: {
                        this.parseXMLDeclaration();
                        break;
                    }
                    case 30: {
                        if (this._currentElement != null) {
                            String currentElementName = ((HTMLParseNode)this._currentElement).getName();
                            if (currentElementName.equals("script")) {
                                this.switchToScriptLanguage();
                                break;
                            }
                            if (currentElementName.equals("style")) {
                                this.switchToStyleLanguage();
                                break;
                            }
                            this.advance();
                            break;
                        }
                        this.advance();
                        break;
                    }
                    default: {
                        if (!this.currentLexeme.getLanguage().equals("text/html")) {
                            LexemeList lexemes = this.getLexemeList();
                            lexemes.getAffectedRegion().includeInRange(this.currentLexeme.offset);
                            lexemes.remove(this.currentLexeme);
                            lexer.setCurrentOffset(this.currentLexeme.offset);
                        }
                        this.advance();
                        break;
                    }
                }
            }
            catch (ParseException parseException) {
                lexer.setGroup(DEFAULT_GROUP);
            }
        }
        if (parentNode instanceof HTMLDocumentNode) {
            this.correctDocumentNodeEndingLexeme((HTMLDocumentNode)parentNode);
        }
    }

    private void correctDocumentNodeEndingLexeme(HTMLDocumentNode parentNode) {
        int childCount = parentNode.getChildCount();
        if (childCount > 0) {
            IParseNode lastChild = parentNode.getChild(childCount - 1);
            parentNode.includeLexemeInRange(lastChild.getEndingLexeme());
        }
    }

    private void parseAttribute(HTMLElementNode element) throws ParseException, LexerException {
        String name = this.currentLexeme.getText();
        this.assertAndAdvance(43, "error.attribute");
        ILexer lexer = this.getLexer();
        lexer.setGroup(ATTRIBUTE_GROUP);
        this.assertAndAdvance(29, "error.attribute.equal");
        if (this.currentLexeme.getCategoryIndex() != 0) {
            String value = this.currentLexeme.getText();
            char firstChar = value.charAt(0);
            IParser parser = null;
            if (firstChar == '\"' || firstChar == '\'') {
                parser = this.languageRegistry.getProcessingInstructionLanguage(name);
            }
            if (this.isType(44)) {
                int quoteType = 0;
                if (value.length() > 1) {
                    if (firstChar == '\"') {
                        value = value.substring(1, value.length() - 1);
                        quoteType = 1;
                    } else if (firstChar == '\'') {
                        value = value.substring(1, value.length() - 1);
                        quoteType = 2;
                    }
                }
                element.setAttribute(name, value);
                IParseNodeAttribute attr = element.getAttributeNode(name);
                attr.setQuoteType(quoteType);
                if (parser != null) {
                    int offset = this.currentLexeme.offset;
                    LexemeList lexemes = this.getLexemeList();
                    lexemes.remove(this.currentLexeme);
                    lexemes.getAffectedRegion().includeInRange(offset);
                    lexer.setCurrentOffset(offset);
                    lexer.setGroup(ATTRIBUTE_LANGUAGE_GROUP);
                    this.advance();
                }
            }
            if (parser != null) {
                Range range = firstChar == '\"' ? lexer.find(DOUBLE_QUOTED_ATTRIBUTE_DELIMITER_GROUP) : lexer.find(SINGLE_QUOTED_ATTRIBUTE_DELIMITER_GROUP);
                this.processNestedLanguage(parser, range.getStartingOffset(), false);
                lexer.setGroup(ATTRIBUTE_LANGUAGE_GROUP);
                this.advance();
            }
        }
        lexer.setGroup(DEFAULT_GROUP);
        this.advance();
    }

    private void parseCDATASection() throws LexerException, ParseException {
        ILexer lexer = this.getLexer();
        lexer.setGroup(CDATA_SECTION_GROUP);
        this.assertAndAdvance(24, "error.cdata");
        this.assertAndAdvance(23, "error.cdata.close");
    }

    private void parseEndTag() throws LexerException, ParseException {
        Lexeme currentLexeme2 = this.currentLexeme;
        this.assertAndAdvance(27, "error.tag.end");
        if (this._currentElement != null) {
            String tagName = HTMLUtils.stripTagEndings(currentLexeme2.getText());
            if (this._currentElement.getName().equalsIgnoreCase(tagName)) {
                this.closeElement();
            }
        }
        ILexer lexer = this.getLexer();
        lexer.setGroup("text");
        this.assertAndAdvance(30, "error.tag.end.close");
        lexer.setGroup(DEFAULT_GROUP);
        if (this.currentLexeme == EOS || this.isType(0)) {
            if (this.currentLexeme != EOS) {
                lexer.setCurrentOffset(this.currentLexeme.offset);
                this.removeLexeme(this.currentLexeme);
            }
            this.advance();
        }
    }

    private void parsePercentInstruction() throws LexerException, ParseException {
        String elementName;
        IParser parser;
        ILexer lexer = this.getLexer();
        Range range = lexer.find(PERCENT_INSTRUCTION_DELIMITER_GROUP);
        int offset = range.getStartingOffset();
        if (range.isEmpty()) {
            offset = lexer.getSourceLength();
        }
        if ((parser = this.languageRegistry.getPercentInstructionLanguage(elementName = this.currentLexeme.getText())) != null) {
            this.processNestedLanguage(parser, offset);
        } else {
            lexer.setGroup(PERCENT_INSTRUCTION_GROUP);
            this.assertAndAdvance(33, "error.percent.instruction");
        }
        lexer.setGroup(DEFAULT_GROUP);
        this.advance();
    }

    private void parseProcessingInstruction() throws LexerException, ParseException {
        IParser parser;
        Range range;
        ILexer lexer = this.getLexer();
        String elementName = this.currentLexeme.getText();
        int offset = lexer.getSourceLength();
        if (!this.languageRegistry.getHandlesEOF(elementName) && !(range = lexer.find(PROCESSING_INSTRUCTION_DELIMITER_GROUP)).isEmpty()) {
            offset = range.getStartingOffset();
        }
        if ((parser = this.languageRegistry.getProcessingInstructionLanguage(elementName)) != null) {
            this.processNestedLanguage(parser, offset);
        } else {
            lexer.setGroup(PROCESSING_INSTRUCTION_GROUP);
            this.assertAndAdvance(34, "error.pi");
        }
        lexer.setGroup(DEFAULT_GROUP);
        this.advance();
    }

    private void parseStartTag() throws ParseException, LexerException {
        Lexeme startTag = this.currentLexeme;
        this.assertType(41, "error.tag.start");
        HTMLElementNode element = (HTMLElementNode)this.createNode(3, this.currentLexeme);
        this.openElement(element);
        String elementName = this.currentLexeme.getText().substring(1).toLowerCase();
        this.advance();
        if (!this.isEOS() && !this.currentLexeme.getLanguage().equals(this.getLanguage())) {
            this.flushCache(TAG_DELIMITER_GROUP);
        }
        while (!this.isEOS() && !this.inSet(elementEndSet)) {
            switch (this.currentLexeme.typeIndex) {
                case 34: {
                    this.parseProcessingInstruction();
                    break;
                }
                case 33: {
                    this.parsePercentInstruction();
                    break;
                }
                default: {
                    this.parseAttribute(element);
                }
            }
        }
        switch (this.currentLexeme.typeIndex) {
            case 30: {
                if (elementName.equals("script")) {
                    this.switchToScriptLanguage();
                    break;
                }
                if (elementName.equals("style")) {
                    this.switchToStyleLanguage();
                    break;
                }
                IParser parser = this.languageRegistry.getElementLanguage(elementName, "", "");
                if (parser != null) {
                    ILexer lexer = this.getLexer();
                    int offset = -1;
                    if (this.languageRegistry.getLanguageOwnsElement(elementName)) {
                        LexemeList lexemes = this.getLexemeList();
                        int startingOffset = startTag.offset;
                        int index = lexemes.getLexemeIndex(startTag);
                        lexemes.remove(index);
                        lexemes.getAffectedRegion().includeInRange(startingOffset);
                        offset = lexer.getSourceLength();
                        lexer.setCurrentOffset(startingOffset);
                    } else {
                        this._closeTagNameMatcher.removeText();
                        this._closeTagNameMatcher.appendText(elementName);
                        char[] source = lexer.getSourceUnsafe();
                        int i = 0;
                        while (i < lexer.getSourceLength()) {
                            int candidate = this._closeTagMatcher.match(source, i, source.length);
                            if (candidate != -1) {
                                offset = i;
                                break;
                            }
                            ++i;
                        }
                        if (offset == -1) {
                            offset = lexer.getSourceLength();
                        }
                    }
                    this.processNestedLanguage(parser, offset);
                    break;
                }
                this.parseText();
                break;
            }
            case 39: {
                if (this._currentElement == element) {
                    this.closeElement();
                }
                this.parseText();
                break;
            }
            default: {
                this.throwParseError("error.tag.start.unclosed");
            }
        }
    }

    private void parseText() throws LexerException {
        ILexer lexer = this.getLexer();
        lexer.setGroup("text");
        this.advance();
        lexer.setGroup(DEFAULT_GROUP);
        if (this.currentLexeme == EOS || this.isType(0)) {
            if (this.currentLexeme != EOS) {
                lexer.setCurrentOffset(this.currentLexeme.offset);
                this.removeLexeme(this.currentLexeme);
            }
            this.advance();
        }
    }

    private void processNestedLanguage(IParser parser, int offset) throws LexerException, ParseException {
        this.processNestedLanguage(parser, offset, false);
    }

    private void processNestedLanguage(IParser parser, int offset, boolean createNode) throws LexerException, ParseException {
        Lexeme startingLexeme = this.currentLexeme;
        this.changeLanguage(parser.getLanguage(), offset, this._currentElement);
        if (createNode) {
            HTMLSpecialNode node = (HTMLSpecialNode)this.createNode(4, startingLexeme);
            node.setLexemeList(this.getParseState().getLexemeList());
            node.setNestedLanguage(parser.getLanguage());
            this.openElement(node);
            this.closeElement();
        }
    }

    private void switchToScriptLanguage() throws ParseException, LexerException {
        this.switchLanguage(SCRIPT_DELIMITER_GROUP, "type");
    }

    private void switchToStyleLanguage() throws ParseException, LexerException {
        this.switchLanguage(STYLE_DELIMITER_GROUP, "type");
    }

    private void switchLanguage(String endingDelimiterGroup, String attributeName) throws LexerException, ParseException {
        IParser parser;
        ILexer lexer = this.getLexer();
        Range range = lexer.find(endingDelimiterGroup);
        int offset = range.getStartingOffset();
        if (range.isEmpty()) {
            offset = lexer.getSourceLength();
        }
        String elementName = this._currentElement.getName();
        String attributeValue = this._currentElement.getAttribute(attributeName);
        if (attributeValue == null) {
            attributeValue = "";
        }
        if ((parser = this.languageRegistry.getElementLanguage(elementName, attributeName, attributeValue)) != null) {
            this.changeLanguage(parser.getLanguage(), offset, this._currentElement);
            this.advance();
        } else {
            LexemeList lexemes = this.getLexemeList();
            lexemes.getAffectedRegion().includeInRange(offset);
            this.parseText();
        }
    }

    private void parseXMLDeclaration() throws LexerException, ParseException {
        this.getLexer().setGroup("xml-declaration");
        HTMLDeclarationNode decl = (HTMLDeclarationNode)this.createNode(2, this.currentLexeme);
        this.assertAndAdvance(42, "error.xml.declaration");
        decl.setVersion(this.currentLexeme.getText());
        this.assertAndAdvance(54, "error.xml.declaration.version");
        if (this.isType(52)) {
            decl.setEncoding(this.currentLexeme.getText());
            this.advance();
        }
        if (this.isType(53)) {
            decl.setStandalone(this.currentLexeme.getText());
            this.advance();
        }
        decl.includeLexemeInRange(this.currentLexeme);
        this.assertAndAdvance(30, "error.xml.declaration.close");
    }
}

