/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.actions.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.tidy.Tidy;

public class PrettyPrintHTML
extends Action
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    IEditorPart part = null;
    ISelection selection = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.part = targetEditor;
    }

    public void run() {
        int tabSize;
        if (!(this.part instanceof ITextEditor)) {
            return;
        }
        ITextEditor editor = (ITextEditor)this.part;
        if (editor == null) {
            return;
        }
        IDocument document = PrettyPrintHTML.getDocument(editor);
        if (document == null) {
            return;
        }
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String doc = null;
        Tidy tidy = new Tidy();
        tidy.setAltText(store.getString("com.aptana.ide.editors.FORMATTING_ALT_TEXT"));
        tidy.setBreakBeforeBR(store.getBoolean("com.aptana.ide.editors.FORMATTING_BREAK_BEFORE_BR"));
        tidy.setDropEmptyParas(store.getBoolean("com.aptana.ide.editors.FORMATTING_DROP_EMPTY_PARAS"));
        tidy.setDropFontTags(store.getBoolean("com.aptana.ide.editors.FORMATTING_DROP_FONT_TAGS"));
        tidy.setEncloseBlockText(store.getBoolean("com.aptana.ide.editors.FORMATTING_ENCLOSE_BLOCK_TEXT"));
        tidy.setEncloseText(store.getBoolean("com.aptana.ide.editors.FORMATTING_ENCLOSE_TEXT"));
        tidy.setFixBackslash(store.getBoolean("com.aptana.ide.editors.FORMATTING_FIX_BACKSLASH"));
        tidy.setFixComments(store.getBoolean("com.aptana.ide.editors.FORMATTING_FIX_COMMENTS"));
        tidy.setHideEndTags(store.getBoolean("com.aptana.ide.editors.FORMATTING_HIDE_END_TAGS"));
        tidy.setIndentAttributes(store.getBoolean("com.aptana.ide.editors.FORMATTING_INDENT_ATTRIBUTES"));
        tidy.setLiteralAttribs(store.getBoolean("com.aptana.ide.editors.FORMATTING_LITERAL_ATTRIBS"));
        tidy.setLogicalEmphasis(store.getBoolean("com.aptana.ide.editors.FORMATTING_LOGICAL_EMPHASIS"));
        tidy.setMakeClean(store.getBoolean("com.aptana.ide.editors.FORMATTING_MAKE_CLEAN"));
        tidy.setNumEntities(store.getBoolean("com.aptana.ide.editors.FORMATTING_NUM_ENTITIES"));
        tidy.setQuoteAmpersand(store.getBoolean("com.aptana.ide.editors.FORMATTING_QUOTE_AMPERSAND"));
        tidy.setQuoteMarks(store.getBoolean("com.aptana.ide.editors.FORMATTING_QUOTE_MARKS"));
        tidy.setQuoteNbsp(store.getBoolean("com.aptana.ide.editors.FORMATTING_QUOTE_NBSP"));
        tidy.setSmartIndent(store.getBoolean("com.aptana.ide.editors.FORMATTING_SMART_INDENT"));
        boolean indentContent = store.getBoolean("com.aptana.ide.editors.FORMATTING_INDENT_CONTENT");
        tidy.setIndentContent(indentContent);
        if (indentContent) {
            tidy.setSpaces(store.getInt("com.aptana.ide.editors.FORMATTING_SPACES_SIZE"));
        }
        if ((tabSize = store.getInt("com.aptana.ide.editors.FORMATTING_TAB_SIZE")) > 0) {
            tidy.setTabsize(store.getInt("com.aptana.ide.editors.FORMATTING_TAB_SIZE"));
        }
        tidy.setUpperCaseAttrs(store.getBoolean("com.aptana.ide.editors.FORMATTING_UPPER_CASE_ATTRS"));
        tidy.setUpperCaseTags(store.getBoolean("com.aptana.ide.editors.FORMATTING_UPPER_CASE_TAGS"));
        tidy.setWord2000(store.getBoolean("com.aptana.ide.editors.FORMATTING_WORD_2000"));
        tidy.setWrapAsp(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_ASP"));
        tidy.setWrapAttVals(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_ATTR_VALUES"));
        tidy.setWrapJste(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_JSTE"));
        int wrapMargin = store.getInt("com.aptana.ide.editors.FORMATTING_WRAP_MARGIN");
        if (wrapMargin > 0) {
            tidy.setWraplen(store.getInt("com.aptana.ide.editors.FORMATTING_WRAP_MARGIN"));
        }
        tidy.setWrapPhp(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_PHP"));
        tidy.setWrapScriptlets(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_SCRIPTLETS"));
        tidy.setWrapSection(store.getBoolean("com.aptana.ide.editors.FORMATTING_WRAP_SECTION"));
        String output = store.getString("com.aptana.ide.editors.FORMATTING_SET_OUTPUT");
        if ("XHTML".equals(output)) {
            tidy.setXHTML(true);
        } else if ("XML".equals(output)) {
            tidy.setXmlOut(true);
        }
        TextSelection ts = (TextSelection)this.selection;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        tidy.setErrout(pw);
        if (this.selection instanceof TextSelection && ((TextSelection)this.selection).getLength() > 0) {
            try {
                doc = document.get(ts.getOffset(), ts.getLength());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                tidy.parse((InputStream)new ByteArrayInputStream(doc.getBytes()), (OutputStream)baos);
                document.replace(ts.getOffset(), ts.getLength(), baos.toString());
            }
            catch (BadLocationException badLocationException) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.PrettyPrintHTML_Selection_Error);
            }
        } else {
            doc = document.get();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tidy.parse((InputStream)new ByteArrayInputStream(doc.getBytes()), (OutputStream)baos);
            if (!baos.toString().equals("") && tidy.getParseErrors() == 0) {
                document.set(baos.toString());
            } else {
                try {
                    pw.flush();
                    pw.close();
                    sw.flush();
                    String errors = sw.toString();
                    ArrayList<Status> statii = new ArrayList<Status>();
                    String[] lines = errors.split("\r|\n|\r\n");
                    int i = 0;
                    while (i < lines.length) {
                        String string = lines[i];
                        Status s = new Status(4, HTMLPlugin.ID, 0, string, null);
                        statii.add(s);
                        ++i;
                    }
                    MultiStatus ms = new MultiStatus(HTMLPlugin.ID, 0, statii.toArray(new IStatus[0]), Messages.PrettyPrintHTML_ErrorStatus, null);
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PrettyPrintHTML_ErrorTidyTitle, (String)Messages.PrettyPrintHTML_ErrorTidyMessage, (IStatus)ms);
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.PrettyPrintHTML_ERR_Tidy, (Throwable)ex);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

