/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.Warning;
import com.aptana.ide.editor.html.HTMLBuildParticipant;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class InvalidXHTMLCommentChecker
extends HTMLBuildParticipant {
    public void build(BuildContext context, IProgressMonitor monitor) {
        if (!this.isHTMLFile(context)) {
            return;
        }
        IParseState parseState = context.getParseState();
        if (!(parseState instanceof HTMLParseState)) {
            return;
        }
        HTMLParseState htmlParseState = (HTMLParseState)parseState;
        if (htmlParseState.getDocumentType() < 6) {
            return;
        }
        ArrayList<Warning> problems = new ArrayList<Warning>();
        LexemeList ll = context.getLexemeList();
        Lexeme[] lexemeArray = ll.toArray();
        int n = lexemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lexeme lexeme = lexemeArray[n2];
            if (lexeme != null && lexeme.getLanguage().equals("text/html") && lexeme.typeIndex == 2) {
                String text = lexeme.getText();
                text = text.substring(4);
                if ((text = text.substring(0, text.length() - 3)).contains("--")) {
                    problems.add(new Warning(1, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, lexeme), lexeme.getStartingOffset(), lexeme.getEndingOffset(), "Comments should not contain '--' in the text. Many browsers mishandle comments not ending in this exact pattern."));
                }
            }
            ++n2;
        }
        context.recordNewProblems(problems);
    }
}

