/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.css.CSSFileLanguageService;
import com.aptana.ide.editor.html.HTMLErrorManager;
import com.aptana.ide.editor.html.HTMLFileLanguageService;
import com.aptana.ide.editor.html.HTMLLanguageEnvironment;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.parsing.HTMLScanner;
import com.aptana.ide.editor.js.JSFileLanguageService;
import com.aptana.ide.editor.js.JSFileServiceFactory;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.jscomment.JSCommentFileLanguageService;
import com.aptana.ide.editor.scriptdoc.ScriptDocFileLanguageService;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.ProfileManager;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.ILanguageEnvironment;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public class HTMLFileServiceFactory
extends BaseFileServiceFactory {
    private static HTMLFileServiceFactory instance;

    public HTMLFileServiceFactory() {
        ProfileManager profileManager = UnifiedEditorsPlugin.getDefault().getProfileManager();
        profileManager.addLanguageSupport("text/html", (ILanguageEnvironment)HTMLLanguageEnvironment.getInstance(), (IFileServiceFactory)this);
        profileManager.addLanguageSupport("text/javascript", JSLanguageEnvironment.getInstance(), (IFileServiceFactory)JSFileServiceFactory.getInstance());
    }

    protected void createChildFileServices(IParser parser, FileService fileService, IParseState parseState, ParentOffsetMapper mapper) {
        this.createCSSFileService(parser, fileService, parseState, mapper);
        this.createJSFileService(parser, fileService, parseState, mapper);
    }

    private void createCSSFileService(IParser parser, FileService fileService, IParseState parseState, ParentOffsetMapper mapper) {
        IParser cssParser = parser.getParserForMimeType("text/css");
        CSSFileLanguageService cssService = new CSSFileLanguageService(fileService, parseState, cssParser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/css", (IFileLanguageService)cssService);
    }

    private void createJSFileService(IParser parser, FileService fileService, IParseState parseState, ParentOffsetMapper mapper) {
        IParser jsParser = parser.getParserForMimeType("text/javascript");
        JSFileLanguageService jsfs = new JSFileLanguageService(fileService, parseState, jsParser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/javascript", (IFileLanguageService)jsfs);
        FileService jsContext = (FileService)jsfs.getFileContext();
        if (jsParser != null) {
            IParser scriptDocParser = jsParser.getParserForMimeType("text/scriptdoc");
            ScriptDocFileLanguageService scriptDocService = new ScriptDocFileLanguageService(fileService, parseState, scriptDocParser, (IParentOffsetMapper)mapper);
            jsContext.addLanguageService("text/scriptdoc", (IFileLanguageService)scriptDocService);
            IParser jsCommentParser = jsParser.getParserForMimeType("text/jscomment");
            JSCommentFileLanguageService jsCommentService = new JSCommentFileLanguageService(fileService, parseState, jsCommentParser, (IParentOffsetMapper)mapper);
            jsContext.addLanguageService("text/jscomment", (IFileLanguageService)jsCommentService);
        }
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/html");
        if (parser == null) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.HTMLFileServiceFactory_ERR_CreateParser, (String)"text/html"));
        }
        return parser;
    }

    public static HTMLFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new HTMLFileServiceFactory();
        }
        return instance;
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/html");
        }
        return result;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParser parser = this.createParser();
        IParser scanner = null;
        FileService fileService = null;
        if (parser != null) {
            if (scanner != null) {
                ((HTMLScanner)scanner).setParser(parser);
            }
            IParseState parseState = parser.createParseState(null);
            fileService = new FileService(parser, parseState, sourceProvider, "text/html");
            ParentOffsetMapper mapper = new ParentOffsetMapper(fileService);
            fileService.setScanner(scanner);
            fileService.setErrorManager((IErrorManager)new HTMLErrorManager(fileService));
            HTMLFileLanguageService htmlService = new HTMLFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)mapper);
            fileService.addLanguageService("text/html", (IFileLanguageService)htmlService);
            this.createChildFileServices(parser, fileService, parseState, mapper);
            if (parse) {
                fileService.doFullParse();
            }
        } else {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLFileServiceFactory_ERR_NullParser);
        }
        return fileService;
    }
}

