/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseNodeBase;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;

public class HTMLEnvironmentLoader {
    IRuntimeEnvironment env;
    int workingFileIndex;

    public HTMLEnvironmentLoader(IRuntimeEnvironment env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadEnvironment(IParseState parseState, LexemeList lexemeList, int fileIndex) {
        IRuntimeEnvironment iRuntimeEnvironment = this.env;
        synchronized (iRuntimeEnvironment) {
            try {
                this.unloadEnvironment(fileIndex);
                this.loadEnvironment(parseState, lexemeList, fileIndex);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.HTMLEnvironmentLoader_ErrorReloadingFile, (int)fileIndex), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadEnvironment(int fileIndex) {
        IRuntimeEnvironment iRuntimeEnvironment = this.env;
        synchronized (iRuntimeEnvironment) {
            this.env.removeFileIds(fileIndex);
        }
    }

    private void loadEnvironment(IParseState parseState, LexemeList lexemeList, int fileIndex) {
        try {
            HTMLParseState ps = (HTMLParseState)parseState.getParseState("text/html");
            IParseNode parseNode = ps.getParseResults();
            if (parseNode != null) {
                this.walkTree(parseNode.getChildren(), fileIndex, new Hashtable());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.HTMLEnvironmentLoader_ErrorLoadingFile, (int)fileIndex), (Throwable)e);
        }
    }

    private void walkTree(IParseNode[] parseNodes, int fileIndex, Hashtable items) {
        int i = 0;
        while (i < parseNodes.length) {
            IParseNode pn = parseNodes[i];
            if (pn instanceof HTMLElementNode) {
                String cssClass;
                HTMLElementNode hn = (HTMLElementNode)pn;
                String id = hn.getID();
                if (id != null) {
                    this.env.addId(id, fileIndex, (ParseNodeBase)hn);
                }
                if ((cssClass = hn.getCSSClass()) != null) {
                    this.env.addClass(cssClass, fileIndex, (ParseNodeBase)hn);
                }
            }
            if (pn.getChildCount() > 0) {
                this.walkTree(pn.getChildren(), fileIndex, items);
            }
            ++i;
        }
    }
}

