/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.BuildParticipant;
import com.aptana.ide.editor.css.CSSColors;
import com.aptana.ide.editor.css.parsing.nodes.CSSSimpleSelectorNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSTermNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.index.core.Index;
import com.aptana.ide.index.core.IndexManager;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSClassesAndIdsIndexer
extends BuildParticipant {
    private Index fIndex;
    private Set<Index> indices = new HashSet<Index>();

    public void buildStarting(List<BuildContext> contexts, boolean isBatch, IProgressMonitor monitor) {
        this.indices.clear();
    }

    public void build(BuildContext context, IProgressMonitor monitor) {
        String extension = context.getFile().getFileExtension();
        if (extension != null && extension.equalsIgnoreCase("css")) {
            this.indexCSS(context);
        } else if (extension != null && (extension.equalsIgnoreCase("html") || extension.equalsIgnoreCase("htm") || extension.equalsIgnoreCase("shtml") || extension.equalsIgnoreCase("xhtml"))) {
            this.indexHTML(context);
        }
    }

    public void buildFinishing(IProgressMonitor monitor) {
        this.saveModifiedIndices();
        this.indices.clear();
    }

    private void saveModifiedIndices() {
        for (Index index : this.indices) {
            try {
                if (index == null) continue;
                index.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void indexHTML(BuildContext context) {
        this.walkNode(context.getRootNode(), context);
    }

    private void walkNode(IParseNode parent, BuildContext context) {
        if (parent == null) {
            return;
        }
        if (parent instanceof HTMLElementNode) {
            String id;
            String cssClass = ((HTMLElementNode)parent).getCSSClass();
            if (cssClass != null && cssClass.trim().length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(cssClass);
                while (tokenizer.hasMoreTokens()) {
                    this.addIndex(context, "css_class", tokenizer.nextToken());
                }
            }
            if ((id = ((HTMLElementNode)parent).getID()) != null && id.trim().length() > 0) {
                this.addIndex(context, "css_identifier", id);
            }
        } else {
            CSSTermNode term;
            String value;
            CSSSimpleSelectorNode node;
            IParseNode[] children;
            if (parent instanceof CSSSimpleSelectorNode && (children = (node = (CSSSimpleSelectorNode)parent).getChildren()) != null && children.length >= 1) {
                IParseNode listNode = children[0];
                IParseNode[] iParseNodeArray = children = listNode.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode textChild = iParseNodeArray[n2];
                    String text = textChild.getText();
                    if (text != null && text.startsWith(".")) {
                        this.addIndex(context, "css_class", text.substring(1));
                    } else if (text != null && text.startsWith("#")) {
                        this.addIndex(context, "css_identifier", text.substring(1));
                    }
                    ++n2;
                }
            }
            if (parent instanceof CSSTermNode && this.isColor(value = (term = (CSSTermNode)parent).getAttribute("value"))) {
                this.addIndex(context, "css_color", CSSColors.to6CharHexWithLeadingHash((String)value.trim()));
            }
        }
        IParseNode[] iParseNodeArray = parent.getChildren();
        int n = iParseNodeArray.length;
        int n3 = 0;
        while (n3 < n) {
            IParseNode child = iParseNodeArray[n3];
            this.walkNode(child, context);
            ++n3;
        }
    }

    private boolean isColor(String value) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        if (CSSColors.namedColorExists((String)value)) {
            return true;
        }
        return value.startsWith("#") && (value.length() == 4 || value.length() == 7);
    }

    private void addIndex(BuildContext context, String category, String word) {
        Index index = this.getIndex(context);
        this.indices.add(index);
        index.addEntry(category, word, context.getFile().getProjectRelativePath().toPortableString());
    }

    private void indexCSS(BuildContext context) {
        LexemeList ll = context.getLexemeList();
        Lexeme[] lexemeArray = ll.toArray();
        int n = lexemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lexeme l = lexemeArray[n2];
            if (l != null && l.getLanguage().equals("text/css")) {
                if (l.typeIndex == 9) {
                    String cssId = l.getText();
                    if (cssId.startsWith("#")) {
                        cssId = cssId.substring(1);
                    }
                    this.addIndex(context, "css_identifier", cssId);
                } else if (l.typeIndex == 8) {
                    String cssClass = l.getText();
                    if (cssClass.startsWith(".")) {
                        cssClass = cssClass.substring(1);
                    }
                    this.addIndex(context, "css_class", cssClass);
                } else if (l.typeIndex == 20 || l.typeIndex == 4 && CSSColors.namedColorExists((String)l.getText().toLowerCase())) {
                    this.addIndex(context, "css_color", CSSColors.to6CharHexWithLeadingHash((String)l.getText()));
                }
            }
            ++n2;
        }
    }

    private Index getIndex(BuildContext context) {
        if (this.fIndex == null) {
            IProject project = context.getFile().getProject();
            this.fIndex = IndexManager.getInstance().getIndex(project.getFullPath().toPortableString());
        }
        return this.fIndex;
    }

    public void cleanStarting(IProject project) {
        Index index = IndexManager.getInstance().getIndex(project.getFullPath().toPortableString());
        index.removeCategories(new String[]{"css_class", "css_identifier"});
    }

    public boolean isActive(IProject project) {
        return true;
    }
}

