/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.editors.views.outline.propertyManager.PropertyManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReadableProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String ID;
    private String name;
    protected Object defaultValue;
    protected Object value;
    private String category;
    private LabelProvider labelProvider = null;
    private PropertyManager subProperites = null;
    private ArrayList propertyChangeListeners;
    private PropertyChangeListener subPropertyListener;

    public ReadableProperty(String ID, String name) {
        this.ID = ID;
        this.name = name;
        this.propertyChangeListeners = new ArrayList();
    }

    public Object getDefaultValue() {
        return this.getUnderlyingDefaultValue();
    }

    public Object getUnderlyingDefaultValue() {
        return this.defaultValue;
    }

    public void setUnderlyingValue(Object newValue) {
        this.value = newValue;
    }

    public void setValue(Object newValue) {
        this.setUnderlyingValue(newValue);
    }

    public void setDefaultValue(Object defaultValue) {
        this.setUnderlyingDefaultValue(defaultValue);
    }

    public void setUnderlyingDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.getUnderlyingValue();
    }

    protected Object getUnderlyingValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.getUnderlyingDefaultValue();
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLabelProvider(LabelProvider provider) {
        this.labelProvider = provider;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public final PropertyDescriptor getPropertyDescriptor() {
        PropertyDescriptor propertyDescriptor = this.getCustomPropertyDescriptor();
        if (this.category != null) {
            propertyDescriptor.setCategory(this.category);
        }
        if (this.labelProvider != null) {
            propertyDescriptor.setLabelProvider((ILabelProvider)this.labelProvider);
        }
        return propertyDescriptor;
    }

    public PropertyDescriptor getCustomPropertyDescriptor() {
        return this.getReadOnlyPropertyDescriptor();
    }

    private PropertyDescriptor getReadOnlyPropertyDescriptor() {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)this.getID(), this.getName());
        return propertyDescriptor;
    }

    public boolean hasDynamicPropertyDescriptor() {
        return false;
    }

    public boolean hasSubProperties() {
        return this.subProperites != null;
    }

    public Object getSubPropertyManager() {
        return this.subProperites;
    }

    public void setSubPropertyManager(PropertyManager propertyManager) {
        if (this.subProperites != null) {
            this.subProperites.removePropertyChangeListener(this.getSubPropertyListener());
        }
        this.subProperites = propertyManager;
        if (this.subProperites != null) {
            this.subProperites.addPropertyChangeListener(this.getSubPropertyListener());
        }
    }

    private PropertyChangeListener getSubPropertyListener() {
        if (this.subPropertyListener == null) {
            this.subPropertyListener = new SubPropertyChangeListener(){
                private static final long serialVersionUID = -3330992827410094475L;

                public void propertyChange(PropertyChangeEvent evt) {
                    ReadableProperty.this.notifyPropertyChangeListeners(evt);
                }
            };
        }
        return this.subPropertyListener;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        int i = 0;
        while (i < this.propertyChangeListeners.size()) {
            PropertyChangeListener l = (PropertyChangeListener)this.propertyChangeListeners.get(i);
            l.propertyChange(event);
            ++i;
        }
    }

    class SubPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -351877929766054322L;

        SubPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ReadableProperty.this.notifyPropertyChangeListeners(evt);
        }
    }
}

