/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.views.outline.propertyManager.EditableProperty;
import com.aptana.ide.editors.views.outline.propertyManager.INumericProperty;
import com.aptana.ide.editors.views.outline.propertyManager.Messages;
import com.aptana.ide.editors.views.outline.propertyManager.SerializableValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class EditableFloatProperty
extends EditableProperty
implements INumericProperty {
    private static final long serialVersionUID = 1L;
    private float maximum = Float.MAX_VALUE;
    private float minimum = Float.MIN_VALUE;

    public EditableFloatProperty(String id, String name, float defaultValue) {
        super(id, name);
        this.setDefaultValue(defaultValue);
    }

    public void setMinimum(float minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(float maximum) {
        this.maximum = maximum;
    }

    public void setDefaultValue(float defaultValue) {
        this.setUnderlyingDefaultValue(String.valueOf(defaultValue));
    }

    public void setValue(float newValue) {
        this.setUnderlyingValue(String.valueOf(newValue));
    }

    public ICellEditorValidator getValidator() {
        if (this.validator == null) {
            this.validator = new SerializableValidator(){
                private static final long serialVersionUID = 909362002324676355L;

                public String isValid(Object value) {
                    float floatValue = -1.0f;
                    try {
                        floatValue = Float.parseFloat((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Messages.EditableNumberProperty_NotANumber;
                    }
                    if (floatValue > EditableFloatProperty.this.maximum) {
                        return StringUtils.format((String)Messages.EditableNumberProperty_ValueMustBeLessThan, (String)Float.toString(EditableFloatProperty.this.maximum));
                    }
                    if (floatValue < EditableFloatProperty.this.minimum) {
                        return StringUtils.format((String)Messages.EditableNumberProperty_ValueMustBeGreaterThan, (String)Float.toString(EditableFloatProperty.this.minimum));
                    }
                    return null;
                }
            };
        }
        return this.validator;
    }

    public Float getFloatValue() {
        return this.getFloat(this.getValue());
    }

    private Float getFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return new Float(Float.parseFloat(str));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return (Float)this.getDefaultValue();
    }

    public Number getNumberValue() {
        return this.getFloatValue();
    }

    public void setNumberValue(Number value) {
        this.setValue(value.floatValue());
    }
}

