/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.folding;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.projection.UnifiedProjectionAnnotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;

public class LanguageProjectAnnotation
extends UnifiedProjectionAnnotation {
    private String language;
    private String nodeType;
    private ImageDescriptor collapsed;
    private ImageDescriptor expanded;

    public LanguageProjectAnnotation(String language, String type) {
        this.language = language;
        this.nodeType = type;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String type) {
        this.nodeType = type;
    }

    public ImageDescriptor getCollapsedImage() {
        if (this.collapsed != null) {
            return this.collapsed;
        }
        return super.getCollapsedImage();
    }

    public ImageDescriptor getExpandedImage() {
        if (this.expanded != null) {
            return this.expanded;
        }
        return super.getExpandedImage();
    }

    public void setCollapsed(ImageDescriptor collapsed) {
        this.collapsed = collapsed;
    }

    public void setExpanded(ImageDescriptor expanded) {
        this.expanded = expanded;
    }

    public void setCollapsedImage(ImageDescriptor collapsed, Color bgcolor, Color fgcolor) {
        this.setCollapsed(collapsed);
        this.setCollapsedImage(bgcolor, fgcolor);
    }

    private int getColorValue(Color color) {
        String blueHex;
        String greenHex;
        String redHex = Integer.toHexString(color.getRed());
        if (redHex.length() == 1) {
            redHex = "0" + redHex;
        }
        if ((greenHex = Integer.toHexString(color.getGreen())).length() == 1) {
            greenHex = "0" + greenHex;
        }
        if ((blueHex = Integer.toHexString(color.getBlue())).length() == 1) {
            blueHex = "0" + blueHex;
        }
        return Integer.parseInt(String.valueOf(redHex) + greenHex + blueHex, 16);
    }

    public void setCollapsedImage(Color bgcolor, Color fgcolor) {
        if (this.collapsed != null) {
            int colorValue = this.getColorValue(bgcolor);
            int fgValue = fgcolor != null ? this.getColorValue(fgcolor) : -1;
            ImageData data = this.collapsed.getImageData();
            int redMask = data.palette.redMask;
            int blueMask = data.palette.blueMask;
            int greenMask = data.palette.greenMask;
            int[] lineData = new int[data.width];
            int y = 0;
            while (y < data.height) {
                data.getPixels(0, y, data.width, lineData, 0);
                int x = 0;
                while (x < lineData.length) {
                    int b;
                    int g;
                    int r;
                    int pixelValue = lineData[x];
                    if (data.depth >= 24) {
                        r = (pixelValue & redMask) >> 16;
                        g = (pixelValue & greenMask) >> 8;
                        b = pixelValue & blueMask;
                    } else {
                        r = pixelValue & redMask;
                        g = (pixelValue & greenMask) >> 8;
                        b = (pixelValue & blueMask) >> 16;
                    }
                    if (r == 158 && g == 158 && b == 158) {
                        data.setPixel(x, y, colorValue);
                    } else if (r == 255 && g == 255 && b == 255 && fgValue > -1) {
                        data.setPixel(x, y, fgValue);
                    }
                    ++x;
                }
                ++y;
            }
            this.collapsed = ImageDescriptor.createFromImageData((ImageData)data);
        }
    }

    public void setExpandedImage(ImageDescriptor expanded, Color bgcolor, Color fgcolor) {
        this.setExpanded(expanded);
        this.setExpandedImage(bgcolor, fgcolor);
    }

    public void setExpandedImage(Color bgcolor, Color fgcolor) {
        if (this.expanded != null) {
            int colorValue = this.getColorValue(bgcolor);
            int fgValue = fgcolor != null ? this.getColorValue(fgcolor) : -1;
            ImageData data = this.expanded.getImageData();
            int redMask = data.palette.redMask;
            int blueMask = data.palette.blueMask;
            int greenMask = data.palette.greenMask;
            int[] lineData = new int[data.width];
            int y = 0;
            while (y < data.height) {
                data.getPixels(0, y, data.width, lineData, 0);
                int x = 0;
                while (x < lineData.length) {
                    int b;
                    int g;
                    int r;
                    int pixelValue = lineData[x];
                    if (data.depth >= 24) {
                        r = (pixelValue & redMask) >> 16;
                        g = (pixelValue & greenMask) >> 8;
                        b = pixelValue & blueMask;
                    } else {
                        r = pixelValue & redMask;
                        g = (pixelValue & greenMask) >> 8;
                        b = (pixelValue & blueMask) >> 16;
                    }
                    if (r == 158 && g == 158 && b == 158) {
                        data.setPixel(x, y, colorValue);
                    } else if (r == 255 && g == 255 && b == 255 && fgValue > -1) {
                        data.setPixel(x, y, fgValue);
                    }
                    ++x;
                }
                ++y;
            }
            this.expanded = ImageDescriptor.createFromImageData((ImageData)data);
        }
    }
}

