/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.errors.FileErrorListener;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.Messages;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ProjectFileErrorListener
extends FileErrorListener {
    IFile file;

    public ProjectFileErrorListener(IFile file) {
        this.file = file;
    }

    public void onErrorsChanged(final IFileError[] errors) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    ProjectFileErrorListener.this.doHandleErrorsJob(errors);
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, ProjectFileErrorListener.getMarkerRule((IResource)this.file), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProjectFileErrorListener_ErrorUpdatingMarkers, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleErrorsJob(IFileError[] errors) {
        ProjectFileErrorListener projectFileErrorListener = this;
        synchronized (projectFileErrorListener) {
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProjectFileErrorListener_ErrorUpdatingErrors, (Throwable)new IllegalStateException(Messages.ProjectFileErrorListener_TreeLocked));
            }
            if (this.file == null || !this.file.exists()) {
                return;
            }
            try {
                String key;
                IMarker[] problemMarkers;
                Hashtable<String, IMarker> h = new Hashtable<String, IMarker>();
                Object[] objectArray = problemMarkers = this.file.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                int n = problemMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = objectArray[n2];
                    key = this.createAnnotationKey(m);
                    if (!h.containsKey(key)) {
                        h.put(key, m);
                    }
                    ++n2;
                }
                objectArray = errors;
                n = errors.length;
                n2 = 0;
                while (n2 < n) {
                    IMarker errorNode = objectArray[n2];
                    key = this.createAnnotationKey(errorNode.getMessage(), errorNode.getOffset(), errorNode.getLength());
                    if (!h.containsKey(key)) {
                        ProjectFileErrorListener.applyErrorToProblemMarker((IFileError)errorNode, this.file);
                    } else {
                        h.remove(key);
                    }
                    ++n2;
                }
                for (IMarker marker : h.values()) {
                    if (marker == null || !marker.getType().equals("org.eclipse.core.resources.problemmarker")) continue;
                    marker.delete();
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProjectFileErrorListener_ErrorHere, (Throwable)e);
            }
        }
    }

    private String createAnnotationKey(String annotationText, int offset, int length) {
        return String.valueOf(offset) + ":" + length + ":" + annotationText;
    }

    private String createAnnotationKey(IMarker marker) {
        try {
            String markerText = (String)marker.getAttribute("message");
            int markerStart = marker.getAttribute("charStart", 0);
            int markerEnd = marker.getAttribute("charEnd", 0);
            return String.valueOf(markerStart) + ":" + (markerEnd - markerStart) + ":" + markerText;
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    private static void applyErrorToProblemMarker(IFileError errorNode, IFile file) {
        try {
            IMarker problemMarker = file.createMarker("org.eclipse.core.resources.problemmarker");
            problemMarker.setAttribute("transient", true);
            problemMarker.setAttribute("severity", errorNode.getSeverity());
            problemMarker.setAttribute("charStart", errorNode.getOffset());
            problemMarker.setAttribute("charEnd", errorNode.getOffset() + errorNode.getLength());
            problemMarker.setAttribute("message", (Object)errorNode.getMessage());
            problemMarker.setAttribute("lineNumber", errorNode.getLineNumber());
        }
        catch (CoreException e1) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ProjectFileErrorListener_Error, (Throwable)e1);
        }
    }

    private static ISchedulingRule getMarkerRule(IResource resource) {
        ISchedulingRule rule = null;
        if (resource != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }
}

