/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.contentassist;

import com.aptana.ide.editors.unified.contentassist.IUnifiedCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class UnifiedCompletionProposal
implements ICompletionProposal,
IUnifiedCompletionProposal {
    protected String displayString;
    protected String replacementString;
    protected int replacementOffset;
    protected int replacementLength;
    protected int cursorPosition;
    protected Image image;
    protected IContextInformation contextInformation;
    protected String additionalProposalInfo;
    protected int objectType;
    protected ITextViewer unifiedViewer;
    protected boolean popAssistOnInsert = false;
    protected Image[] userAgentImages;
    public boolean defaultSelection = false;
    public boolean suggestedSelection = false;

    public UnifiedCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int objectType, ITextViewer unifiedViewer, Image[] userAgentImages) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
        this.objectType = objectType;
        this.unifiedViewer = unifiedViewer;
        this.userAgentImages = userAgentImages;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
            if (this.unifiedViewer != null && this.popAssistOnInsert && ((ITextOperationTarget)this.unifiedViewer).canDoOperation(13)) {
                ((ITextOperationTarget)this.unifiedViewer).doOperation(13);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getReplaceString() {
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public boolean isDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(boolean defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public boolean isSuggestedSelection() {
        return this.suggestedSelection;
    }

    public void setSuggestedSelection(boolean suggestedSelection) {
        this.suggestedSelection = suggestedSelection;
    }

    public boolean activateContentAssistOnInsert() {
        return this.popAssistOnInsert;
    }

    public void scheduleContentAssistOnInsert(boolean popAssistOnInsert) {
        this.popAssistOnInsert = popAssistOnInsert;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public boolean isPopAssistOnInsert() {
        return this.popAssistOnInsert;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    public void setPopAssistOnInsert(boolean popAssistOnInsert) {
        this.popAssistOnInsert = popAssistOnInsert;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.replacementOffset = replacementOffset;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public String getFileLocation() {
        return "";
    }

    public Image[] getUserAgentImages() {
        return this.userAgentImages;
    }
}

