/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.actions.GotoNextMemberAction;
import com.aptana.ide.editors.actions.GotoPreviousMemberAction;
import com.aptana.ide.editors.actions.OpenDeclarationAction;
import com.aptana.ide.editors.actions.QuickOutlineAction;
import com.aptana.ide.editors.actions.ShowPianoKeys;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.actions.CodeFormatAction;
import com.aptana.ide.editors.unified.actions.InformationDispatchAction;
import com.aptana.ide.editors.unified.actions.Messages;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import com.aptana.ide.editors.unified.messaging.UnifiedMessages;
import java.io.StringWriter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class UnifiedActionContributor
extends TextEditorActionContributor {
    public static final String CODE_FORMAT_ACTION_ID = "com.aptana.ide.editors.unified.format";
    public static final String GOTO_NEXT_ACTIONID = "com.aptana.ide.editor.nextMember";
    public static final String GOTO_PREVIOUS_ACTIONID = "com.aptana.ide.editor.previousMember";
    public static final String SHOW_DOC_ACTION_ID = String.valueOf(UnifiedEditorsPlugin.getDefault().getBundle().getSymbolicName()) + ".showDocAction";
    public static final String OPEN_DECLARATION_ACTION_ID = String.valueOf(UnifiedEditorsPlugin.getDefault().getBundle().getSymbolicName()) + ".openDeclarationAction";
    public static final String QUICK_OUTLINE_ACTION_ID = String.valueOf(UnifiedEditorsPlugin.getDefault().getBundle().getSymbolicName()) + ".quickOutlineAction";
    public static final String GOTO_MATCHING_BRACKET_ID = String.valueOf(UnifiedEditorsPlugin.getDefault().getBundle().getSymbolicName()) + ".goto.matching.bracket";
    private IUnifiedEditor activeEditor = null;
    private TextOperationAction fTextOperationAction;
    private InformationDispatchAction fShowDocAction;
    private OpenDeclarationAction fOpenDeclarationAction;
    private QuickOutlineAction fQuickOutlineAction;
    private PairMatchAction pairMatchAction = new PairMatchAction();
    private CodeFormatAction fCodeFormatAction;
    private GotoNextMemberAction gotoNextAction;
    private GotoPreviousMemberAction gotoPreviousMemberAction;
    private PairSelectAction pairSelectAction = new PairSelectAction();
    private PairSelectContentAction pairSelectContentAction = new PairSelectContentAction();
    private RetargetTextEditorAction fGotoMatchingBracket;
    private ShowPianoKeys showPianoKeys;
    private boolean dynamicActionsInitialized = false;
    private IToolBarManager toolBarManager;

    public UnifiedActionContributor() {
        this.fCodeFormatAction = new CodeFormatAction();
        this.gotoNextAction = new GotoNextMemberAction();
        this.gotoNextAction.setActionDefinitionId(GOTO_NEXT_ACTIONID);
        this.gotoPreviousMemberAction = new GotoPreviousMemberAction();
        this.gotoPreviousMemberAction.setActionDefinitionId(GOTO_PREVIOUS_ACTIONID);
        this.fOpenDeclarationAction = new OpenDeclarationAction();
        this.fOpenDeclarationAction.setActionDefinitionId(OPEN_DECLARATION_ACTION_ID);
        this.fQuickOutlineAction = new QuickOutlineAction();
        this.fQuickOutlineAction.setActionDefinitionId(QUICK_OUTLINE_ACTION_ID);
        this.fCodeFormatAction.setActionDefinitionId(CODE_FORMAT_ACTION_ID);
        this.fGotoMatchingBracket = new RetargetTextEditorAction(Messages.RESOURCE_BUNDLE, "GotoMatchingBracket_");
        this.fGotoMatchingBracket.setActionDefinitionId(GOTO_MATCHING_BRACKET_ID);
        this.showPianoKeys = new ShowPianoKeys();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        this.toolBarManager = toolBarManager;
        super.contributeToToolBar(toolBarManager);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("com.aptana.ide.editors.actions.ShowPianoKeys", (IAction)this.showPianoKeys);
    }

    public void dispose() {
        if (this.fTextOperationAction != null) {
            this.fTextOperationAction = null;
        }
        if (this.fShowDocAction != null) {
            this.fShowDocAction.dispose();
            this.fShowDocAction = null;
        }
        if (this.fOpenDeclarationAction != null) {
            this.fOpenDeclarationAction.dispose();
            this.fOpenDeclarationAction = null;
        }
        if (this.fQuickOutlineAction != null) {
            this.fQuickOutlineAction.dispose();
            this.fQuickOutlineAction = null;
        }
        if (this.pairMatchAction != null) {
            this.pairMatchAction = null;
        }
        if (this.fGotoMatchingBracket != null) {
            this.fGotoMatchingBracket = null;
        }
        if (this.pairSelectAction != null) {
            this.pairSelectAction = null;
        }
        if (this.pairSelectContentAction != null) {
            this.pairSelectContentAction = null;
        }
        super.dispose();
    }

    protected void initializeDynamicActions(ITextEditor editor) {
        this.fTextOperationAction = new TextOperationAction(UnifiedMessages.getResourceBundle(), "ShowTooltip.", editor, 16, true);
        this.fShowDocAction = new InformationDispatchAction(UnifiedMessages.getResourceBundle(), "ShowTooltip.", this.fTextOperationAction, editor);
        this.fShowDocAction.setActionDefinitionId("com.aptana.ide.editors.showDocAction");
        this.fShowDocAction.setText(Messages.UnifiedActionContributor_ShowToolTip);
        this.dynamicActionsInitialized = true;
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        IMenuManager navigateMenu;
        if (this.fShowDocAction == null) {
            return;
        }
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("additions", (IAction)this.fShowDocAction);
            editMenu.add((IAction)this.fCodeFormatAction);
            editMenu.setVisible(true);
        }
        if (this.fOpenDeclarationAction != null && (navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenDeclarationAction);
            navigateMenu.setVisible(true);
        }
        if (this.fQuickOutlineAction != null && (navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("open.ext", (IAction)this.fQuickOutlineAction);
            navigateMenu.setVisible(true);
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
            if (!gotoMenu.isVisible()) {
                gotoMenu.setVisible(true);
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        IWorkbenchPartSite bindingPartSite = part.getSite();
        if (part instanceof IUnifiedEditor) {
            this.activeEditor = (IUnifiedEditor)((IUnifiedEditor)part).getEditor();
            bindingPartSite = this.activeEditor.getSite();
            FoldingExtensionPointLoader.updateActions(this.activeEditor);
        } else {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.UnifiedActionContributor_PartNotCorrectEditor, (String)(part + "\n" + this.getStackTrace())));
            this.activeEditor = null;
        }
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        if (this.activeEditor != null) {
            this.doSetActiveEditor((ITextEditor)this.activeEditor, bindingPartSite);
        } else {
            this.toolBarManager.removeAll();
            this.toolBarManager.update(true);
        }
    }

    private void doSetActiveEditor(ITextEditor editor, IWorkbenchPartSite bindingPartSite) {
        EditorFileContext fs;
        this.showPianoKeys.setEditor(editor);
        if (!this.dynamicActionsInitialized && editor != null) {
            this.initializeDynamicActions(editor);
            this.contributeToMenu(this.getActionBars().getMenuManager());
        }
        IFileLanguageService fileEnvironment = null;
        if (editor instanceof UnifiedEditor && (fileEnvironment = (fs = ((UnifiedEditor)editor).getFileContext()).getLanguageService(fs.getDefaultLanguage())) != null) {
            this.fOpenDeclarationAction.setActiveEditor((UnifiedEditor)editor, fileEnvironment);
            this.fQuickOutlineAction.setActiveEditor((UnifiedEditor)editor, fileEnvironment);
        }
        this.gotoNextAction.setActiveEditor(null, (IEditorPart)editor);
        this.gotoPreviousMemberAction.setActiveEditor(null, (IEditorPart)editor);
        this.fCodeFormatAction.setActiveEditor(null, (IEditorPart)editor);
        IKeyBindingService kbs = bindingPartSite.getKeyBindingService();
        kbs.registerAction((IAction)this.fCodeFormatAction);
        kbs.registerAction((IAction)this.gotoNextAction);
        kbs.registerAction((IAction)this.gotoPreviousMemberAction);
        kbs.registerAction((IAction)this.fShowDocAction);
        kbs.registerAction((IAction)this.fOpenDeclarationAction);
        kbs.registerAction((IAction)this.fQuickOutlineAction);
        kbs.registerAction((IAction)this.pairMatchAction);
        kbs.registerAction((IAction)this.pairSelectAction);
        kbs.registerAction((IAction)this.pairSelectContentAction);
    }

    private String getStackTrace() {
        String s = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            s = sw.toString();
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedActionContributor_Error, (Throwable)e);
            return s;
        }
    }

    class PairMatchAction
    extends Action {
        PairMatchAction() {
            super(Messages.UnifiedActionContributor_FindMatchingPair);
            this.setActionDefinitionId("net.sf.colorer.eclipse.editors.pairmatch");
            this.setToolTipText(Messages.UnifiedActionContributor_FindMatchingPair);
        }

        public void run() {
        }
    }

    class PairSelectAction
    extends Action {
        PairSelectAction() {
            super(Messages.UnifiedActionContributor_SelectMatchingPair);
            this.setActionDefinitionId("net.sf.colorer.eclipse.editors.pairselect");
            this.setToolTipText(Messages.UnifiedActionContributor_SelectMatchingPair);
        }

        public void run() {
        }
    }

    class PairSelectContentAction
    extends Action {
        PairSelectContentAction() {
            super(Messages.UnifiedActionContributor_SelectContentsToPair);
            this.setActionDefinitionId("net.sf.colorer.eclipse.editors.pairselectcontent");
            this.setToolTipText(Messages.UnifiedActionContributor_SelectContentsToPair);
        }

        public void run() {
        }
    }
}

