/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.toolbar.IToolBarMember;
import com.aptana.ide.editors.toolbar.IToolbarContributionRegistry;
import com.aptana.ide.editors.toolbar.IToolbarRegistryContributor;
import com.aptana.ide.editors.toolbar.ToolBarContribution;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.InstanceCreator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class ToolBarContributionRegistryImpl {
    private static final String TOOLBAR_ID = "com.aptana.ide.editors.toolbarContribution";
    private static final Object TAG_ELEMENT = "element";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE = "language";
    private static final Object TAG_CONTRIBUTOR = "contributor";
    private static Map toolBarContributions = new HashMap();
    private static Map toolBarContributionNames = new HashMap();
    static WeakHashMap map = new WeakHashMap();
    static WeakHashMap mapListener = new WeakHashMap();
    private static IToolbarContributionRegistry toolbarContributionRegistry = new IToolbarContributionRegistry(){

        public void addContribution(String language, ToolBarContribution tc) {
            ToolBarContributionRegistryImpl.addContribution(language, tc);
        }

        public void removeContribution(String language, ToolBarContribution cont) {
            ToolBarContributionRegistryImpl.removeContribution(language, cont);
        }

        public List getContributions(String language) {
            return ToolBarContributionRegistryImpl.getContributions(language);
        }
    };

    static {
        ToolBarContributionRegistryImpl.loadToolBarContributions();
    }

    public static IToolbarContributionRegistry getInstance() {
        return toolbarContributionRegistry;
    }

    private static List getContributions(String language) {
        ArrayList list = (ArrayList)toolBarContributions.get(language);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private ToolBarContributionRegistryImpl() {
    }

    static void initToolBar(final IUnifiedEditor activeEditor, IToolBarManager toolBarManager) {
        String defaultLanguage = activeEditor.getFileContext().getDefaultLanguage();
        ISourceViewer viewer = activeEditor.getViewer();
        String cLang = (String)map.get(activeEditor);
        if (viewer instanceof TextViewer && cLang == null) {
            final TextViewer tv = (TextViewer)viewer;
            map.put(activeEditor, defaultLanguage);
            final ContextListener selectionChangedListener = new ContextListener(toolBarManager, tv, activeEditor);
            tv.addPostSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
            mapListener.put(activeEditor, selectionChangedListener);
            tv.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    tv.removePostSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
                    mapListener.remove(activeEditor);
                }
            });
            tv.getTextWidget().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    map.remove(activeEditor);
                    selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tv, tv.getSelection()));
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
        if (cLang != null) {
            defaultLanguage = cLang;
        }
        ToolBarContributionRegistryImpl.updateToolbar(toolBarManager, defaultLanguage, activeEditor);
    }

    private static void updateToolbar(IToolBarManager toolBarManager, String defaultLanguage, final IUnifiedEditor editor) {
        toolBarManager.removeAll();
        ArrayList contributions = (ArrayList)toolBarContributions.get(defaultLanguage);
        if (contributions != null) {
            for (final ToolBarContribution name : contributions) {
                Action action = new Action(name.getText(), 1){

                    public void run() {
                        IToolBarMember member = name.getInstance();
                        member.execute(editor, name.getText());
                    }
                };
                action.setImageDescriptor(name.getIcon());
                action.setToolTipText(name.getTooltipText());
                toolBarManager.add((IAction)action);
            }
        }
    }

    private static void loadToolBarContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(TOOLBAR_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String elementName;
                IConfigurationElement element;
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        element = elements[j];
                        elementName = element.getName();
                        if (elementName.equals(TAG_CONTRIBUTOR)) {
                            IToolbarRegistryContributor contributor = (IToolbarRegistryContributor)element.createExecutableExtension(ATTR_CLASS);
                            contributor.contributeToToolbarRegistry(toolbarContributionRegistry);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.log((Plugin)UnifiedEditorsPlugin.getDefault(), (int)4, (String)"Exception while initializing toolbar contribution registry", (Throwable)e);
                    }
                    ++j;
                }
                j = 0;
                while (j < elements.length) {
                    element = elements[j];
                    elementName = element.getName();
                    try {
                        if (elementName.equals(TAG_ELEMENT)) {
                            String parserClass = element.getAttribute(ATTR_CLASS);
                            String language = element.getAttribute(ATTR_LANGUAGE);
                            String icon = element.getAttribute("icon");
                            String text = element.getAttribute("name");
                            String tooltip = element.getAttribute("tooltip");
                            InstanceCreator creator = null;
                            if (parserClass != null && language != null && language.length() > 0) {
                                creator = new InstanceCreator(element, ATTR_CLASS);
                            }
                            String namespaceIdentifier = extension.getNamespaceIdentifier();
                            ImageDescriptor desc = null;
                            if (icon != null && icon.length() > 0) {
                                desc = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)namespaceIdentifier).getEntry(icon));
                            }
                            ToolBarContribution tc = new ToolBarContribution(text, tooltip, desc, creator);
                            ToolBarContributionRegistryImpl.addContribution(language, tc);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.log((Plugin)UnifiedEditorsPlugin.getDefault(), (int)4, (String)"Exception while initializing toolbar contribution registry", (Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void addContribution(String language, ToolBarContribution tc) {
        HashSet<String> set = (HashSet<String>)toolBarContributionNames.get(language);
        if (set == null) {
            set = new HashSet<String>();
            toolBarContributionNames.put(language, set);
        }
        if (set.contains(tc.getText())) {
            return;
        }
        set.add(tc.getText());
        ArrayList<ToolBarContribution> list = (ArrayList<ToolBarContribution>)toolBarContributions.get(language);
        if (list == null) {
            list = new ArrayList<ToolBarContribution>();
            toolBarContributions.put(language, list);
        }
        list.add(tc);
        ToolBarContributionRegistryImpl.update(language);
    }

    private static void removeContribution(String language, ToolBarContribution cont) {
        ArrayList list = (ArrayList)toolBarContributions.get(language);
        HashSet set = (HashSet)toolBarContributionNames.get(language);
        if (list == null) {
            return;
        }
        boolean remove = list.remove(cont);
        if (remove) {
            set.remove(cont.getText());
            ToolBarContributionRegistryImpl.update(language);
        }
    }

    private static void update(String language) {
        for (ContextListener name : mapListener.values()) {
            name.updateIfNeeded(language);
        }
    }

    private static final class ContextListener
    implements ISelectionChangedListener {
        private final IToolBarManager toolBarManager;
        private final TextViewer tv;
        private final IUnifiedEditor activeEditor;

        private ContextListener(IToolBarManager toolBarManager, TextViewer tv, IUnifiedEditor activeEditor) {
            this.toolBarManager = toolBarManager;
            this.tv = tv;
            this.activeEditor = activeEditor;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITextSelection ts = (ITextSelection)event.getSelection();
            int offset = ts.getOffset();
            try {
                String type = TextUtilities.getContentType((IDocument)this.tv.getDocument(), (String)"__unified_partitioning", (int)offset, (boolean)true);
                this.doUpdate(type);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }

        public void updateIfNeeded(String chType) {
            if (this.tv.getTextWidget().isDisposed()) {
                return;
            }
            ITextSelection ts = (ITextSelection)this.tv.getSelection();
            int offset = ts.getOffset();
            try {
                String type = TextUtilities.getContentType((IDocument)this.tv.getDocument(), (String)"__unified_partitioning", (int)offset, (boolean)true);
                if (chType.equals(type)) {
                    ToolBarContributionRegistryImpl.updateToolbar(this.toolBarManager, type, this.activeEditor);
                    this.toolBarManager.update(false);
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }

        private void doUpdate(String type) {
            if (type != null && !type.equals(map.get(this.activeEditor))) {
                map.put(this.activeEditor, type);
                ToolBarContributionRegistryImpl.updateToolbar(this.toolBarManager, type, this.activeEditor);
                this.toolBarManager.update(false);
                WorkbenchWindow activeWorkbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                activeWorkbenchWindow.getCoolBarManager2().update(true);
            }
        }
    }
}

