/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.managers;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.Trace;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.Messages;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.parsing.IParseState;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorInput;

public final class FileContextManager {
    static final FileContextManager INSTANCE = new FileContextManager();
    private Map<String, FileService> _fileServices = new HashMap<String, FileService>();
    public static final int DEFAULT_FILE_INDEX = -1;
    public static final int CURRENT_FILE_INDEX = Integer.MAX_VALUE;
    public static final int BUILT_IN_FILE_INDEX = Integer.MIN_VALUE;

    private FileContextManager() {
    }

    public static FileContextManager getFileServiceManager() {
        return INSTANCE;
    }

    public static FileService get(IEditorInput input) {
        return FileContextManager.get(CoreUIUtils.getURI((IEditorInput)input));
    }

    public static FileService get(String fileURI) {
        fileURI = CoreUIUtils.getURI((String)fileURI);
        return FileContextManager.INSTANCE._fileServices.get(fileURI);
    }

    public static FileService get(File file) {
        String fileURI = CoreUIUtils.getURI((File)file);
        return FileContextManager.INSTANCE._fileServices.get(fileURI);
    }

    public static void add(File file, FileService context) {
        FileContextManager.add(CoreUIUtils.getURI((File)file), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String path, FileService context) {
        path = CoreUIUtils.getURI((String)path);
        Trace.info((String)StringUtils.format((String)Messages.FileContextManager_AddingFileContext, (Object[])new String[]{path, context.toString()}));
        if (FileContextManager.INSTANCE._fileServices.containsKey(path)) {
            FileService fs = FileContextManager.get(path);
            if (fs == context) {
                return;
            }
            IFileLanguageService ls = fs.getLanguageService(fs.getDefaultLanguage());
            ls.reset(false);
            Trace.info((String)StringUtils.format((String)Messages.FileContextManager_ResettingFileContext, (Object[])new String[]{path, context.toString()}));
        }
        Map<String, FileService> map = FileContextManager.INSTANCE._fileServices;
        synchronized (map) {
            FileContextManager.INSTANCE._fileServices.put(path, context);
        }
    }

    public static void disconnectSourceProvider(String fileURI, IFileSourceProvider sourceProvider) {
        FileService context = FileContextManager.INSTANCE._fileServices.get(fileURI = CoreUIUtils.getURI((String)fileURI));
        if (context != null) {
            context.disconnectSourceProvider(sourceProvider);
        }
    }

    public static void connectSourceProvider(String fileURI, DocumentSourceProvider sourceProvider) {
        FileService context = FileContextManager.INSTANCE._fileServices.get(fileURI = CoreUIUtils.getURI((String)fileURI));
        if (context != null) {
            context.connectSourceProvider(sourceProvider);
        }
    }

    public static void remove(IPath path) {
        FileContextManager.remove(path.toOSString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String path) {
        if (FileContextManager.INSTANCE._fileServices.containsKey(path = CoreUIUtils.getURI((String)path))) {
            Trace.info((String)StringUtils.format((String)Messages.FileContextManager_RemovingFileContext, (String)path));
            FileService fs = FileContextManager.get(path);
            IParseState parseState = fs.getParseState();
            if (parseState != null) {
                parseState.unloadFromEnvironment();
                parseState.setFileIndex(-1);
            }
            Map<String, FileService> map = FileContextManager.INSTANCE._fileServices;
            synchronized (map) {
                FileContextManager.INSTANCE._fileServices.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getKeySet() {
        Map<String, FileService> map = FileContextManager.INSTANCE._fileServices;
        synchronized (map) {
            return FileContextManager.INSTANCE._fileServices.keySet().toArray(new String[0]);
        }
    }

    public static void clearAll() {
        String[] keys = FileContextManager.getKeySet();
        int i = 0;
        while (i < keys.length) {
            String path = keys[i];
            FileContextManager.remove(path);
            ++i;
        }
    }

    public static String getURIFromFileIndex(int index) {
        String[] keys = FileContextManager.getKeySet();
        int i = 0;
        while (i < keys.length) {
            String path = keys[i];
            FileService c = FileContextManager.get(path);
            if (c == null) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.FileContextManager_ERR_FileServiceNullForPathWithIndex, (Object[])new Object[]{path, index}));
            } else {
                IParseState state = c.getParseState();
                if (state == null) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.FileContextManager_ERR_ParseStateNullForPathWithIndex, (Object[])new Object[]{path, index}));
                } else if (state.getFileIndex() == index) {
                    return path;
                }
            }
            ++i;
        }
        return "";
    }
}

