/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.actions;

import com.aptana.ide.editors.actions.ICanBeNotNavigatable;
import com.aptana.ide.editors.actions.UnifiedEditorAction;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractGotoMemberAction
extends UnifiedEditorAction {
    protected IUnifiedEditor part;

    public AbstractGotoMemberAction(String actionId, String actionText) {
        super(actionId, actionText);
    }

    protected IParseNode findDeepestNode(IParseNode node, int caretOffset) {
        IParseNode[] navigatableChilds;
        int startingOffset = node.getStartingOffset();
        int endingOffset = node.getEndingOffset();
        IParseNode[] iParseNodeArray = navigatableChilds = this.getNavigatableChilds(node);
        int n = navigatableChilds.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode n3 = iParseNodeArray[n2];
            IParseNode findDeepestNode = this.findDeepestNode(n3, caretOffset);
            if (findDeepestNode != null) {
                return findDeepestNode;
            }
            ++n2;
        }
        if (startingOffset > caretOffset || endingOffset < caretOffset) {
            return null;
        }
        return node;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.part = (IUnifiedEditor)targetEditor;
    }

    protected int getNavigatableIndex(IParseNode node) {
        IParseNode navigatableParent = this.getNavigatableParent(node);
        if (navigatableParent == null) {
            return 0;
        }
        List<IParseNode> asList = Arrays.asList(this.getNavigatableChilds(navigatableParent));
        int indexOf = asList.indexOf(node);
        return indexOf;
    }

    protected IParseNode getFirstNavigatableChild(IParseNode parseNode) {
        parseNode = this.getNavigatableChilds(parseNode)[0];
        return parseNode;
    }

    protected boolean hasNavigatableChilds(IParseNode parseNode) {
        return this.getNavigatableChilds(parseNode).length != 0;
    }

    protected IParseNode[] getNavigatableChilds(IParseNode node) {
        IParseNode[] children = node.getChildren();
        ArrayList<IParseNode> ns = new ArrayList<IParseNode>();
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode n3 = iParseNodeArray[n2];
            if (n3 instanceof ICanBeNotNavigatable) {
                ICanBeNotNavigatable m = (ICanBeNotNavigatable)n3;
                if (m.isNavigatable()) {
                    ns.add(n3);
                }
            } else {
                ns.add(n3);
            }
            ++n2;
        }
        children = new IParseNode[ns.size()];
        ns.toArray(children);
        return children;
    }

    protected IParseNode getNavigatableParent(IParseNode node) {
        IParseNode parent = node.getParent();
        if (parent instanceof ICanBeNotNavigatable) {
            ICanBeNotNavigatable m = (ICanBeNotNavigatable)parent;
            if (m.isNavigatable()) {
                return parent;
            }
            return this.getNavigatableParent(parent);
        }
        return parent;
    }

    protected void placeCursor(int startingOffset) {
        this.part.getViewer().getTextWidget().setCaretOffset(startingOffset);
        this.part.getViewer().revealRange(startingOffset, 0);
    }
}

