/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml;

import com.aptana.xml.IErrorHandler;
import com.aptana.xml.INode;
import com.aptana.xml.NodeBase;

public class DocumentNode
extends NodeBase {
    private INode _rootNode;
    private IErrorHandler _errorHandler;

    public DocumentNode() {
        this.addChildType(INode.class);
    }

    public void appendChild(INode child) {
        super.appendChild(child);
        if (this.getChildCount() == 1) {
            this._rootNode = child;
        }
    }

    public INode getRootNode() {
        return this._rootNode;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void sendError(String message, INode culprit) {
        if (this._errorHandler != null) {
            int line = culprit.getLineNumber();
            int column = culprit.getColumnNumber();
            if (column == -1) {
                column = 0;
            }
            this._errorHandler.handleError(line, column, message);
        }
    }

    public void sendInfo(String message, INode culprit) {
        if (this._errorHandler != null) {
            int line = culprit.getLineNumber();
            int column = culprit.getColumnNumber();
            if (column == -1) {
                column = 0;
            }
            this._errorHandler.handleInfo(line, column, message);
        }
    }

    public void sendWarning(String message, INode culprit) {
        if (this._errorHandler != null) {
            int line = culprit.getLineNumber();
            int column = culprit.getColumnNumber();
            if (column == -1) {
                column = 0;
            }
            this._errorHandler.handleWarning(line, column, message);
        }
    }
}

