/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml;

import com.aptana.xml.Messages;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends ClassLoader {
    private List<Bundle> _bundles = new ArrayList<Bundle>();

    public BundleClassLoader() {
        super(BundleClassLoader.class.getClassLoader());
    }

    public void addBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.BundleClassLoader_Bundled_Undefined);
        }
        if (!this._bundles.contains(bundle)) {
            this._bundles.add(bundle);
        }
    }

    public void removeBundle(Bundle bundle) {
        if (bundle != null) {
            this._bundles.remove(bundle);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.loadClassFromBundles(name);
        if (result == null) {
            throw new ClassNotFoundException(String.valueOf(Messages.BundleClassLoader_Unable_To_Locate_Class) + name);
        }
        return result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = super.findResource(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResource(name);
                if (result != null) break;
            }
        }
        return result;
    }

    protected Enumeration findResources(String name) throws IOException {
        Enumeration result = super.findResources(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResources(name);
                if (result != null) break;
            }
        }
        if (result == null) {
            throw new IOException(String.valueOf(Messages.BundleClassLoader_Unable_To_Locate_Resources) + name);
        }
        return result;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(String.valueOf(Messages.BundleClassLoader_Unable_To_Load_Class) + name);
        }
        return result;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name, resolve);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(String.valueOf(Messages.BundleClassLoader_Unable_To_Load_Class) + name);
        }
        return result;
    }

    private Class<?> loadClassFromBundles(String name) throws ClassNotFoundException {
        Class result = null;
        for (Bundle bundle : this._bundles) {
            try {
                result = bundle.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (result != null) break;
        }
        return result;
    }
}

