/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.matcher;

import com.aptana.ide.parsing.ParsingPlugin;
import com.aptana.ide.parsing.matcher.ILexemeMatcher;
import com.aptana.ide.parsing.matcher.Messages;
import com.aptana.ide.parsing.matcher.ParserMatcher;
import com.aptana.xml.DocumentNode;
import com.aptana.xml.IErrorHandler;
import com.aptana.xml.INode;
import com.aptana.xml.NodeBase;
import com.aptana.xml.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;

public class MatcherParserBuilder
implements IErrorHandler {
    private static final String PARSER_NAMESPACE = "http://www.aptana.com/2007/parser/1.0";
    private static final String MATCHER_SUFFIX = "Matcher";
    private ParserMatcher _parser;

    public static Parser createParserParser() {
        Parser parser = new Parser(PARSER_NAMESPACE);
        parser.addBundle(Platform.getBundle((String)"com.aptana.ide.parsing"));
        parser.addPackage(ILexemeMatcher.class.getPackage().getName());
        parser.addSuffix(MATCHER_SUFFIX);
        parser.setUnknownElementClass(NodeBase.class);
        return parser;
    }

    public ParserMatcher getParser() {
        return this._parser;
    }

    public void handleError(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.getString("MatcherParserBuilder.Error_at_line_column"), Integer.toString(line), Integer.toString(column), message);
        ParsingPlugin.logError(msg);
    }

    public void handleInfo(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.getString("MatcherParserBuilder.Info_at_line_column"), Integer.toString(line), Integer.toString(column), message);
        ParsingPlugin.logInfo(msg);
    }

    public void handleWarning(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.getString("MatcherParserBuilder.Warning_at_line_column"), Integer.toString(line), Integer.toString(column), message);
        ParsingPlugin.logWarning(msg);
    }

    public void loadXML(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.loadXML(inputStream);
        }
        catch (FileNotFoundException e) {
            ParsingPlugin.logError(Messages.getString("MatcherParserBuilder.Error_reading_parser_file"), e);
        }
    }

    public void loadXML(InputStream in) {
        block15: {
            try {
                try {
                    INode node;
                    Parser parser = MatcherParserBuilder.createParserParser();
                    parser.setErrorHandler(this);
                    DocumentNode result = parser.loadXML(in);
                    if (result != null && (node = result.getRootNode()) != null && node instanceof ParserMatcher) {
                        ParserMatcher parserElement = (ParserMatcher)node;
                        parserElement.validate();
                        parserElement.seal();
                        this._parser = parserElement;
                    }
                }
                catch (Exception e) {
                    ParsingPlugin.logError(Messages.getString("MatcherParserBuilder.Error_building_parser"), e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

