/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import com.aptana.ide.parsing.bnf.nodes.TerminalNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalList
implements Iterable<TerminalNode> {
    private List<TerminalNode> _terminals;
    private boolean _epsilon;
    private Set<ProductionNode> _visitedProductions;

    public void add(TerminalNode terminal) {
        if (this._terminals == null) {
            this._terminals = new ArrayList<TerminalNode>();
        }
        if (!this._terminals.contains(terminal)) {
            this._terminals.add(terminal);
        }
    }

    public void add(TerminalList terminals) {
        List<TerminalNode> list = terminals._terminals;
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                this.add(list.get(i));
                ++i;
            }
        }
        if (terminals.hasEpsilon()) {
            this.addEpsilon();
        }
    }

    public void addEpsilon() {
        this._epsilon = true;
    }

    public void addProduction(ProductionNode production) {
        if (this._visitedProductions == null) {
            this._visitedProductions = new HashSet<ProductionNode>();
        }
        this._visitedProductions.add(production);
    }

    public TerminalNode get(int index) {
        TerminalNode result = null;
        if (this._terminals != null && index >= 0 && index < this.size()) {
            result = this._terminals.get(index);
        }
        return result;
    }

    public boolean hasEpsilon() {
        return this._epsilon;
    }

    public boolean hasProduction(ProductionNode production) {
        boolean result = false;
        if (this._visitedProductions != null) {
            result = this._visitedProductions.contains(production);
        }
        return result;
    }

    public void removeEpsilon() {
        this._epsilon = false;
    }

    public int size() {
        int result = 0;
        if (this._terminals != null) {
            result = this._terminals.size();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        if (this._terminals != null && this._terminals.size() > 0) {
            buffer.append(" ");
            buffer.append(this._terminals.get(0).getName());
            int i = 1;
            while (i < this._terminals.size()) {
                buffer.append(", ");
                buffer.append(this._terminals.get(i).getName());
                ++i;
            }
            if (this.hasEpsilon()) {
                buffer.append(", ");
                buffer.append("<e>");
            }
        } else if (this.hasEpsilon()) {
            buffer.append(" <e>");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    @Override
    public Iterator<TerminalNode> iterator() {
        return this._terminals.iterator();
    }
}

