/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing;

import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.ILexerBuilder;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.LexerInitializationException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.lexer.Token;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.parsing.ILanguageChangeListener;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.Messages;
import com.aptana.ide.parsing.ParseStateChild;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.ParsingPlugin;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser
implements IParser {
    protected static final Lexeme EOS;
    protected Lexeme currentLexeme;
    private ILexer _lexer;
    private TokenList _tokenList;
    private IParser _parent;
    private List<IParser> _children;
    private Map<String, IParser> _registeredParsers;
    private IParseState _parseState;
    private String _language;
    private ILanguageChangeListener _languageChangeListener;

    static {
        Token t = new Token(null);
        t.setCategory("Metadata");
        t.setType("$");
        EOS = new Lexeme(t, "$", -1);
    }

    protected AbstractParser(TokenList tokenList) throws ParserInitializationException {
        this._tokenList = tokenList;
        this._language = tokenList.getLanguage();
        this.initialize();
    }

    protected AbstractParser(String language) throws ParserInitializationException {
        this._language = language;
        this.initialize();
    }

    protected void initialize() throws ParserInitializationException {
        this._registeredParsers = new HashMap<String, IParser>();
        this.registerParser(this);
        this.addChildParsers();
        try {
            this.buildLexer();
        }
        catch (LexerException e) {
            String message = Messages.ParserBase_UnableToCreateParserLexerException;
            throw new ParserInitializationException(message, e);
        }
        catch (LexerInitializationException e) {
            String message = Messages.ParserBase_UnableToCreateParserLexerInitializationException;
            throw new ParserInitializationException(message, e);
        }
    }

    protected void addChildParser(IParser child) {
        if (child == null) {
            throw new IllegalArgumentException(Messages.ParserBase_ChildMustNotBeNull);
        }
        if (this._children == null) {
            this._children = new ArrayList<IParser>();
        }
        this._children.add(child);
        this.registerParser(child);
        if (child instanceof AbstractParser) {
            ((AbstractParser)child)._parent = this;
        }
    }

    protected void addChildParsers() throws ParserInitializationException {
    }

    protected void addGrammars(ILexerBuilder lexerBuilder) throws LexerException {
        this.addLexerGrammar(lexerBuilder);
        if (this._children != null) {
            int i = 0;
            while (i < this._children.size()) {
                IParser parser = this._children.get(i);
                if (parser instanceof AbstractParser) {
                    ((AbstractParser)parser).addGrammars(lexerBuilder);
                }
                ++i;
            }
        }
    }

    protected void addLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            throw new IllegalArgumentException(Messages.ParserBase_LexemeMustNotBeNull);
        }
        this.getLexemeList().add(lexeme);
    }

    @Override
    public void addLexerGrammar(ILexerBuilder builder) throws LexerException {
        if (this._tokenList != null) {
            builder.addTokenList(this._tokenList);
        }
    }

    protected void advance() throws LexerException {
        ILexer lexer = this.getLexer();
        Lexeme currentLexeme = EOS;
        if (!lexer.isEOS()) {
            boolean inWhitespace = true;
            while (inWhitespace) {
                if (lexer.isEOS()) continue;
                currentLexeme = this.getNextLexemeInLanguage();
                if (currentLexeme == null && !lexer.isEOS()) {
                    lexer.setGroup("error");
                    currentLexeme = lexer.getNextLexeme();
                }
                if (currentLexeme == null) {
                    currentLexeme = EOS;
                    inWhitespace = false;
                    continue;
                }
                this.addLexeme(currentLexeme);
                inWhitespace = false;
            }
        }
        this.currentLexeme = currentLexeme;
    }

    protected void assertAndAdvance(int type, String errorKey) throws LexerException, ParseException {
        this.assertType(type, errorKey);
        this.advance();
    }

    protected void assertInSet(int[] set, String errorKey) throws ParseException {
        if (!this.inSet(set)) {
            this.throwParseError(errorKey);
        }
    }

    protected void assertType(int type, String errorKey) throws ParseException {
        if (this.currentLexeme.typeIndex != type) {
            this.throwParseError(errorKey);
        }
    }

    protected void buildLexer() throws LexerException, LexerInitializationException {
        MatcherLexerBuilder lexerBuilder = new MatcherLexerBuilder();
        this.addGrammars(lexerBuilder);
        this._lexer = lexerBuilder.buildLexer();
        this.initializeLexers();
    }

    @Override
    public void changeLanguage(String mimeType, int offset, IParseNode parentNode) throws LexerException, ParseException {
        IParser targetParser = this.getParserForMimeType(mimeType);
        ILexer lexer = this.getLexer();
        if (targetParser != null) {
            Lexeme eofLexeme;
            int parentOffset = lexer.getEOFOffset();
            int newOffset = parentOffset > offset ? offset : parentOffset;
            lexer.setEOFOffset(newOffset);
            LexemeList lexemes = this.getLexemeList();
            int eofLexemeIndex = lexemes.getLexemeIndex(newOffset);
            if (eofLexemeIndex > -1 && (eofLexeme = lexemes.get(eofLexemeIndex)) != null) {
                lexemes.getAffectedRegion().includeInRange(eofLexeme);
                lexemes.remove(eofLexeme);
            }
            String language = lexer.getLanguage();
            String group = lexer.getGroup();
            this.fireLanguageChangeEvent(mimeType, lexer.getCurrentOffset());
            targetParser.parseAll(parentNode);
            this.fireLanguageChangeEvent(language, lexer.getCurrentOffset());
            lexer.setLanguageAndGroup(language, group);
            lexer.setEOFOffset(parentOffset);
        } else {
            lexer.setCurrentOffset(offset);
        }
    }

    @Override
    public IParseState createParseState(IParseState parent) {
        ParseStateChild result = parent == null ? new ParseStateChild(this.getLanguage()) : new ParseStateChild(this.getLanguage(), parent);
        return result;
    }

    private void fireLanguageChangeEvent(String mimeType, int currentOffset) {
        ILanguageChangeListener handler = this.getLanguageChangeListener();
        if (handler != null) {
            handler.startNewLanguage(mimeType, currentOffset);
        }
    }

    protected void flushCache(String delimiterGroupName) throws LexerException {
        ILexer lexer = this.getLexer();
        LexemeList lexemes = this.getLexemeList();
        Range range = lexer.find(delimiterGroupName);
        int startingOffset = this.currentLexeme.offset;
        int endingOffset = range.isEmpty() ? lexer.getEOFOffset() : range.getEndingOffset();
        int startingIndex = lexemes.getLexemeCeilingIndex(startingOffset);
        int endingIndex = lexemes.getLexemeFloorIndex(endingOffset);
        if (startingIndex == -1) {
            startingIndex = endingIndex;
        }
        if (endingIndex == -1) {
            endingIndex = startingIndex;
        }
        if (startingIndex != -1 && endingIndex != -1) {
            lexemes.getAffectedRegion().includeInRange(endingOffset);
            lexemes.remove(startingIndex, endingIndex);
            lexer.setCurrentOffset(this.currentLexeme.offset);
            this.advance();
        }
    }

    public int getEndingOffset() {
        int result = this._parent != null ? this._lexer.getSourceLength() : this.getLexemeList().getAffectedRegion().getEndingOffset();
        return result;
    }

    @Override
    public String getLanguage() {
        return this._language;
    }

    @Override
    public ILanguageChangeListener getLanguageChangeListener() {
        ILanguageChangeListener result = null;
        result = this._parent != null ? this._parent.getLanguageChangeListener() : this._languageChangeListener;
        return result;
    }

    protected LexemeList getLexemeList() {
        LexemeList result = null;
        if (this._parent != null) {
            if (this._parent instanceof AbstractParser) {
                result = ((AbstractParser)this._parent).getLexemeList();
            }
        } else {
            result = this._parseState.getLexemeList();
        }
        return result;
    }

    @Override
    public ILexer getLexer() {
        ILexer result = this._parent != null ? this._parent.getLexer() : this._lexer;
        return result;
    }

    protected Lexeme getNextLexemeInLanguage() throws LexerException {
        ILexer lexer = this.getLexer();
        Lexeme result = null;
        while (result == null && !lexer.isEOS()) {
            result = lexer.getNextLexeme();
            if (result != null && result != EOS && !result.getLanguage().equals(this.getLanguage())) {
                LexemeList lexemes = this.getLexemeList();
                lexemes.getAffectedRegion().includeInRange(result);
                this.removeLexeme(result);
                lexer.setCurrentOffset(result.offset);
                result = lexer.getNextLexeme();
            }
            if (result != null || lexer.isEOS()) continue;
            if ("error".equals(lexer.getGroup())) break;
            lexer.setGroup("error");
            result = lexer.getNextLexeme();
            if (result == null && "error".equals(lexer.getGroup())) break;
        }
        return result;
    }

    protected IParseNodeFactory getParseNodeFactory() {
        IParseState parseState = this.getParseState();
        IParseNodeFactory result = null;
        if (parseState != null) {
            result = parseState.getParseNodeFactory();
        }
        return result;
    }

    @Override
    public IParser getParserForMimeType(String language) {
        return this._registeredParsers.get(language);
    }

    protected IParseNode getParseRootNode(IParseNode parentNode, Class<?> baseNodeClass) {
        IParseNode rootNode;
        if (parentNode == null || !baseNodeClass.isAssignableFrom(parentNode.getClass())) {
            IParseNodeFactory nodeFactory = this.getParseNodeFactory();
            if (nodeFactory != null) {
                rootNode = nodeFactory.createRootNode();
                if (parentNode != null) {
                    parentNode.appendChild(rootNode);
                }
            } else {
                rootNode = null;
            }
        } else {
            rootNode = parentNode;
        }
        return rootNode;
    }

    protected IParseState getParseState() {
        IParseState result = null;
        if (this._parent != null) {
            if (this._parent instanceof AbstractParser) {
                result = ((AbstractParser)this._parent).getParseState();
                result = result.getParseState(this.getLanguage());
            }
        } else {
            result = this._parseState;
        }
        return result;
    }

    protected boolean hasParent() {
        return this._parent != null;
    }

    @Override
    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setLanguageAndGroup(language, "default");
    }

    protected void initializeLexers() throws LexerException {
        this.initializeLexer();
        if (this._children != null) {
            int i = 0;
            while (i < this._children.size()) {
                IParser parser = this._children.get(i);
                if (parser instanceof AbstractParser) {
                    ((AbstractParser)parser).initializeLexer();
                }
                ++i;
            }
        }
    }

    protected boolean inSet(int[] set) {
        boolean result = false;
        if (this.currentLexeme != null) {
            int typeIndex = this.currentLexeme.typeIndex;
            int i = 0;
            while (i < set.length) {
                int current = set[i];
                if (current >= typeIndex) {
                    result = current == typeIndex;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected boolean isEOS() {
        return this.currentLexeme == EOS;
    }

    protected boolean isType(int type) {
        return this.currentLexeme.typeIndex == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IParseNode parse(IParseState parseState) throws LexerException {
        IParseNode result = null;
        LexemeList lexemeList = parseState.getLexemeList();
        synchronized (lexemeList) {
            this._parseState = parseState;
            IParseNodeFactory nodeFactory = this.getParseNodeFactory();
            if (nodeFactory != null) {
                result = nodeFactory.createRootNode();
            }
            ILexer lexer = this.getLexer();
            lexer.setLexemeCache(this.getLexemeList());
            lexer.setSource(parseState.getSource());
            lexer.setCurrentOffset(0);
            parseState.onBeforeParse();
            try {
                this.parseAll(result);
            }
            catch (ParseException parseException) {
            }
            catch (Exception e) {
                ParsingPlugin plugin = ParsingPlugin.getDefault();
                String message = Messages.ParserBase_UnexpectedErrorDuringParse;
                if (plugin != null) {
                    plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, (Throwable)e));
                }
                System.err.println(message);
                e.printStackTrace();
            }
            parseState.setParseResults(result);
            parseState.onAfterParse();
        }
        return result;
    }

    @Override
    public void parseAll(IParseNode parentNode) throws ParseException, LexerException {
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), "default");
        this.advance();
        while (!this.isEOS()) {
            this.advance();
        }
    }

    private void registerParser(IParser parser) {
        this._registeredParsers.put(parser.getLanguage(), parser);
    }

    protected void removeLexeme(Lexeme lexeme) {
        this.getLexemeList().remove(lexeme);
    }

    @Override
    public void setLanguageChangeListener(ILanguageChangeListener eventHandler) {
        if (this._parent != null) {
            this._parent.setLanguageChangeListener(eventHandler);
        } else {
            this._languageChangeListener = eventHandler;
        }
    }

    protected void throwParseError(String message) throws ParseException {
        throw new ParseException(message, -1);
    }
}

