/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.StringMatcher;

public class ToDelimiterMatcher
extends AbstractTextMatcher {
    private ITextMatcher _delimiter;
    private boolean _includeDelimiter;
    private boolean _matchEndOfFile;
    private boolean _allowEmpty;
    private IToken _errorToken;

    public ToDelimiterMatcher() {
        this(null);
    }

    public ToDelimiterMatcher(String delimiter) {
        this.appendText(delimiter);
        this._includeDelimiter = true;
        this._allowEmpty = true;
    }

    public void addChildTypes() {
        this.addChildType(ITextMatcher.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        map.addUncategorizedMatcher(target);
    }

    public boolean canMatchNothing() {
        return this._allowEmpty || this._matchEndOfFile;
    }

    protected void createChildrenTokens(ITokenList tokenList) {
        this.wrapChildrenInAndElement();
        super.createChildrenTokens(tokenList);
    }

    public int match(char[] source, int offset, int eofOffset) {
        int result = -1;
        ITextMatcher delimiter = this.getDelimiter();
        if (delimiter != null) {
            boolean foundDelimiter = false;
            int i = offset;
            while (i < eofOffset) {
                int endResult = delimiter.match(source, i, eofOffset);
                if (endResult != -1) {
                    foundDelimiter = true;
                    if (this._includeDelimiter) {
                        result = endResult;
                        break;
                    }
                    result = i;
                    break;
                }
                ++i;
            }
            if (result == -1 && this._matchEndOfFile && i == eofOffset) {
                result = eofOffset;
            }
            if (result != -1) {
                if (result != offset || this._allowEmpty) {
                    if (foundDelimiter) {
                        this.accept(source, offset, result, this.token);
                    } else {
                        this.accept(source, offset, result, this._errorToken);
                    }
                } else {
                    result = -1;
                }
            }
        }
        return result;
    }

    protected void createToken(ITokenList tokenList) {
        super.createToken(tokenList);
        String type = this.getType();
        if (type != null && type.length() > 0) {
            String group = this.getGroup();
            String category = "ERROR";
            String newGroup = this.getSwitchTo();
            IToken token = tokenList.createToken();
            token.setLexerGroup(group);
            token.setCategory(category);
            token.setType(type);
            token.setNewLexerGroup(newGroup);
            tokenList.add(token);
            this._errorToken = token;
        }
    }

    public ITextMatcher getDelimiter() {
        if (this._delimiter == null) {
            this._delimiter = this.getChildCount() > 0 ? (ITextMatcher)this.getChild(0) : new StringMatcher(this.getText());
        }
        return this._delimiter;
    }

    public boolean getIncludeDelimiter() {
        return this._includeDelimiter;
    }

    public boolean getMatchEndOfFile() {
        return this._matchEndOfFile;
    }

    public void setAllowEmpty(boolean value) {
        this._allowEmpty = value;
    }

    public void setIncludeDelimiter(boolean value) {
        this._includeDelimiter = value;
    }

    public void setMatchEndOfFile(boolean value) {
        this._matchEndOfFile = value;
    }

    protected void validateLocal() {
        super.validateLocal();
        String text = this.getText();
        if (this._delimiter == null && (text == null || text.length() == 0)) {
            this.getDocument().sendError(Messages.ToDelimiterMatcher_No_Text_Or_Child_Matcher, this);
        } else if (this.getChildCount() > 1) {
            this.getDocument().sendInfo(Messages.ToDelimiterMatcher_Wrapping_Children, this);
        }
    }
}

