/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.generic;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IPausableServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.OperationCompletionEvent;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.core.impl.servers.AbstractExternalServer;
import com.aptana.ide.server.generic.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;

public class GenericServer
extends AbstractExternalServer
implements IPausableServer {
    private static final String SERVER_IS_NOT_PAUSED = Messages.GenericServer_NOT_PAUSED;
    private static final String ALREADY_PAUSED = Messages.GenericServer_ALREADY_PAUSED;
    private static final String ONLY_RUNNING_SERVER_MAY_BE_PAUSED = Messages.GenericServer_ONLY_RUNNING_CAN_BE_PAUSED;
    private static final String PAUSE_COMMAND_IS_NOT_SPECIFIED = Messages.GenericServer_PAUSE_IS_NOT_SPECIFIED;
    private static final String RESUME_COMMAND_IS_NOT_SPECIFIED = Messages.GenericServer_RESUME_IS_NOT_SPECIFIED;
    private static final String ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE = Messages.GenericServer_ONLY_LOCALS_ARE_OPERABLE;
    private static final IProcess[] NO_PROCESS = new IProcess[0];
    String hostName;
    int port;
    private String boundName;
    private String path;
    private String startCommand;
    private String stopCommand;
    private String resumeCommand;
    private String pauseCommand;
    private String healthURL;
    private int pollingInterval;
    private boolean isLocal;
    private Job healthJob;

    protected void installConfig(IAbstractConfiguration configuration) {
        this.port = configuration.getIntAttribute("port");
        this.hostName = configuration.getStringAttribute("host");
        this.boundName = configuration.getStringAttribute("association_id");
        this.path = configuration.getStringAttribute("path");
        this.startCommand = configuration.getStringAttribute("start");
        this.stopCommand = configuration.getStringAttribute("stop");
        this.stopCommand = configuration.getStringAttribute("stop");
        this.resumeCommand = configuration.getStringAttribute("resume");
        this.pauseCommand = configuration.getStringAttribute("pause");
        this.isLocal = configuration.getBooleanAttribute("isLocal");
        this.healthURL = configuration.getStringAttribute("health_url");
        this.pollingInterval = configuration.getIntAttribute("polling_interval");
        this.setDocumentRoot(configuration.getStringAttribute("document_root"));
        super.installConfig(configuration);
        this.configureHealthJob();
        if (!this.isLocal) {
            this.setServerState(6);
        }
    }

    private void configureHealthJob() {
        if (this.healthJob != null) {
            this.healthJob.cancel();
            this.healthJob = null;
        }
        if (!this.isLocal && this.healthURL != null && this.healthURL.length() > 0 && this.pollingInterval > 0) {
            try {
                URL url = new URL(this.healthURL);
                final String host = url.getHost();
                String path = url.getPath().length() > 0 ? url.getPath() : "/";
                String headLine = "HEAD " + path + " HTTP/1.1";
                String hostLine = "Host: " + host;
                final String request = String.valueOf(headLine) + "\n" + hostLine + "\n\n";
                final int port = url.getPort() != -1 ? url.getPort() : (url.getDefaultPort() != -1 ? url.getDefaultPort() : 80);
                this.healthJob = new Job("Heartbeating to generic server URL"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            Socket socket = new Socket();
                            socket.setKeepAlive(false);
                            socket.setSoLinger(false, 0);
                            socket.setTcpNoDelay(true);
                            socket.setSoTimeout(10000);
                            socket.connect(new InetSocketAddress(host, port), 10000);
                            boolean connected = socket.isConnected();
                            if (connected) {
                                OutputStream os = socket.getOutputStream();
                                PrintWriter writer = new PrintWriter(os, true);
                                writer.println(request);
                                writer.flush();
                                InputStream is = socket.getInputStream();
                                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                                String line = reader.readLine();
                                if (line != null) {
                                    GenericServer.this.setServerState(2);
                                    GenericServer.this.serverChanged();
                                } else {
                                    GenericServer.this.setServerState(0);
                                    GenericServer.this.serverChanged();
                                }
                                reader.close();
                                writer.close();
                                socket.close();
                            } else {
                                GenericServer.this.setServerState(0);
                                GenericServer.this.serverChanged();
                            }
                        }
                        catch (Exception exception) {
                            GenericServer.this.setServerState(0);
                            GenericServer.this.serverChanged();
                        }
                        this.schedule(GenericServer.this.pollingInterval);
                        return Status.OK_STATUS;
                    }
                };
                this.healthJob.setSystem(true);
                this.healthJob.schedule();
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)Messages.GenericServer_ERR_AddChecking, (Throwable)e);
            }
        }
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setIntAttribute("port", this.port);
        config.setStringAttribute("host", this.hostName);
        config.setStringAttribute("association_id", this.boundName);
        config.setStringAttribute("path", this.path);
        config.setStringAttribute("start", this.startCommand);
        config.setStringAttribute("stop", this.stopCommand);
        config.setStringAttribute("resume", this.resumeCommand);
        config.setStringAttribute("pause", this.pauseCommand);
        config.setBooleanAttribute("isLocal", this.isLocal);
        config.setStringAttribute("health_url", this.healthURL);
        config.setIntAttribute("polling_interval", this.pollingInterval);
        config.setStringAttribute("document_root", this.getDocumentRootStr());
        super.storeConfiguration(config);
    }

    public GenericServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
        if (this.isLocal) {
            this.setServerState(4);
        } else {
            this.setServerState(6);
        }
    }

    public String getConfigurationDescription() {
        return "";
    }

    public synchronized IStatus canStart(String launchMode) {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE, null);
        }
        if (this.getServerState() == 0) {
            return Status.OK_STATUS;
        }
        return super.canStart(launchMode);
    }

    public synchronized IStatus canStop() {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE, null);
        }
        if (this.getServerState() == 0 || this.getServerState() == 5) {
            return Status.OK_STATUS;
        }
        return super.canStop();
    }

    public synchronized IStatus canRestart(String mode) {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE, null);
        }
        if (this.getServerState() == 0) {
            return Status.OK_STATUS;
        }
        return super.canRestart(mode);
    }

    public IProcess[] getProcesses() {
        return NO_PROCESS;
    }

    public String getHost() {
        return String.valueOf(this.hostName) + ":" + this.port;
    }

    public boolean isWebServer() {
        return true;
    }

    public IServer[] getAssociatedServers() {
        IServer server;
        if (this.boundName.length() > 0 && (server = ServerCore.getServerManager().findServer(this.boundName)) != null) {
            return new IServer[]{server};
        }
        return new IServer[0];
    }

    protected Properties loadProperties() {
        return null;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    private IStatus doLaunch(String arg) {
        try {
            String[] split = arg.split(" ");
            ArrayList<String> bf = new ArrayList<String>();
            int a = 0;
            while (a < split.length) {
                String sm = split[a].trim();
                if (!"".equals(sm)) {
                    bf.add(sm);
                }
                ++a;
            }
            String[] args = new String[bf.size()];
            bf.toArray(args);
            IProcess exec = GenericServer.exec(this.getPath(), args, null);
            if (exec != null) {
                this.registerProcess(exec);
                return Status.OK_STATUS;
            }
            return new Status(4, "com.aptana.ide.server.core", 4, StringUtils.format((String)"could not create process {0}", (String)this.getPath()), null);
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.core", 4, e.getMessage(), (Throwable)e);
        }
    }

    public static IProcess exec(String program, String[] arguments, String workingDirectory) throws CoreException {
        int cmdLineLength = arguments.length + 1;
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = program;
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = new File(workingDirectory);
        }
        Process p = DebugPlugin.exec((String[])cmdLine, workingDir);
        IProcess process = null;
        if (p != null) {
            Launch launch = new Launch(null, "run", null);
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)program);
            process.setAttribute(IProcess.ATTR_CMDLINE, GenericServer.renderCommandLine(cmdLine));
        }
        return process;
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(' ');
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        IStatus doLaunch = this.doLaunch(this.stopCommand);
        if (doLaunch.isOK()) {
            this.setMode(null);
            this.setServerState(4);
        }
        return doLaunch;
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        String arg = this.startCommand;
        IStatus doLaunch = this.doLaunch(arg);
        if (doLaunch.isOK()) {
            this.setServerState(2);
            this.setMode("run");
        }
        return doLaunch;
    }

    public IStatus canPause() {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE, null);
        }
        if (this.resumeCommand.length() == 0) {
            return new Status(4, "com.aptana.ide.server", 0, RESUME_COMMAND_IS_NOT_SPECIFIED, null);
        }
        if (this.pauseCommand.length() == 0) {
            return new Status(4, "com.aptana.ide.server", 0, PAUSE_COMMAND_IS_NOT_SPECIFIED, null);
        }
        if (this.getServerState() != 2) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_RUNNING_SERVER_MAY_BE_PAUSED, null);
        }
        if (this.getServerState() == 5) {
            return new Status(4, "com.aptana.ide.server", 0, ALREADY_PAUSED, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus canResume() {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 0, ONLY_LOCAL_GENERIC_SERVERS_ARE_OPERABLE, null);
        }
        if (this.resumeCommand.length() == 0) {
            return new Status(4, "com.aptana.ide.server", 0, RESUME_COMMAND_IS_NOT_SPECIFIED, null);
        }
        if (this.pauseCommand.length() == 0) {
            return new Status(4, "com.aptana.ide.server", 0, PAUSE_COMMAND_IS_NOT_SPECIFIED, null);
        }
        if (this.getServerState() != 5) {
            return new Status(4, "com.aptana.ide.server", 0, SERVER_IS_NOT_PAUSED, null);
        }
        return Status.OK_STATUS;
    }

    public void pause(IOperationListener listener, IProgressMonitor monitor) {
        String arg = this.pauseCommand;
        IStatus doLaunch = this.doLaunch(arg);
        if (doLaunch.isOK()) {
            this.setServerState(5);
            this.setMode("run");
        }
        this.serverChanged();
        if (listener != null) {
            listener.done(new OperationCompletionEvent((IServer)this, "pause", Status.OK_STATUS));
        }
    }

    public void resume(IOperationListener listener, IProgressMonitor monitor) {
        String arg = this.resumeCommand;
        IStatus doLaunch = this.doLaunch(arg);
        if (doLaunch.isOK()) {
            this.setServerState(2);
            this.setMode("run");
        }
        this.serverChanged();
        if (listener != null) {
            listener.done(new OperationCompletionEvent((IServer)this, "resume", Status.OK_STATUS));
        }
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        IStatus stop = this.stop(true, monitor);
        if (!stop.isOK()) {
            return stop;
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.serverChanged();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        IStatus start = this.start(mode, monitor);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.serverChanged();
        return start;
    }
}

