/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import com.aptana.ide.server.IServerListener;
import com.aptana.ide.server.IServerRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public final class ServerManager
implements IServerListener {
    private static ServerManager instance;
    private List<IServerRunnable> serverList = new ArrayList<IServerRunnable>();
    private Map<String, IServerRunnable> serverTable = new HashMap<String, IServerRunnable>();
    public List<IServerListener> listeners = new ArrayList<IServerListener>();

    private ServerManager() {
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void launchServer(IServerRunnable server, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        server.addServerListener(this);
        server.start(configuration, mode, launch, monitor);
    }

    public IServerRunnable[] getRunningServers() {
        return this.serverList.toArray(new IServerRunnable[this.serverList.size()]);
    }

    public IServerRunnable getServer(String serverName) {
        return this.serverTable.get(serverName);
    }

    public void addServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    private void fireServerStarted(IServerRunnable server) {
        for (IServerListener listener : this.listeners) {
            listener.serverStarted(server);
        }
    }

    private void fireServerStopped(IServerRunnable server) {
        for (IServerListener listener : this.listeners) {
            listener.serverStopped(server);
        }
    }

    private void fireServerChanged(IServerRunnable server) {
        for (IServerListener listener : this.listeners) {
            listener.serverChanged(server);
        }
    }

    public void serverStarted(IServerRunnable server) {
        this.serverList.add(server);
        this.serverTable.put(server.getLaunchConfiguration().getName(), server);
        this.fireServerStarted(server);
    }

    public void serverStopped(IServerRunnable server) {
        server.removeServerListener(this);
        this.serverList.remove(server);
        this.serverTable.remove(server.getLaunchConfiguration().getName());
        this.fireServerStopped(server);
    }

    public void serverChanged(IServerRunnable server) {
        this.fireServerChanged(server);
    }
}

