/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.Messages;
import com.aptana.ide.server.core.ServerCorePlugin;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class HttpServerLaunchConfiguration {
    private static final String BROWSER_EXE = "browserExecutable";
    private static final String WINDOWS_BROWSER = PlatformUtils.expandEnvironmentStrings((String)"%ProgramFiles%\\Internet Explorer\\iexplore.exe");
    private static final String START_ACTION_TYPE = "startActionType";
    private static final String ENUM_START_ACTION_CURRENT_PAGE = "startCurrentPage";
    private static final String ENUM_START_ACTION_SPECIFIC_PAGE = "startSpecificPage";
    private static final String ENUM_START_ACTION_START_URL = "startUrl";
    public static final int START_ACTION_CURRENT_PAGE = 1;
    public static final int START_ACTION_SPECIFIC_PAGE = 2;
    public static final int START_ACTION_START_URL = 3;
    private static final String EXTERNAL_BASE_URL = "externalBaseUrl";
    private static final String START_PAGE_PATH = "startPagePath";
    private static final String START_PAGE_URL = "startPageUrl";
    private static final String SERVER_TYPE = "serverType";
    private static final String TYPE_INTERNAL = "internal";
    private static final String TYPE_EXTERNAL = "external";
    public static final int SERVER_INTERNAL = 4;
    public static final int SERVER_EXTERNAL = 5;
    private int serverType = 4;
    private int startActionType = 1;
    private String baseUrl;
    private String startPagePath;
    private String startPageUrl;
    private String browserExe;

    public HttpServerLaunchConfiguration() {
    }

    public HttpServerLaunchConfiguration(ILaunchConfiguration configuration) {
        this.load(configuration);
    }

    public void load(ILaunchConfiguration configuration) {
        try {
            this.browserExe = configuration.getAttribute(BROWSER_EXE, "");
            String startTypeStr = configuration.getAttribute(START_ACTION_TYPE, ENUM_START_ACTION_CURRENT_PAGE);
            if (startTypeStr.equals(ENUM_START_ACTION_CURRENT_PAGE)) {
                this.setStartActionType(1);
            } else if (startTypeStr.equals(ENUM_START_ACTION_SPECIFIC_PAGE)) {
                this.setStartActionType(2);
            } else if (startTypeStr.equals(ENUM_START_ACTION_START_URL)) {
                this.setStartActionType(3);
            } else {
                IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)StringUtils.format((String)"Unknown launch start action {0}", (String)startTypeStr));
            }
            this.startPagePath = configuration.getAttribute(START_PAGE_PATH, "");
            this.startPageUrl = configuration.getAttribute(START_PAGE_URL, "");
            String serverTypeStr = configuration.getAttribute(SERVER_TYPE, TYPE_INTERNAL);
            if (serverTypeStr.equals(TYPE_INTERNAL)) {
                this.setServerType(4);
            } else if (serverTypeStr.equals(TYPE_EXTERNAL)) {
                this.setServerType(5);
            } else {
                IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)StringUtils.format((String)Messages.HttpServerLaunchConfiguration_UnknownLaunchServerType, (String)serverTypeStr));
            }
            this.baseUrl = configuration.getAttribute(EXTERNAL_BASE_URL, "");
            this.startPagePath = configuration.getAttribute(START_PAGE_PATH, "");
            this.startPageUrl = configuration.getAttribute(START_PAGE_URL, "");
        }
        catch (CoreException ce) {
            IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)ce.getMessage(), (Throwable)ce);
        }
    }

    public void save(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(BROWSER_EXE, this.browserExe);
        String startTypeStr = TYPE_INTERNAL;
        if (this.startActionType == 1) {
            startTypeStr = ENUM_START_ACTION_CURRENT_PAGE;
        } else if (this.startActionType == 2) {
            startTypeStr = ENUM_START_ACTION_SPECIFIC_PAGE;
        } else if (this.startActionType == 3) {
            startTypeStr = ENUM_START_ACTION_START_URL;
        }
        configuration.setAttribute(START_ACTION_TYPE, startTypeStr);
        configuration.setAttribute(START_PAGE_PATH, this.startPagePath);
        configuration.setAttribute(START_PAGE_URL, this.startPageUrl);
        String serverTypeStr = TYPE_INTERNAL;
        if (this.serverType == 4) {
            serverTypeStr = TYPE_INTERNAL;
        } else if (this.serverType == 5) {
            serverTypeStr = TYPE_EXTERNAL;
        }
        configuration.setAttribute(SERVER_TYPE, serverTypeStr);
        configuration.setAttribute(EXTERNAL_BASE_URL, this.baseUrl);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(START_ACTION_TYPE, ENUM_START_ACTION_CURRENT_PAGE);
        configuration.setAttribute(SERVER_TYPE, TYPE_INTERNAL);
        if (new File(WINDOWS_BROWSER).exists()) {
            configuration.setAttribute(BROWSER_EXE, WINDOWS_BROWSER);
        }
    }

    public int getServerType() {
        return this.serverType;
    }

    public void setServerType(int type) {
        if (type != 5 && type != 4) {
            throw new IllegalArgumentException(StringUtils.format((String)Messages.HttpServerLaunchConfiguration_UnknownServerType, (int)type));
        }
        this.serverType = type;
    }

    public String getExternalBaseUrl() {
        return this.baseUrl;
    }

    public void setExternalBaseUrl(String url) {
        this.baseUrl = url;
    }

    public String getStartPagePath() {
        return this.startPagePath;
    }

    public void setStartPagePath(String startPagePath) {
        this.startPagePath = startPagePath;
    }

    public String getStartPageUrl() {
        return this.startPageUrl;
    }

    public void setStartPageUrl(String startPageUrl) {
        this.startPageUrl = startPageUrl;
    }

    public int getStartActionType() {
        return this.startActionType;
    }

    public void setStartActionType(int startActionType) {
        if (startActionType != 1 && startActionType != 2 && startActionType != 3) {
            throw new IllegalArgumentException(StringUtils.format((String)Messages.HttpServerLaunchConfiguration_UnknownServerStartActionType, (int)startActionType));
        }
        this.startActionType = startActionType;
    }

    public String getBrowserExe() {
        return this.browserExe;
    }

    public void setBrowserExe(String browserExe) {
        this.browserExe = browserExe;
    }
}

