/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.wizard;

import com.aptana.ide.core.ui.update.PluginsImageRegistry;
import com.aptana.ide.installer.wizard.PluginTreeNode;
import com.aptana.ide.installer.wizard.PluginsTreeModel;
import com.aptana.ide.update.manager.InstallerCategory;
import com.aptana.ide.update.manager.Plugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsTreeViewer
implements ICheckStateListener {
    private static final Color FOREGROUND_INSTALLED = Display.getDefault().getSystemColor(15);
    private static final Color FOREGROUND_REGULAR = Display.getDefault().getSystemColor(24);
    private ContainerCheckedTreeViewer fTreeViewer;
    private PluginsTreeModel fModel;
    private Object[] fCheckedElements;
    private PluginsImageRegistry fImages;
    private List<Listener> fListeners;

    private Plugin getPlugin(PluginTreeNode node) {
        Object data = node.getData();
        if (data != null && data instanceof Plugin) {
            return (Plugin)data;
        }
        return null;
    }

    public PluginsTreeViewer(Composite parent) {
        this.fImages = new PluginsImageRegistry(parent.getDisplay());
        this.fCheckedElements = new Object[0];
        this.fListeners = new ArrayList<Listener>();
        this.createContents(parent);
    }

    public void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public void dispose() {
        this.fModel.clear();
        this.fListeners.clear();
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public Plugin[] getSelectedPlugins() {
        Object[] elements;
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        Object[] objectArray = elements = this.fTreeViewer.getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            PluginTreeNode node;
            Object element = objectArray[n2];
            if (element instanceof PluginTreeNode && !(node = (PluginTreeNode)element).isInstalled() && node.getData() instanceof Plugin) {
                plugins.add((Plugin)node.getData());
            }
            ++n2;
        }
        return plugins.toArray(new Plugin[plugins.size()]);
    }

    public void setExpandedCategories(String[] categoryIDs) {
        if (categoryIDs == null || categoryIDs.length == 0) {
            return;
        }
        ArrayList<PluginTreeNode> categories = new ArrayList<PluginTreeNode>();
        String[] stringArray = categoryIDs;
        int n = categoryIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            PluginTreeNode category = this.fModel.getCategory(id);
            if (category != null) {
                categories.add(category);
            }
            ++n2;
        }
        this.fTreeViewer.setExpandedElements((Object[])categories.toArray(new PluginTreeNode[categories.size()]));
        if (categories.size() > 0) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(categories.get(0)));
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof PluginTreeNode) {
            PluginTreeNode node = (PluginTreeNode)element;
            if (node.isInstalled() || PluginsTreeViewer.hasInstalledChildren(node)) {
                this.fTreeViewer.setCheckedElements(this.fCheckedElements);
            } else {
                Object[] elements;
                ArrayList<Object> checked = new ArrayList<Object>();
                Object[] objectArray = elements = this.fTreeViewer.getCheckedElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checkedElement = objectArray[n2];
                    if (!this.fTreeViewer.getGrayed(checkedElement)) {
                        checked.add(checkedElement);
                    }
                    ++n2;
                }
                this.fCheckedElements = checked.toArray(new Object[checked.size()]);
                this.fireItemsCheckedEvent();
            }
        }
    }

    private void createContents(Composite parent) {
        this.fTreeViewer = new ContainerCheckedTreeViewer(parent, 68356);
        Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        this.fTreeViewer.setAutoExpandLevel(-1);
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText("Plugin");
        column.setWidth(350);
        column = new TreeColumn(tree, 16384);
        column.setText("Description");
        column.setWidth(350);
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new PluginsComparator());
        this.fModel = new PluginsTreeModel();
        this.fTreeViewer.setInput((Object)this.fModel);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                PluginsTreeViewer.this.updateForeground();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                PluginsTreeViewer.this.updateForeground();
            }
        });
        this.updateExpansionState();
        this.updateForeground();
    }

    private void updateExpansionState() {
        this.fTreeViewer.setExpandedElements((Object[])this.fModel.getExpandedCategories());
    }

    private void updateForeground() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        PluginsTreeViewer.getAllVisibleItems(items, this.fTreeViewer.getTree().getItems());
        for (TreeItem item : items) {
            Object data = item.getData();
            if (data == null || !(data instanceof PluginTreeNode)) continue;
            PluginTreeNode node = (PluginTreeNode)data;
            if (node.isInstalled()) {
                item.setForeground(FOREGROUND_INSTALLED);
                continue;
            }
            item.setForeground(FOREGROUND_REGULAR);
        }
    }

    private void fireItemsCheckedEvent() {
        int count = this.fCheckedElements.length;
        for (Listener listener : this.fListeners) {
            listener.itemsChecked(count);
        }
    }

    private static void getAllVisibleItems(List<TreeItem> items, TreeItem[] topLevelItems) {
        TreeItem[] treeItemArray = topLevelItems;
        int n = topLevelItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            items.add(item);
            PluginsTreeViewer.getAllVisibleItems(items, item.getItems());
            ++n2;
        }
    }

    private static boolean hasInstalledChildren(PluginTreeNode node) {
        PluginTreeNode[] children;
        PluginTreeNode[] pluginTreeNodeArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PluginTreeNode child = pluginTreeNodeArray[n2];
            if (child.isInstalled() || PluginsTreeViewer.hasInstalledChildren(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PluginsTreeModel) {
                PluginsTreeModel model = (PluginsTreeModel)parentElement;
                return model.getCategories();
            }
            if (parentElement instanceof PluginTreeNode) {
                PluginTreeNode node = (PluginTreeNode)parentElement;
                return node.getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Plugin plugin;
                    Image image = null;
                    if (element instanceof PluginTreeNode && (plugin = PluginsTreeViewer.this.getPlugin((PluginTreeNode)element)) != null) {
                        image = PluginsTreeViewer.this.fImages.getImage(plugin);
                    }
                    return image == null ? PluginsImageRegistry.getDefaultImage() : image;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (!(element instanceof PluginTreeNode)) break;
                    PluginTreeNode node = (PluginTreeNode)element;
                    Object data = node.getData();
                    if (data == null) {
                        return node.getID();
                    }
                    String name = data.toString();
                    if (node.isInstalled()) {
                        return String.valueOf(name) + " (installed)";
                    }
                    return name;
                }
                case 1: {
                    String description;
                    Plugin plugin;
                    if (!(element instanceof PluginTreeNode) || (plugin = PluginsTreeViewer.this.getPlugin((PluginTreeNode)element)) == null || (description = plugin.getDescription()) == null) break;
                    return description;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static interface Listener {
        public void itemsChecked(int var1);
    }

    private class PluginsComparator
    extends ViewerComparator {
        private PluginsComparator() {
        }

        public int category(Object element) {
            PluginTreeNode node;
            Object plugin;
            if (element instanceof PluginTreeNode && (plugin = (node = (PluginTreeNode)element).getData()) != null) {
                if (plugin instanceof InstallerCategory) {
                    return ((InstallerCategory)plugin).getSortWeight();
                }
                if (plugin instanceof Plugin) {
                    return ((Plugin)plugin).getSortweight();
                }
            }
            return super.category(element);
        }
    }
}

