/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.wizard;

import com.aptana.ide.installer.Activator;
import com.aptana.ide.installer.wizard.PluginTreeNode;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.manager.InstallerCategory;
import com.aptana.ide.update.manager.Plugin;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsTreeModel {
    private static final PluginTreeNode ROOT = new PluginTreeNode("root");

    public PluginsTreeModel() {
        PluginsTreeModel.buildPluginTree();
    }

    public void clear() {
        ROOT.clear();
    }

    public PluginTreeNode getCategory(String id) {
        PluginTreeNode[] categories;
        PluginTreeNode[] pluginTreeNodeArray = categories = this.getCategories();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            PluginTreeNode category = pluginTreeNodeArray[n2];
            if (category.getID().equals(id)) {
                return category;
            }
            ++n2;
        }
        return null;
    }

    public PluginTreeNode[] getCategories() {
        return ROOT.getChildren();
    }

    public PluginTreeNode[] getExpandedCategories() {
        PluginTreeNode[] categories;
        ArrayList<PluginTreeNode> nodes = new ArrayList<PluginTreeNode>();
        PluginTreeNode[] pluginTreeNodeArray = categories = ROOT.getChildren();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            InstallerCategory category;
            PluginTreeNode node = pluginTreeNodeArray[n2];
            Object data = node.getData();
            if (data != null && data instanceof InstallerCategory && !(category = (InstallerCategory)data).shouldCollapse()) {
                nodes.add(node);
            }
            ++n2;
        }
        return nodes.toArray(new PluginTreeNode[nodes.size()]);
    }

    private static void buildPluginTree() {
        ROOT.clear();
        IPluginManager pluginManager = PluginsTreeModel.getPluginManager();
        if (pluginManager != null) {
            List plugins = pluginManager.getRemotePlugins();
            for (Plugin plugin : plugins) {
                InstallerCategory category = plugin.getInstallerCategory();
                if (category == null) continue;
                PluginTreeNode catNode = PluginsTreeModel.generateNodePath(category);
                catNode.add(new PluginTreeNode(plugin));
            }
        }
        PluginsTreeModel.updateStates();
    }

    protected static IPluginManager getPluginManager() {
        return Activator.getDefault().getPluginManager();
    }

    private static PluginTreeNode generateNodePath(InstallerCategory category) {
        ArrayList<InstallerCategory> path = new ArrayList<InstallerCategory>();
        path.add(category);
        InstallerCategory parentCategory = category.getParent();
        while (parentCategory != null) {
            path.add(parentCategory);
            parentCategory = parentCategory.getParent();
        }
        PluginTreeNode parentNode = ROOT;
        int index = path.size() - 1;
        while (index > -1) {
            InstallerCategory childCategory = (InstallerCategory)path.get(index);
            PluginTreeNode catNode = parentNode.getChild(childCategory.getID());
            if (catNode == null) {
                catNode = new PluginTreeNode(childCategory);
                parentNode.add(catNode);
            }
            parentNode = catNode;
            --index;
        }
        return parentNode;
    }

    private static void updateStates() {
        ArrayList<PluginTreeNode> availablePlugins = new ArrayList<PluginTreeNode>();
        PluginTreeNode[] categories = ROOT.getChildren();
        PluginsTreeModel.updatePluginsList(availablePlugins, categories);
        IPluginManager pluginManager = PluginsTreeModel.getPluginManager();
        if (pluginManager != null) {
            List installedPlugins = pluginManager.getInstalledPlugins();
            for (PluginTreeNode plugin : availablePlugins) {
                plugin.setInstalled(PluginsTreeModel.isInstalled(plugin, installedPlugins));
            }
        }
    }

    private static boolean isInstalled(PluginTreeNode node, List<IPlugin> installedPlugins) {
        Object data = node.getData();
        if (!(data instanceof IPlugin)) {
            return false;
        }
        IPlugin plugin = (IPlugin)data;
        for (IPlugin installed : installedPlugins) {
            if (!installed.getId().equals(plugin.getId())) continue;
            return true;
        }
        return false;
    }

    private static void updatePluginsList(List<PluginTreeNode> plugins, PluginTreeNode[] nodes) {
        PluginTreeNode[] pluginTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            PluginTreeNode node = pluginTreeNodeArray[n2];
            Object data = node.getData();
            if (data != null) {
                plugins.add(node);
            }
            PluginsTreeModel.updatePluginsList(plugins, node.getChildren());
            ++n2;
        }
    }
}

