/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.wizard;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.installer.Activator;
import com.aptana.ide.installer.wizard.InstallerWizard;
import com.aptana.ide.installer.wizard.Messages;
import com.aptana.ide.installer.wizard.PluginsTreeViewer;
import com.aptana.ide.installer.wizard.PluginsWizardPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class InstallerWizardDialog
extends WizardDialog
implements PluginsTreeViewer.Listener {
    private static final String INSTALL_LABEL = Messages.InstallerWizardDialog_InstallLabel;
    private static final String CLOSE_LABEL = Messages.InstallerWizardDialog_CloseLabel;
    private Button fDoNotShowButton;
    private InstallerWizard fWizard;

    public InstallerWizardDialog(Shell parentShell, InstallerWizard newWizard) {
        super(parentShell, (IWizard)newWizard);
        this.fWizard = newWizard;
        this.setHelpAvailable(false);
    }

    public void create() {
        super.create();
        this.getFinishButton().setEnabled(false);
        this.getPluginsTree().addListener(this);
    }

    public boolean close() {
        this.getPluginsTree().removeListener(this);
        this.saveStates();
        return super.close();
    }

    public void itemsChecked(int count) {
        this.getFinishButton().setEnabled(count > 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        GridData gridData = (GridData)parent.getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Composite button = new Composite(parent, 0);
        button.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)button);
        gridData.widthHint = gc.stringExtent((String)Messages.InstallerWizardDialog_DoNotShowNote).x + 10;
        gc.dispose();
        button.setLayoutData((Object)gridData);
        this.fDoNotShowButton = new Button(button, 32);
        this.fDoNotShowButton.setText(Messages.InstallerWizardDialog_DoNotShowLabel);
        this.fDoNotShowButton.setFont(JFaceResources.getDialogFont());
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        boolean donotshow = prefs.contains("WizardDoNotShowAgain") ? prefs.getBoolean("WizardDoNotShowAgain") : prefs.getBoolean("WizardDoNotShowAgainDefault");
        this.fDoNotShowButton.setSelection(donotshow);
        this.fDoNotShowButton.setLayoutData((Object)new GridData(1, 4, true, true));
        this.fDoNotShowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallerWizardDialog.this.saveStates();
                InstallerWizardDialog.this.updateDoNotShowLayout();
            }
        });
        Button managePluginsButton = new Button(parent, 8);
        managePluginsButton.setText(Messages.InstallerWizardDialog_Manage_Plugins);
        managePluginsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    InstallerWizardDialog.this.close();
                    CoreUIUtils.showView((String)"com.aptana.ide.ui.ViewPlugins");
                }
                catch (PartInitException partInitException) {}
            }
        });
        super.createButtonsForButtonBar(parent);
        this.getFinishButton().setText(INSTALL_LABEL);
        this.getButton(1).setText(CLOSE_LABEL);
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
        GridData gridData = (GridData)button.getLayoutData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 0x1000008;
    }

    private Button getFinishButton() {
        return this.getButton(16);
    }

    private PluginsTreeViewer getPluginsTree() {
        return ((PluginsWizardPage)this.fWizard.getPage("PluginsSelection")).getTreeViewer();
    }

    private void updateDoNotShowLayout() {
        if (this.fDoNotShowButton.getSelection()) {
            this.setMessage(Messages.InstallerWizardDialog_DoNotShowNote, 1);
        } else {
            this.setMessage(Messages.PluginsWizardPage_Description);
        }
    }

    private void saveStates() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setValue("WizardDoNotShowAgain", this.fDoNotShowButton.getSelection());
    }
}

