/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.views;

import com.aptana.ide.core.ui.update.PluginsImageRegistry;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.Plugin;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InstalledPluginsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int COLUMN_IMAGE = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_VERSION = 2;
    private static final int COLUMN_RELEASE_DATE = 3;
    private static final int COLUMN_DESCRIPTION = 4;
    private static final String EMPTY = "";
    private static final String RELEASE_DATE_FORMAT = "yyyy-MM-dd";
    private PluginsImageRegistry fImages;

    public InstalledPluginsLabelProvider(Display display) {
        this.fImages = new PluginsImageRegistry(display);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof Plugin) {
            return this.fImages.getImage((Plugin)element);
        }
        return PluginsImageRegistry.getDefaultImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof IPlugin)) {
            return EMPTY;
        }
        IPlugin plugin = (IPlugin)element;
        switch (columnIndex) {
            case 1: {
                return plugin.getName();
            }
            case 2: {
                return plugin.getVersion();
            }
            case 3: {
                if (plugin instanceof Plugin) {
                    Calendar release = ((Plugin)plugin).getReleaseDate();
                    if (release == null) {
                        return EMPTY;
                    }
                    SimpleDateFormat format = new SimpleDateFormat(RELEASE_DATE_FORMAT);
                    return format.format(release.getTime());
                }
            }
            case 4: {
                if (!(plugin instanceof Plugin)) break;
                return ((Plugin)plugin).getDescription();
            }
        }
        return EMPTY;
    }
}

