/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.internal.core.resources;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.internal.core.resources.MarkerDelta;
import com.aptana.ide.internal.core.resources.MarkerInfo;
import com.aptana.ide.internal.core.resources.MarkerManager;
import com.aptana.ide.internal.core.resources.Messages;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class UniformResourceMarker
extends PlatformObject
implements IUniformResourceMarker {
    private IUniformResource resource;
    private long id;

    public UniformResourceMarker(IUniformResource resource, long id) {
        this.resource = resource;
        this.id = id;
    }

    public void delete() throws CoreException {
        UniformResourceMarker.getMarkerManager().removeMarker(this.resource, this.id);
    }

    public boolean exists() {
        return this.getInfo() != null;
    }

    public Object getAttribute(String attributeName) throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttribute(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Map getAttributes() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttributes(attributeNames);
    }

    public long getCreationTime() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getCreationTime();
    }

    public long getId() {
        return this.id;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IUniformResource getUniformResource() {
        return this.resource;
    }

    public String getType() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getType();
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        return UniformResourceMarker.getMarkerManager().isSubtype(this.getType(), superType);
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.setAttribute(attributeName, new Integer(value));
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        try {
            Method m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttribute", String.class, Object.class, Boolean.class);
            if (m != null) {
                m.invoke((Object)info, attributeName, value, true);
            } else {
                m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttribute", String.class, Object.class);
                m.invoke((Object)info, attributeName, value);
            }
            IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(4, this.resource, info)};
            UniformResourceMarker.getMarkerManager().changedMarkers(this.resource, changes);
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
        }
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.setAttribute(attributeName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        try {
            Method m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", String[].class, Object[].class, Boolean.class);
            if (m != null) {
                m.invoke((Object)info, attributeNames, values, true);
            } else {
                m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", String.class, Object.class);
                m.invoke((Object)info, attributeNames, values);
            }
            IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(4, this.resource, info)};
            UniformResourceMarker.getMarkerManager().changedMarkers(this.resource, changes);
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
        }
    }

    public void setAttributes(Map attributes) throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        try {
            Method m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", Map.class, Boolean.class);
            if (m != null) {
                m.invoke((Object)info, attributes, true);
            } else {
                m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", Map.class);
                m.invoke((Object)info, attributes);
            }
            IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(4, this.resource, info)};
            UniformResourceMarker.getMarkerManager().changedMarkers(this.resource, changes);
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UniformResourceMarker)) {
            return false;
        }
        return this.resource.equals(((UniformResourceMarker)obj).resource) && this.id == ((UniformResourceMarker)obj).id;
    }

    public int hashCode() {
        return (int)this.id + this.resource.hashCode();
    }

    protected MarkerInfo getInfo() {
        return UniformResourceMarker.getMarkerManager().findMarkerInfo(this.resource, this.id);
    }

    private static MarkerManager getMarkerManager() {
        return MarkerManager.getInstance();
    }

    private void checkInfo(MarkerInfo info) throws CoreException {
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.core", 0, Messages.UniformResourceMarker_UniformResourceMarketInfoNull, null));
        }
    }
}

