/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.online;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.online.IOnlineStateChangedListener;
import com.aptana.ide.core.online.Messages;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class OnlineDetectionService {
    protected static final long REGULAR_SLEEP_DELAY = 30000L;
    protected static final long LONG_SLEEP_DELAY = 600000L;
    private static final int URL_TIMEOUT = 10000;
    private static OnlineDetectionService INSTANCE = null;
    private List<URL> _detectionURLs = new ArrayList<URL>();
    private static ListenerList listeners = new ListenerList();
    private StatusMode _status = StatusMode.UNKNOWN;
    private Job _detectionJob;
    private long _delay = 600000L;

    private OnlineDetectionService() {
        this.startDetectionThread();
    }

    public static OnlineDetectionService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OnlineDetectionService();
        }
        return INSTANCE;
    }

    public StatusMode getStatus() {
        return this._status;
    }

    public static void addListener(IOnlineStateChangedListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(IOnlineStateChangedListener listener) {
        listeners.remove((Object)listener);
    }

    public void addDetectionURL(URL url) {
        if (!this._detectionURLs.contains(url)) {
            this._detectionURLs.add(url);
            this.detectOnlineStatus();
        }
    }

    public void removeDetectionURL(URL url) {
        this._detectionURLs.remove(url);
    }

    public void setDelay(boolean isLongDelay) {
        long oldDelay = this._delay;
        this._delay = isLongDelay ? 600000L : 30000L;
        if (this._delay != oldDelay) {
            this._detectionJob.cancel();
            this._detectionJob.schedule();
        }
    }

    private void detectOnlineStatus() {
        new Thread(new Runnable(){

            public void run() {
                StatusMode oldStatus = OnlineDetectionService.this._status;
                try {
                    if (OnlineDetectionService.this._detectionURLs.size() == 0) {
                        OnlineDetectionService.this._status = StatusMode.UNKNOWN;
                        return;
                    }
                    for (URL url : OnlineDetectionService.this._detectionURLs) {
                        if (OnlineDetectionService.isAvailable(url)) continue;
                        OnlineDetectionService.this._status = StatusMode.OFFLINE;
                        return;
                    }
                    OnlineDetectionService.this._status = StatusMode.ONLINE;
                }
                finally {
                    if (oldStatus != OnlineDetectionService.this._status) {
                        OnlineDetectionService.this.notifyListeners(oldStatus);
                    }
                }
            }
        }, "DetectOnlineStatus URL Checker").run();
    }

    private void notifyListeners(final StatusMode oldStatus) {
        Object[] oListeners = listeners.getListeners();
        int i = 0;
        while (i < oListeners.length) {
            final IOnlineStateChangedListener listener = (IOnlineStateChangedListener)oListeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), Messages.getString("OnlineDetectionService.Error_Notifying_Listener"), exception);
                }

                public void run() throws Exception {
                    listener.stateChanged(oldStatus, OnlineDetectionService.this.getStatus());
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    public static boolean isAvailable(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setReadTimeout(10000);
            conn.connect();
            conn.getResponseCode();
            conn.disconnect();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.getString("OnlineDetectionService.Checking_URL_Availability"), url, e.getMessage());
            IdeLog.logInfo(AptanaCorePlugin.getDefault(), message);
            return false;
        }
        return true;
    }

    private void startDetectionThread() {
        this._detectionJob = new Job("Aptana: Online Detection Service"){

            protected IStatus run(IProgressMonitor monitor) {
                OnlineDetectionService.this.detectOnlineStatus();
                this.schedule(OnlineDetectionService.this._delay);
                return Status.OK_STATUS;
            }
        };
        this._detectionJob.setPriority(40);
        this._detectionJob.setSystem(true);
        this._detectionJob.schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusMode {
        UNKNOWN,
        ONLINE,
        OFFLINE;

    }
}

