/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model.user;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.user.AuthenticatedUserRequestBuilder;
import com.aptana.ide.core.model.user.Messages;
import com.aptana.ide.core.model.user.User;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;

public class AptanaUser {
    private static final String SECURE_PREF_NODE = "/com/aptana/ide/core";
    private static final String USER_URL_OVERRIDE = "USER_URL_OVERRIDE";
    private static final String PROPERTY_KEY = "SiteManagerSelection";
    public static final String BASE_URL;
    public static final String USERS;
    public static final String LOGINS;
    private static final String INSTALL_LOCATION_URL;
    private static final String ACCOUNT_USERNAME;
    private static final String ACCOUNT_PASSWORD;
    private static final String ACCOUNT_ID;
    private static User user;

    static {
        String propertyUrl;
        IEclipsePreferences prefs = new DefaultScope().getNode("org.eclipse.core.resources");
        prefs.putBoolean(PROPERTY_KEY, true);
        boolean useProduction = true;
        BASE_URL = useProduction ? ((propertyUrl = System.getProperty(USER_URL_OVERRIDE)) != null && propertyUrl.length() > 0 ? propertyUrl : "https://cloudmanager.aptana.com/cloud") : "https://acotak-staging.aptana.com/cloud";
        USERS = String.valueOf(BASE_URL) + "/users";
        LOGINS = String.valueOf(BASE_URL) + "/logins";
        INSTALL_LOCATION_URL = Platform.getInstallLocation().getURL().toExternalForm();
        ACCOUNT_USERNAME = "com.aptana.ide.core.model.ACCOUNT_USERNAME/" + INSTALL_LOCATION_URL;
        ACCOUNT_PASSWORD = "com.aptana.ide.core.model.ACCOUNT_PASSWORD/" + INSTALL_LOCATION_URL;
        ACCOUNT_ID = "com.aptana.ide.core.model.ACCOUNT_ID/" + INSTALL_LOCATION_URL;
    }

    public static synchronized User getSignedInUser() {
        if (user == null) {
            user = new User(){

                public IServiceErrors commit() {
                    IServiceErrors errors = null;
                    try {
                        ISecurePreferences node = AptanaUser.getSecurePreferences();
                        node.put(ACCOUNT_USERNAME, this.getUsername(), true);
                        node.put(ACCOUNT_PASSWORD, this.getPassword(), true);
                        node.put(ACCOUNT_ID, this.getId(), true);
                    }
                    catch (Exception e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.getString("AptanaUser.Unable_To_Write_User"), e);
                    }
                    errors = super.commit();
                    return errors;
                }

                public IServiceErrors update() {
                    IServiceErrors errors = null;
                    try {
                        ISecurePreferences node = AptanaUser.getSecurePreferences();
                        this.setUsername(node.get(ACCOUNT_USERNAME, null));
                        this.setPassword(node.get(ACCOUNT_PASSWORD, null));
                        this.setId(node.get(ACCOUNT_ID, null));
                    }
                    catch (Exception e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.getString("AptanaUser.Unable_To_Read_User"), e);
                    }
                    errors = super.update();
                    return errors;
                }
            };
            user.update();
            user.setServiceProvider(new RESTServiceProvider());
            AuthenticatedUserRequestBuilder builder = new AuthenticatedUserRequestBuilder();
            builder.setUser(user);
            user.setRequestBuilder(builder);
            try {
                user.setDefaultLocation(new URL(LOGINS));
            }
            catch (MalformedURLException malformedURLException) {}
            if (user.hasCredentials()) {
                Job job = new Job(Messages.getString("AptanaUser.UpdateAptanaID")){

                    protected IStatus run(IProgressMonitor monitor) {
                        user.update();
                        user.update();
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(40);
                job.schedule();
            }
        }
        return user;
    }

    public static void signIn(String username, String password, URL location, String id) {
        AptanaUser.getSignedInUser().suspendEvents();
        AptanaUser.getSignedInUser().setPassword(password);
        AptanaUser.getSignedInUser().setUsername(username);
        AptanaUser.getSignedInUser().setLocation(location);
        AptanaUser.getSignedInUser().setId(id);
        AptanaUser.getSignedInUser().commit();
        AptanaUser.getSignedInUser().update();
        AptanaUser.getSignedInUser().resumeEvents();
    }

    public static void signOut() {
        AptanaUser.getSignedInUser().suspendEvents();
        AptanaUser.getSignedInUser().setPassword("");
        AptanaUser.getSignedInUser().setUsername("");
        AptanaUser.getSignedInUser().setId("");
        AptanaUser.getSignedInUser().setLocation(null);
        AptanaUser.getSignedInUser().clear();
        AptanaUser.getSignedInUser().resumeEvents();
        AptanaUser.getSignedInUser().commit();
    }

    private static ISecurePreferences getSecurePreferences() {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node(SECURE_PREF_NODE);
        return node;
    }
}

