/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import com.aptana.ide.internal.core.CoreMacOSX;
import com.aptana.ide.internal.core.CoreNatives;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;

public final class PlatformUtils {
    public static final String DESKTOP_DIRECTORY = "%DesktopDirectory%";
    public static final String DOCUMENTS_DIRECTORY = "%DocumentsDirectory%";
    public static final String HOME_DIRECTORY = "win32".equals(Platform.getOS()) ? "%USERPROFILE%" : "~";

    private PlatformUtils() {
    }

    public static ProcessItem[] getRunningProcesses() {
        if ("win32".equals(Platform.getOS())) {
            try {
                Object[] namesWithIDs = CoreNatives.GetProcessList();
                if (namesWithIDs != null) {
                    ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                    int i = 0;
                    while (i < namesWithIDs.length - 2) {
                        list.add(new ProcessItem((String)namesWithIDs[i], (Integer)namesWithIDs[i + 1], (Integer)namesWithIDs[i + 2]));
                        i += 3;
                    }
                    return list.toArray(new ProcessItem[list.size()]);
                }
            }
            catch (UnsatisfiedLinkError e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
            }
        } else {
            if ("linux".equals(Platform.getOS())) {
                Process process = null;
                try {
                    String line;
                    process = Runtime.getRuntime().exec("/bin/ps --no-headers xo pid:1,ppid:1,args");
                    InputStream in = process.getInputStream();
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                    ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                    while ((line = reader.readLine()) != null) {
                        int index = line.indexOf(32);
                        if (index <= 0) continue;
                        int pid = Integer.parseInt(line.substring(0, index));
                        if ((index = (line = line.substring(index + 1).trim()).indexOf(32)) <= 0) continue;
                        int ppid = Integer.parseInt(line.substring(0, index));
                        if ((index = (line = line.substring(index + 1).trim()).indexOf(32)) > 0) {
                            line = line.substring(0, index);
                        }
                        list.add(new ProcessItem(line.trim(), pid, ppid));
                    }
                    ProcessItem[] processItemArray = list.toArray(new ProcessItem[list.size()]);
                    return processItemArray;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
            if ("macosx".equals(Platform.getOS())) {
                Process process = null;
                Process process2 = null;
                try {
                    String line;
                    process = Runtime.getRuntime().exec("/usr/bin/perl");
                    InputStream in = process.getInputStream();
                    OutputStream out = process.getOutputStream();
                    String command = "use Mac::Processes; while ( ($psn, $psi) = each(%Process) ) { print GetProcessPID($psi->processNumber).\" \".$psi->processAppSpec.\"\\n\"; }";
                    out.write(command.getBytes("ISO-8859-1"));
                    out.close();
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                    process2 = Runtime.getRuntime().exec("/bin/ps xo pid,ppid");
                    LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(process2.getInputStream(), "ISO-8859-1"));
                    HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                    while ((line = reader2.readLine()) != null) {
                        int index;
                        if (!Character.isDigit((line = line.trim()).charAt(0)) || (index = line.indexOf(32)) <= 0) continue;
                        int pid = Integer.parseInt(line.substring(0, index));
                        line = line.substring(index + 1).trim();
                        int ppid = Integer.parseInt(line);
                        map.put(new Integer(pid), new Integer(ppid));
                    }
                    ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                    while ((line = reader.readLine()) != null) {
                        int index = line.indexOf(32);
                        if (index <= 0) continue;
                        int pid = Integer.parseInt(line.substring(0, index));
                        Integer ppid = (Integer)map.get(new Integer(pid));
                        list.add(new ProcessItem(line.substring(index + 1).trim(), pid, ppid != null ? ppid : 0));
                    }
                    ProcessItem[] processItemArray = list.toArray(new ProcessItem[list.size()]);
                    return processItemArray;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                    if (process2 != null) {
                        process2.destroy();
                    }
                }
            }
        }
        return new ProcessItem[0];
    }

    public static ProcessItem[] getRunningChildProcesses() {
        ProcessItem[] allProcesses;
        int currentPid;
        block19: {
            currentPid = 0;
            allProcesses = PlatformUtils.getRunningProcesses();
            if ("win32".equals(Platform.getOS())) {
                try {
                    currentPid = CoreNatives.GetCurrentProcessId();
                }
                catch (UnsatisfiedLinkError e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
                }
            } else if ("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) {
                Process process = null;
                try {
                    try {
                        String line;
                        process = Runtime.getRuntime().exec("/bin/ps xo ppid,command");
                        InputStream in = process.getInputStream();
                        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = reader.readLine()) != null) {
                            int index = (line = line.trim()).indexOf(32);
                            if (index <= 0) continue;
                            try {
                                int pid = Integer.parseInt(line.substring(0, index));
                                line = line.substring(index + 1).trim();
                                if (!line.startsWith("/bin/ps xo ppid")) continue;
                                currentPid = pid;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    catch (IOException iOException) {
                        if (process != null) {
                            process.destroy();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
        if (currentPid != 0) {
            ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
            int i = 0;
            while (i < allProcesses.length) {
                if (allProcesses[i].parentId == currentPid && allProcesses[i].pid != currentPid) {
                    list.add(allProcesses[i]);
                }
                ++i;
            }
            return list.toArray(new ProcessItem[list.size()]);
        }
        return new ProcessItem[0];
    }

    public static void killProcess(int pid) {
        if (pid == 0) {
            return;
        }
        if ("win32".equals(Platform.getOS())) {
            try {
                CoreNatives.KillProcess(pid);
            }
            catch (UnsatisfiedLinkError e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
            }
        } else if ("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) {
            try {
                Runtime.getRuntime().exec("/bin/kill -9 " + ((long)pid & 0xFFFFFFFFFFFFFFFFL));
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized String expandEnvironmentStrings(String path) {
        String home;
        if ("win32".equals(Platform.getOS())) {
            String desktopDirectory;
            String expanded = CoreNatives.ExpandEnvironmentStrings(path);
            if (expanded != null) {
                path = expanded;
            }
            if (path.startsWith(DESKTOP_DIRECTORY) && (desktopDirectory = CoreNatives.GetSpecialFolderPath(16)) != null) {
                path = String.valueOf(desktopDirectory) + path.substring(DESKTOP_DIRECTORY.length());
            }
        } else if ("macosx".equals(Platform.getOS())) {
            String homeDirectory;
            if (path.startsWith(DESKTOP_DIRECTORY)) {
                String desktopDirectory = CoreMacOSX.FileManager_findFolder(true, "desk");
                if (desktopDirectory != null) {
                    path = String.valueOf(desktopDirectory) + path.substring(DESKTOP_DIRECTORY.length());
                }
            } else if (path.startsWith(DOCUMENTS_DIRECTORY)) {
                String docsDirectory = CoreMacOSX.FileManager_findFolder(true, "docs");
                if (docsDirectory != null) {
                    path = String.valueOf(docsDirectory) + path.substring(DOCUMENTS_DIRECTORY.length());
                }
            } else if (path.startsWith(HOME_DIRECTORY) && (homeDirectory = CoreMacOSX.FileManager_findFolder(true, "cusr")) != null) {
                path = String.valueOf(homeDirectory) + path.substring(HOME_DIRECTORY.length());
            }
        }
        if (path.startsWith("~") && (home = System.getProperty("user.home")) != null) {
            return String.valueOf(home) + path.substring(1);
        }
        return path;
    }

    public static String queryRegestryStringValue(String keyName, String valueName) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegOpenKey(hRootKey, keyName, 131097, hKey)) {
                String[] result = new String[1];
                CoreNatives.RegQueryValue(hKey[0], valueName, result);
                CoreNatives.RegCloseKey(hKey[0]);
                return result[0];
            }
        }
        return null;
    }

    public static boolean setRegestryStringValue(String keyName, String valueName, String value) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegCreateKey(hRootKey, keyName, 131078, hKey)) {
                boolean result = CoreNatives.RegSetValue(hKey[0], valueName, value);
                CoreNatives.RegCloseKey(hKey[0]);
                return result;
            }
        }
        return false;
    }

    public static boolean isUserAdmin() {
        if ("win32".equals(Platform.getOS())) {
            return CoreNatives.IsUserAnAdmin();
        }
        return false;
    }

    public static boolean runAsAdmin(String program, String[] arguments) {
        if ("win32".equals(Platform.getOS())) {
            StringBuffer sb = null;
            if (arguments != null && arguments.length > 0) {
                sb = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    String arg = arguments[i];
                    if (arg.indexOf(32) != -1) {
                        sb.append('\"').append(arg).append('\"');
                    } else {
                        sb.append(arg);
                    }
                    sb.append(' ');
                    ++i;
                }
            }
            return CoreNatives.ShellExecuteEx(program, sb != null ? sb.toString() : null, "runas", null, 1);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String getApplicationInfo(String applicationPath, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getApplicationExecutable(String applicationPath) {
        File file = new File(applicationPath);
        if ("macosx".equals(Platform.getOS())) {
            if (!file.isDirectory()) {
                return file;
            }
            String executable = PlatformUtils.getApplicationInfo(applicationPath, "CFBundleExecutable");
            if (executable != null) {
                File file2 = new File(file, "Contents/MacOSX/" + executable);
                if (file2.exists()) {
                    return file2;
                }
                file2 = new File(file, "Contents/MacOS/" + executable);
                if (file2.exists()) {
                    return file2;
                }
            }
        }
        return file;
    }

    public static class ProcessItem {
        private String executableName;
        private int pid;
        private int parentId;

        private ProcessItem(String executableName, int pid, int parentId) {
            this.executableName = executableName;
            this.pid = pid;
            this.parentId = parentId;
        }

        public String getExecutableName() {
            return this.executableName;
        }

        public int getPid() {
            return this.pid;
        }

        public String toString() {
            return "[" + this.pid + "] " + this.executableName;
        }
    }
}

