/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemContentStamps;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemFile;
import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class UndoFileSystemTextFileChange
extends UndoTextFileChange {
    private File fFile;
    private UndoEdit fUndo;
    private ContentStamp fContentStamp;

    public UndoFileSystemTextFileChange(String name, File file, UndoEdit undo, ContentStamp stamp, int saveMode) {
        super(name, (IFile)new FileSystemFile(file), undo, stamp, saveMode);
        this.fFile = file;
        this.fUndo = undo;
        this.fContentStamp = stamp;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoFileSystemTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.getSaveMode());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        pm.beginTask("", 2);
        ITextFileBuffer buffer = null;
        Path path = new Path(this.fFile.getAbsolutePath());
        try {
            manager.connect((IPath)path, LocationKind.LOCATION, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            buffer = manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
            IDocument document = buffer.getDocument();
            LinkedModeModel.closeAllModels((IDocument)document);
            ContentStamp currentStamp = FileSystemContentStamps.get(this.fFile, document);
            UndoEdit redo = this.fUndo.apply(document, 1);
            boolean success = ContentStamps.set((IDocument)document, (ContentStamp)this.fContentStamp);
            if (this.needsSaving()) {
                buffer.commit(pm, false);
                if (!success) {
                    FileSystemContentStamps.set(this.fFile, this.fContentStamp);
                }
            }
            Change change = this.createUndoChange(redo, currentStamp);
            return change;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException((BadLocationException)e);
        }
        catch (MalformedTreeException e) {
            throw Changes.asCoreException((MalformedTreeException)e);
        }
        catch (CoreException e) {
            throw e;
        }
        finally {
            if (buffer != null) {
                manager.disconnect((IPath)path, LocationKind.LOCATION, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
    }

    private boolean needsSaving() {
        return (this.getSaveMode() & 2) != 0;
    }
}

